#!/usr/bin/perl
#
#####################################################################################################
#
#   				(c) Markus Hoffmann, 2006-open end
#
#####################################################################################################
#
# COPYRIGHT NOTICE                                                        
#
# Copyright 2006 Markus Hoffmann
# All Rights Reserved.                     
# EMail: ipcop@mh-lantech.de
# URL  : http://www.mhaddons.tk
#
# License: CreativeCommons, some right restricted 
#          ( http://creativecommons.org/licenses/by-nd/2.5/ )
#

use strict;
use RRDs;

# enable only the following on debugging purpose
#use warnings;
use CGI::Carp 'fatalsToBrowser';

require '/var/ipcop/general-functions.pl';
require "${General::swroot}/lang.pl";
require "${General::swroot}/header.pl";

&Header::showhttpheaders();
print <<END;
<head>

<script type="text/javascript">
<!--
function BorderOn (id) { id.className='btnOn'  }
function BorderOff(id) { id.className='btnOff' }
//-->
</script>

<style type=text/css>
.btnOn {
        border-right: #D5F0FF 4px Inset;
        border-top: #D5F0FF 4px Inset;
        border-left: #D5F0FF 4px Inset;
        border-bottom: #D5F0FF 4px Inset;
        text-align: Center;
        text-decoration: None;
}

.btnOff {
        border-right: #D5F0FF 4px Outset;
        border-top: #D5F0FF 4px Outset;
        border-left: #D5F0FF 4px Outset;
        border-bottom: #D5F0FF 4px Outset;
        text-align: Center;
        text-decoration: None;
}
</style>

    <link rel="stylesheet" type="text/css" href="/include/jsvall.css" >
    <script language="javascript" src="/include/jsval.js"></script>
<style type="text/css"><!--
.editButton{
border-right: #0000B0 3px inset;
border-top: #429CFF 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #429CFF 3px outset;
color: #00FFFF;
border-bottom: #0000B0 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #364AFE; 
}
-->
</style>
<style type="text/css"><!--
.startButton{
border-right: #007700 3px inset;
border-top: #00FF00 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #00FF00 3px outset;
color: #80FF80;
border-bottom: #007700 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #00C100; 
}
-->
</style>
<style type="text/css"><!--
.stopButton{
border-right: #8A0000 3px inset;
border-top: #FF3535 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #FF3535 3px outset;
color: #FF2B2B;
border-bottom: #8A0000 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #C60000; 
}
-->
</style>
<style type="text/css"><!--
.deleteButton{
border-right: #808080 3px inset;
border-top: #FFFFFF 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #FFFFFF 3px outset;
color: #939393;
border-bottom: #646464 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #000000; 
}
-->
</style>
<style type="text/css"><!--
.statusButton{
border-right: #C46200 3px inset;
border-top: #FFB76F 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #FFB76F 3px outset;
color: #E6E600;
border-bottom: #C46200 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #FF8000; 
}
-->
</style>
<style type="text/css"><!--
.saveButton{
border-style:  3;
border-style:  beveled;
font-weight:Bold;
font-size: 10pt; 
color: #000000;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #6CFFB6; 
}
-->
</style>
</head>
END

my $MODNAME      = "QoS";
my $MODVERSION   = "2.6.6.1";
my @LOCALCHECK   = ();
my @VCHECK       = &checkversion( $MODNAME, $MODVERSION );
my $errormessage = "";
if ( $VCHECK[0] eq "There is a newer version available" )
{
	$errormessage = "There is a newer version available";
}

my $ERROR="";
my $RRDTEMP="";
my $PNGTEMP="";
my $PNGTEMP1="";
my $PNGTEMP2="";
my $PNGTEMP3="";
my $line1="";
my $line2="";
my $line3="";
my $i           = "";
my $bgcolor	  = "";
my $deltmp      = "";
my $rulefile    = "";
my $ruleentry   = ();
my @tmpline     = ();
my @tmp         = ();
my $EXISTS      = "";
my $RCEXIST     = "";
my $c           = ();
my $ready       = ();
my $ruleentry   = "";
my $dir         = "";
my $direntry    = "";
my $tmpline     = "";
my @proto       = ();
my $line        = "";
my @otherrules  = ();
my @temp        = ();
my @l7rules     = ();
my $REDDEVICE   = `cat /var/ipcop/red/iface`;
my %qossettings = ();
my @tcsettings  = ();
$qossettings{'DEV'}        = '';
$qossettings{'L7DEV'}        = '';
$qossettings{'TC'}         = '';
$qossettings{'IP'}         = '';
$qossettings{'IPTABLES'}   = '';
$qossettings{'ACTION'}     = '';
$qossettings{'PROT'}       = '';
$qossettings{'L7PROT'}     = '';
$qossettings{'RULENAME'}   = '';
$qossettings{'L7RULENAME'} = '';
$qossettings{'MARK'}       = '';
$qossettings{'L7MARK'}       = '';
$qossettings{'SPORT'}      = '';
$qossettings{'DPORT'}      = '';
$qossettings{'SOURCE'}     = '';
$qossettings{'DEST'}       = '';
$qossettings{'L7SOURCE'}     = '';
$qossettings{'L7DEST'}       = '';
$qossettings{'L7'}         = '';
$qossettings{'DEL'}        = '';
$qossettings{'ROOTHANDLE'} = '';
$qossettings{'INTERFACE'}  = '';
$qossettings{'TCPROTO'}    = '';
$qossettings{'TCDEFAULTRED'}  = '';
$qossettings{'TCRATERED'}     = '';
$qossettings{'TCDEFAULTIMQ'}  = '';
$qossettings{'TCRATEIMQ'}     = '';
$qossettings{'TCDEFAULTGREEN'}  = '';
$qossettings{'TCRATEGREEN'}     = '';
$qossettings{'TCDEFAULTORANGE'}  = '';
$qossettings{'TCRATEORANGE'}     = '';
$qossettings{'TCDEFAULTBLUE'}  = '';
$qossettings{'TCRATEBLUE'}     = '';
$qossettings{'TCDEFAULT'}  = '';
$qossettings{'TCRATE'}     = '';
$qossettings{'TCSAVE'}     = '';
$qossettings{'TCPARENT'}   = '';
$qossettings{'TCCLASS'}    = '';
$qossettings{'TCPRIO'}     = '';
$qossettings{'TCMIN'}      = '1';
$qossettings{'TCUMAX'}     = '';
$qossettings{'TCMAXDELAY'} = '';
$qossettings{'ROOTHANDLERED'} = '';
$qossettings{'TCCLASSRED'} = '';
$qossettings{'TCPARENTRED'} = '';
$qossettings{'TCPRIORED'} = '';
$qossettings{'TCMINRED'} = '1';
$qossettings{'TCUMAXRED'} = '';
$qossettings{'TCMAXDELAYRED'} = '';
$qossettings{'ROOTHANDLEIMQ'} = '';
$qossettings{'TCCLASSIMQ'} = '';
$qossettings{'TCPARENTIMQ'} = '';
$qossettings{'TCPRIOIMQ'} = '';
$qossettings{'TCMINIMQ'} = '1';
$qossettings{'TCUMAXIMQ'} = '';
$qossettings{'TCMAXDELAYIMQ'} = '';
$qossettings{'ROOTHANDLEGREEN'} = '';
$qossettings{'TCCLASSGREEN'} = '';
$qossettings{'TCPARENTGREEN'} = '';
$qossettings{'TCPRIOGREEN'} = '';
$qossettings{'TCMINGREEN'} = '1';
$qossettings{'TCUMAXGREEN'} = '';
$qossettings{'TCMAXDELAYGREEN'} = '';
$qossettings{'ROOTHANDLEORANGE'} = '';
$qossettings{'TCCLASSORANGE'} = '';
$qossettings{'TCPARENTORANGE'} = '';
$qossettings{'TCPRIOORANGE'} = '';
$qossettings{'TCMINORANGE'} = '1';
$qossettings{'TCUMAXORANGE'} = '';
$qossettings{'TCMAXDELAYORANGE'} = '';
$qossettings{'ROOTHANDLEBLUE'} = '';
$qossettings{'TCCLASSBLUE'} = '';
$qossettings{'TCPARENTBLUE'} = '';
$qossettings{'TCPRIOBLUE'} = '';
$qossettings{'TCPRIOACK'} = '';
$qossettings{'TCMINBLUE'} = '1';
$qossettings{'TCUMAXBLUE'} = '';
$qossettings{'TCMAXDELAYBLUE'} = '';
$qossettings{'TCMAXRATERED'} = '';
$qossettings{'TCMAXRATEIMQ'} = '';
$qossettings{'TCMAXRATEBLUE'} = '';
$qossettings{'TCMAXRATEGREEN'} = '';
$qossettings{'TCMAXRATEORANGE'} = '';
$qossettings{'ACK'} = '';


&Header::getcgihash( \%qossettings );

my %netsettings = ();
&General::readhash( "/var/ipcop/ethernet/settings", \%netsettings );

if (   $qossettings{'ACTION'} eq "start collector" )
{
	system("/bin/touch /var/ipcop/qos/settings/enable_sammler");
	system("/usr/local/bin/qosctrl sammlerstart >/dev/null 2>&1");
	$qossettings{'ACTION'}='';
}

if (   $qossettings{'ACTION'} eq "stop collector" )
{
	unlink "/var/ipcop/qos/settings/enable_sammler";
	system("/usr/local/bin/qosctrl sammlerstop >/dev/null 2>&1");
	$qossettings{'ACTION'}='';
}



if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'ACK'} eq 'YES' )
{
	$rulefile = "/var/ipcop/qos/settings/tc/ack";
	open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
	print FILE <<END;
$qossettings{'TCPRIOACK'}
END
	close FILE;
	system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	$qossettings{'ACK'}='';
	$qossettings{'ACTION'}='';
}

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'TCSAVE'} eq 'CLASS' )
{
	if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLERED'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSRED'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTRED'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIORED'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINRED'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXRED'};
		$qossettings{'TCMAXDELAY'} = $qossettings{'TCMAXDELAYRED'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATERED'};
	}

	if ( $qossettings{'INTERFACE'} eq "imq0" )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEIMQ'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSIMQ'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTIMQ'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOIMQ'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINIMQ'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXIMQ'};
		$qossettings{'TCMAXDELAY'} = $qossettings{'TCMAXDELAYIMQ'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEIMQ'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEGREEN'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSGREEN'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTGREEN'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOGREEN'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINGREEN'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXGREEN'};
		$qossettings{'TCMAXDELAY'} = $qossettings{'TCMAXDELAYGREEN'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEGREEN'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEORANGE'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSORANGE'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTORANGE'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOORANGE'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINORANGE'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXORANGE'};
		$qossettings{'TCMAXDELAY'} = $qossettings{'TCMAXDELAYORANGE'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEORANGE'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEBLUE'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSBLUE'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTBLUE'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOBLUE'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINBLUE'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXBLUE'};
		$qossettings{'TCMAXDELAY'} = $qossettings{'TCMAXDELAYBLUE'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEBLUE'};
	}

	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[1] eq $qossettings{'TCCLASS'} )
		{
			$errormessage = "Class allready in use !";
		}
	}
	if (   $qossettings{'ROOTHANDLE'} eq "" || $qossettings{'TCMAXRATE'} eq '' || $qossettings{'TCCLASS'} eq "" || $qossettings{'TCPARENT'}   eq "" || $qossettings{'TCPRIO'} eq "" || $qossettings{'TCMIN'} eq "" || $qossettings{'TCMAXDELAY'} eq "" )
	{
		$errormessage = "No empty fields allowed !";
	}
	unless ($errormessage)
	{
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'ROOTHANDLE'};$qossettings{'TCCLASS'};$qossettings{'TCPARENT'};$qossettings{'TCPRIO'};$qossettings{'TCMIN'};$qossettings{'TCMAXDELAY'};$qossettings{'TCMAXRATE'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCMAXDELAY'} = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';

		$qossettings{'TCCLASSRED'} = '';
		$qossettings{'TCMINRED'}    = '1';
		$qossettings{'TCMAXDELAYRED'}  = '';
		$qossettings{'TCPRIORED'}     = '';

		$qossettings{'TCCLASSGREEN'} = '';
		$qossettings{'TCMINGREEN'}    = '1';
		$qossettings{'TCMAXDELAYGREEN'}  = '';
		$qossettings{'TCPRIOGREEN'}     = '';

		$qossettings{'TCCLASSBLUE'} = '';
		$qossettings{'TCMINBLUE'}    = '1';
		$qossettings{'TCMAXDELAYBLUE'}  = '';
		$qossettings{'TCPRIOBLUE'}     = '';

		$qossettings{'TCCLASSORANGE'} = '';
		$qossettings{'TCMINORANGE'}    = '1';
		$qossettings{'TCMAXDELAYORANGE'}  = '';
		$qossettings{'TCPRIOORANGE'}     = '';

		$qossettings{'TCCLASSIMQ'} = '';
		$qossettings{'TCMINIMQ'}    = '1';
		$qossettings{'TCMAXDELAYIMQ'}  = '';
		$qossettings{'TCPRIOIMQ'}     = '';

		$qossettings{'TCMAXRATERED'} = '';
		$qossettings{'TCMAXRATEIMQ'} = '';
		$qossettings{'TCMAXRATEBLUE'} = '';
		$qossettings{'TCMAXRATEGREEN'} = '';
		$qossettings{'TCMAXRATEORANGE'} = '';

		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	}
}

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
{
	if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTRED'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATERED'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLERED'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTORED'};
	}

	if ( $qossettings{'INTERFACE'} eq "imq0" )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTIMQ'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEIMQ'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEIMQ'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOIMQ'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTGREEN'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEGREEN'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEGREEN'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOGREEN'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTORANGE'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEORANGE'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEORANGE'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOORANGE'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTBLUE'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEBLUE'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEBLUE'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOBLUE'};
	}

	if (   $qossettings{'INTERFACE'} eq "" || $qossettings{'ROOTHANDLE'} eq "" || $qossettings{'TCPROTO'}    eq "" || $qossettings{'TCDEFAULT'}  eq "" || $qossettings{'TCRATE'}     eq "" )
	{
		$errormessage = "No empty fields allowed !                $qossettings{'INTERFACE'}";
	}
	unless ($errormessage)
	{
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'INTERFACE'};$qossettings{'ROOTHANDLE'};$qossettings{'TCPROTO'};$qossettings{'TCDEFAULT'};$qossettings{'TCRATE'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCMAXDELAY'} = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';
		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
#		system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	}
}

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'L7'} eq 'yes' )
{
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[1] eq $qossettings{'L7MARK'} )
		{
			$errormessage = "match";
		}
	}
	if ( $errormessage eq "match" )
	{
		$errormessage = "";
	}
	else
	{
		$errormessage = "No class found for mark !";
	}
	if ( $qossettings{'L7SOURCE'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'L7SOURCE'})) { $errormessage = $Lang::tr{'source ip bad'}; }
	}
	if ( $qossettings{'L7DEST'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'L7DEST'})) { $errormessage = $Lang::tr{'destination ip bad'}; }
	}
	$rulefile = "/var/ipcop/qos/settings/layer7/rules";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq $qossettings{'L7RULENAME'} )
		{
			$errormessage = "Rulename allready in use !";
		}
	}
	if ($qossettings{'L7DEV'} eq $REDDEVICE)
	{
		if ($qossettings{'L7MARK'} lt 100 || $qossettings{'L7MARK'} ge 200)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'L7DEV'} eq "imq0")
	{
		if ($qossettings{'L7MARK'} lt 200 || $qossettings{'L7MARK'} ge 300)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'L7DEV'} eq $netsettings{'GREEN_DEV'})
	{
		if ($qossettings{'L7MARK'} lt 300 || $qossettings{'L7MARK'} ge 400)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'L7DEV'} eq $netsettings{'GREEN_BLUE'})
	{
		if ($qossettings{'L7MARK'} lt 500 || $qossettings{'L7MARK'} ge 600)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'L7DEV'} eq $netsettings{'ORANGE_DEV'})
	{
		if ($qossettings{'L7MARK'} lt 400 || $qossettings{'L7MARK'} ge 500)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
		}
	}

	if ( $qossettings{'L7RULENAME'} =~ " " )
	{
		$errormessage = "No spaces allowed in Rulename !";
	}
	
	if ( length($qossettings{'L7RULENAME'}) > 15 )
	{
		$errormessage = "Rulename to long, only 15 chars allowed !";
	}

	unless ($errormessage)
	{
		$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'L7RULENAME'};$qossettings{'L7PROT'};$qossettings{'L7MARK'};$qossettings{'L7DEV'};$qossettings{'L7SOURCE'};$qossettings{'L7DEST'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'L7MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'L7SOURCE'}     = '';
		$qossettings{'L7DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'L7DEV'}        = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCMAXDELAY'} = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';
		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	}
}

if ( $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'L7'} eq 'no' )
{
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[1] eq $qossettings{'MARK'} )
		{
			$errormessage = "match";
		}
	}
	if ( $errormessage eq "match" )
	{
		$errormessage = "";
	}
	else
	{
		$errormessage = "No class found for mark !";
	}
	$rulefile = "/var/ipcop/qos/settings/other/rules";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq $qossettings{'RULENAME'} )
		{
			$errormessage = "Rulename allready in use !";
		}
	}
	if ( $qossettings{'SOURCE'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'SOURCE'})) { $errormessage = $Lang::tr{'source ip bad'}; }
	}
	if ( $qossettings{'DEST'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'DEST'})) { $errormessage = $Lang::tr{'destination ip bad'}; }
	}
	if ( $qossettings{'SPORT'} ne '' )
	{ 
		unless(&General::validport($qossettings{'SPORT'}) || &General::validportrange($qossettings{'SPORT'}, 'src')) { $errormessage = "invalid $Lang::tr{'src port'}(s)"; }
	}
	if ( $qossettings{'DPORT'} ne '' )
	{ 
		unless(&General::validport($qossettings{'DPORT'}) || &General::validportrange($qossettings{'DPORT'}, 'dest')) { $errormessage = "invalid $Lang::tr{'dst port'}(s)"; }
	}

	if ( $qossettings{'DPORT'} ne '' && $qossettings{'SPORT'} ne '')
	{ 
		if ( $qossettings{'DPORT'} =~ "\," || $qossettings{'SPORT'} =~ "\," )
		{
			$errormessage = "You could not use sourceports and destination ports if you are using multiple ports!";
		}
		if ( $qossettings{'DPORT'} =~ "\:" || $qossettings{'SPORT'} =~ "\:" || $qossettings{'DPORT'} =~ "\-" || $qossettings{'SPORT'} =~ "\-")
		{
			$errormessage = "You could not use portranges if you are using source- and destinationports!";
		}
	}

	if ($qossettings{'DEV'} eq $REDDEVICE)
	{
		if ($qossettings{'MARK'} lt 100 || $qossettings{'MARK'} ge 200)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'DEV'} eq "imq0")
	{
		if ($qossettings{'MARK'} lt 200 || $qossettings{'MARK'} ge 300)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'DEV'} eq $netsettings{'GREEN_DEV'})
	{
		if ($qossettings{'MARK'} lt 300 || $qossettings{'MARK'} ge 400)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'DEV'} eq $netsettings{'GREEN_BLUE'})
	{
		if ($qossettings{'MARK'} lt 500 || $qossettings{'MARK'} ge 600)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
		}
	}
	if ($qossettings{'DEV'} eq $netsettings{'ORANGE_DEV'})
	{
		if ($qossettings{'MARK'} lt 400 || $qossettings{'MARK'} ge 500)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
		}
	}

	if ( $qossettings{'RULENAME'} =~ " " )
	{
		$errormessage = "No spaces allowed in Rulename !";
	}
	
	if ( length($qossettings{'RULENAME'}) > 15 )
	{
		$errormessage = "Rulename to long, only 15 chars allowed !";
	}

	if ( $qossettings{'SPORT'} ne '' || $qossettings{'DPORT'} ne '' )
	{
		if ( $qossettings{'PROT'} ne 'tcp' && $qossettings{'PROT'} ne 'udp' )
		{
			$errormessage = "You could not set ports when you use protocols other then tcp or udp !";
			$qossettings{'TODO'} = "add rule";
		}
	}

	unless ($errormessage)
	{
		$qossettings{'SPORT'} =~ tr/-/:/; # replace all - with colons just in case someone used -
		$qossettings{'SPORT'} =~ s/\ \:\ /\:/; # replace all spaces
		$qossettings{'DPORT'} =~ tr/-/:/; # replace all - with colons just in case someone used -
		$qossettings{'DPORT'} =~ s/\ \:\ /\:/; # replace all spaces
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'RULENAME'};$qossettings{'PROT'};$qossettings{'MARK'};$qossettings{'SPORT'};$qossettings{'DPORT'};$qossettings{'SOURCE'};$qossettings{'DEST'};$qossettings{'DEV'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCMAXDELAY'} = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';
		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	}
}

if ( $qossettings{'ACTION'} eq $Lang::tr{'delete'} )
{
	if ( $qossettings{'L7'} ne '' || $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
	{
		if ( $qossettings{'L7'} eq 'no' )
		{
			$rulefile = "/var/ipcop/qos/settings/other/rules";
		}
		if ( $qossettings{'L7'} eq 'yes' )
		{
			$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		}
		if ( $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
		{
			$rulefile = "/var/ipcop/qos/settings/tc/settings";
		}
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		$deltmp="";
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;
	}

	if ( $qossettings{'TCSAVE'} eq 'CLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;
	}
	&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
	my $failed="";
	my $CHECK=$qossettings{'DEL'} / 100;
	$CHECK = substr($CHECK, 0, 1); 
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq $CHECK )
		{
			$failed="ok";
		}
	}
	if ( $failed eq "ok" )
	{
		system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	}
}


if ( $qossettings{'ACTION'} eq $Lang::tr{'edit'} )
{
	if ( $qossettings{'L7'} eq 'no' )
	{
		$rulefile = "/var/ipcop/qos/settings/other/rules";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
			else
			{
			$qossettings{'RULENAME'}=$tmpline[0];
			$qossettings{'PROT'}=$tmpline[1];
			$qossettings{'MARK'}=$tmpline[2];
			$qossettings{'SPORT'}=$tmpline[3];
			$qossettings{'SPORT'} =~ s/\:/\ \:\ /; # set all spaces
			$qossettings{'DPORT'}=$tmpline[4];
			$qossettings{'DPORT'} =~ s/\:/\ \:\ /; # set all spaces
			$qossettings{'SOURCE'}=$tmpline[5];
			$qossettings{'DEST'}=$tmpline[6];
			$qossettings{'DEV'}=$tmpline[7];
			}
		}
		close FILE;
	}

	if ( $qossettings{'L7'} eq 'yes' )
	{
		$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
			else
			{
			$qossettings{'L7RULENAME'}=$tmpline[0];
			$qossettings{'L7PROT'}=$tmpline[1];
			$qossettings{'L7MARK'}=$tmpline[2];
			$qossettings{'L7DEV'}=$tmpline[3];
			$qossettings{'L7SOURCE'}=$tmpline[4];
			$qossettings{'L7DEST'}=$tmpline[5];
			}
		}
		close FILE;
	}

	if ( $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
			foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
			else
			{
				$qossettings{'INTERFACE'}=$tmpline[0];
				if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
				{
					$qossettings{'TCDEFAULTRED'} = $tmpline[3];
					$qossettings{'TCRATERED'} = $tmpline[4];
				}


				if ( $qossettings{'INTERFACE'} eq "imq0" )
				{
					$qossettings{'TCDEFAULTIMQ'} = $tmpline[3];
					$qossettings{'TCRATEIMQ'} = $tmpline[4];
				}

				if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
				{
					$qossettings{'TCDEFAULTGREEN'} = $tmpline[3];
					$qossettings{'TCRATEGREEN'} = $tmpline[4];
				}

				if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
				{
					$qossettings{'TCDEFAULTORANGE'} = $tmpline[3];
					$qossettings{'TCRATEORANGE'} = $tmpline[4];
				}

				if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
				{
					$qossettings{'TCDEFAULTBLUE'} = $tmpline[3];
					$qossettings{'TCRATEBLUE'} = $tmpline[4];
				}
			}
		}
		close FILE;
	}

	if ( $qossettings{'TCSAVE'} eq 'CLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
			else
			{
				if ( $qossettings{'DEL'} ge "100" && $qossettings{'DEL'} le "199" )
				{
					$qossettings{'TCCLASSRED'}=$tmpline[1];
					$qossettings{'TCPRIORED'}=$tmpline[3];
					$qossettings{'TCMINRED'}=$tmpline[4];
					$qossettings{'TCMAXDELAYRED'}=$tmpline[5];
					$qossettings{'TCMAXRATERED'}=$tmpline[6];
				}


				if ( $qossettings{'DEL'} ge "200" && $qossettings{'DEL'} le "299" )
				{
					$qossettings{'TCCLASSIMQ'}=$tmpline[1];
					$qossettings{'TCPRIOIMQ'}=$tmpline[3];
					$qossettings{'TCMINIMQ'}=$tmpline[4];
					$qossettings{'TCMAXDELAYIMQ'}=$tmpline[5];
					$qossettings{'TCMAXRATEIMQ'}=$tmpline[6];
				}

				if ( $qossettings{'DEL'} ge "300" && $qossettings{'DEL'} le "399" )
				{
					$qossettings{'TCCLASSGREEN'}=$tmpline[1];
					$qossettings{'TCPRIOGREEN'}=$tmpline[3];
					$qossettings{'TCMINGREEN'}=$tmpline[4];
					$qossettings{'TCMAXDELAYGREEN'}=$tmpline[5];
					$qossettings{'TCMAXRATEGREEN'}=$tmpline[6];
				}

				if ( $qossettings{'DEL'} ge "400" && $qossettings{'DEL'} le "499" )
				{
					$qossettings{'TCCLASSORANGE'}=$tmpline[1];
					$qossettings{'TCPRIOORANGE'}=$tmpline[3];
					$qossettings{'TCMINORANGE'}=$tmpline[4];
					$qossettings{'TCMAXDELAYORANGE'}=$tmpline[5];
					$qossettings{'TCMAXRATEORANGE'}=$tmpline[6];
				}

				if ( $qossettings{'DEL'} ge "500" && $qossettings{'DEL'} le "599" )
				{
					$qossettings{'TCCLASSBLUE'}=$tmpline[1];
					$qossettings{'TCPRIOBLUE'}=$tmpline[3];
					$qossettings{'TCMINBLUE'}=$tmpline[4];
					$qossettings{'TCMAXDELAYBLUE'}=$tmpline[5];
					$qossettings{'TCMAXRATEBLUE'}=$tmpline[6];
				}
			}
		}
		close FILE;
	}
	&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
}


#&General::readhash( "${General::swroot}/qos/settings/settings", \%qossettings );
if ( $REDDEVICE eq "ppp0" )
{
	if ( $qossettings{'TCUMAXRED'} eq '' )
	{
		$qossettings{'TCUMAXRED'} = "1492";
	}
	if ( $qossettings{'TCUMAXIMQ'} eq '' )
	{
		$qossettings{'TCUMAXIMQ'} = "1492";
	}
}
else
{
	if ( $qossettings{'TCUMAXRED'} eq '' )
	{
		$qossettings{'TCUMAXRED'} = "1500";
	}
	if ( $qossettings{'TCUMAXIMQ'} eq '' )
	{
		$qossettings{'TCUMAXIMQ'} = "1500";
	}
}

if ( $qossettings{'TCUMAXGREEN'} eq '' )
{
	$qossettings{'TCUMAXGREEN'} = "1500";
}
if ( $qossettings{'TCUMAXORANGE'} eq '' )
{
	$qossettings{'TCUMAXORANGE'} = "1500";
}
if ( $qossettings{'TCUMAXBLUE'} eq '' )
{
	$qossettings{'TCUMAXBLUE'} = "1500";
}

print "<a name='top'>";
&Header::openpage( 'QoS', 1, '' );

&Header::openbigbox( '100%', 'left', '', $errormessage );
if ( $VCHECK[0] eq "There is a newer version available" )
{
	print <<END;
<table CELLSPACING='0' cellpadding='0' width="100%" bgcolor="#ff0000">
<tr>
	<td align="center" width="25%"><b>modname</b></td>
	<td align="center" width="25%"><b>local version</b></td>
	<td align="center" width="25%"><b>online version</b></td>
	<td align="center" width="25%"><b>status</b></td>
<tr>
&nbsp;
<tr>
	<td align="center" width="25%"><b><a href='http://mh-lantech.css-hamburg.de/ipcop/download.php?view.192' target='_blank'>$MODNAME</a></b></td>
	<td align="center" width="25%"><b>$MODVERSION</b></td>
	<td align="center" width="25%"><b><a href='http://mh-lantech.css-hamburg.de/ipcop/request.php?192' target='_blank'>$VCHECK[1]</a></b></td>
	<td align="center" width="25%"><b>$VCHECK[0]<b></td>
<tr>
<tr><td>&nbsp;</td></tr>
</table>
END
}

if ( $errormessage ne "" )
{
	&Header::openbox( '100%', 'left', "$Lang::tr{'error messages'}" );
	print "<b>$errormessage</b>\n";
	&Header::closebox();
}

if ( $qossettings{'ACTION'} eq "show graphs" )
{
print "<div align='center'><pre>";
my @line=();
my $classnumber="";
my @classes1 = `/var/ipcop/qos/bin/tc -s -d filter show dev $REDDEVICE 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes2 = `/var/ipcop/qos/bin/tc -s -d filter show dev imq0 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes3 = `/var/ipcop/qos/bin/tc -s -d filter show dev $netsettings{'GREEN_DEV'} 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes4 = `/var/ipcop/qos/bin/tc -s -d filter show dev $netsettings{'BLUE_DEV'} 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes5 = `/var/ipcop/qos/bin/tc -s -d filter show dev $netsettings{'ORANGE_DEV'} 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes = split( /\ /, "@classes1 @classes2 @classes3 @classes4 @classes5" );
foreach my $classnumber ( sort @classes )
{
			next if $classnumber == "";
			my $tempclassnumber=$classnumber;
			chomp ($tempclassnumber);
      			print "<br><b><font size='+1' color='#ff0000'><div align='center'>\|$tempclassnumber\|</div></font><b><br><br>";
			@line=split( /\:/, $classnumber);
			$line=$line[1];
			$line1 = $line;
			chomp ($line1);
			$line1 .= "_1";
			$line2 = $line;
			chomp ($line2);
			$line2 .= "_2";
			$line3 = $line;
			chomp ($line3);
			$line3 .= "_3";

			$RRDTEMP = "/var/log/rrd/";
			$RRDTEMP .= $line;
			chomp ($RRDTEMP);
			$RRDTEMP .= ".rrd";

			$PNGTEMP = "/home/httpd/html/qos/";
			$PNGTEMP .= "$line";
			chomp ($PNGTEMP);
			$PNGTEMP .= ".png";
	
			unlink $PNGTEMP;
		
		        RRDs::graph ("$PNGTEMP",
              		  "--start", "-3240", "-aPNG", "-i", "-z",
		                "--alt-y-grid", "-w 980", "-h 150", "-r",
              		  "--color", "SHADEA#EAE9EE",
		                "--color", "SHADEB#EAE9EE",
              		  "--color", "BACK#EAE9EE",
		                "-t | packets | dropped | overlimits |",
              		  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
		                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
              		  "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
		                "AREA:pkts#00FFFF:packets",
              		  "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
		                "LINE3:dropped#FF0000:dropped",
              		  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
		                "LINE3:overlimit#0000FF:overlimit",
              		  "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
		                );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

			$PNGTEMP1 = "/home/httpd/html/qos/";
			$PNGTEMP1 .= "$line1";
			$PNGTEMP1 .= ".png";

			unlink $PNGTEMP1;

		        RRDs::graph ("$PNGTEMP1",
		                "--start", "-3240", "-aPNG", "-i", "-z",
              		  "--alt-y-grid", "-w 450", "-h 150", "-r",
		                "--color", "SHADEA#EAE9EE",
              		  "--color", "SHADEB#EAE9EE",
		                "--color", "BACK#EAE9EE",
		                "-t | period |",
		                "DEF:period=$RRDTEMP:period:AVERAGE",
              		  "AREA:period#99ff99:period",
				  "GPRINT:period:LAST:period\\:%8.3lf %s packets\\j",
              		  );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

			$PNGTEMP2 = "/home/httpd/html/qos/";
			$PNGTEMP2 .= "$line2";
			$PNGTEMP2 .= ".png";

			unlink $PNGTEMP2;

		        RRDs::graph ("$PNGTEMP2",
		                "--start", "-3240", "-aPNG", "-i", "-z",
              		  "--alt-y-grid", "-w 450", "-h 150", "-r",
		                "--color", "SHADEA#EAE9EE",
              		  "--color", "SHADEB#EAE9EE",
		                "--color", "BACK#EAE9EE",
		                "-t | work |",
		                "DEF:work=$RRDTEMP:work:AVERAGE",
		                "AREA:work#cc99cc:work",
				  "GPRINT:work:LAST:work\\:%8.3lf %s\\j",
		                );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:dropped'><img src='/qos/$line.png' border='0' /></a><br />";
		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:period'><img src='/qos/$line1.png' border='0' /></a>";
		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:work'><img src='/qos/$line2.png' border='0' /></a><hr />";
			}
	print "</div></pre>";
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}


print <<END
<table CELLSPACING='0' cellpadding='0' width='100%' border='0'>
<tr><td align='left'>
    <a href='#addclasses'>$Lang::tr{'qoslink add classes'}</a> |
    <a href='#addrules'>$Lang::tr{'qoslink add rules'}</a> |
    <a href='#addl7rules'>$Lang::tr{'qoslink add l7 rules'}</a> |
    <a href='#deleterclasses'>$Lang::tr{'qoslink delete rootclasses'}</a> |
    <a href='#deleteclasses'>$Lang::tr{'qoslink delete classes'}</a> |
    <a href='#deleterules'>$Lang::tr{'qoslink delete rules'}</a> |
    <a href='#deletel7rules'>$Lang::tr{'qoslink delete l7 rules'}</a> 
</td><td align='right'><b><font color='#6500CA'>Version: $MODVERSION</font></b></tr></table>
<a name="$Lang::tr{'settings'}">
END
  ;

my %selected = ();
$selected{'PROT'}{'udp'}                  = '';
$selected{'PROT'}{'tcp'}                  = '';
$selected{'PROT'}{ $qossettings{'PROT'} } = "selected";
$dir                                      = "/etc/l7-protocols/protocols";
opendir( DIR, "$dir" );
foreach $direntry ( readdir(DIR) )
{
	next if $direntry eq ".";
	next if $direntry eq "..";
	next if -d "$dir/$direntry";
	@proto = split( /\./, $direntry );
	$selected{'L7PROT'}{'$proto[0]'} = '';
}
$selected{'L7PROT'}{ $qossettings{'L7PROT'} } = "selected";
for ( $c = 1 ; $c <= 100 ; $c++ )
{
	$selected{'MARK'}{'$c'} = '';
}
$selected{'MARK'}{ $qossettings{'MARK'} } = "selected";
for ( $c = 100 ; $c <= 199 ; $c++ )
{
	$selected{'TCDEFAULT'}{'$c'} = '';
}
$selected{'TCDEFAULT'}{ $qossettings{'TCDEFAULT'} } = "TCDEFAULT";
for ( $c = 100 ; $c <= 199 ; $c++ )
{
	$selected{'TCCLASS'}{'$c'} = '';
}
$selected{'TCCLASS'}{ $qossettings{'TCCLASS'} } = "TCCLASS";
for ( $c = 1 ; $c <= 7 ; $c++ )
{
	$selected{'TCPRIO'}{'$c'} = '';
}
$selected{'TCPRIO'}{ $qossettings{'TCPRIO'} } = "TCPRIO";

if ( $qossettings{'ACTION'} eq "test" )
{
	&Header::openbox( '100%', 'left', 'QoS Test' );
	print "<pre><b>";
	system("/usr/local/bin/qosctrl test");
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'>Back</a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Zahlen Sie mit PayPal - schnell, kostenlos und sicher!">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "status" )
{
	print "<a name='log'>";
	&Header::openbox( '100%', 'left', 'log' );
	print "<pre>";
	print "Status:\n<hr>\n";
	system("/usr/local/bin/qosctrl status");
	print "<hr>\nLog:\n<hr>";
	$rulefile = "/var/ipcop/qos/settings/log.txt";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (@tmp)
	{
		print "<b>$ruleentry</b>";
	}
	print "<hr>\n";
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'>Back</a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Zahlen Sie mit PayPal - schnell, kostenlos und sicher!">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "start" )
{
	system("/bin/touch /var/ipcop/qos/settings/enable");
	&Header::openbox( '100%', 'left', 'Run QoS' );
	print "<pre>";
	system("/usr/local/bin/qosctrl start");	
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'>Back</a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Zahlen Sie mit PayPal - schnell, kostenlos und sicher!">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "restart" )
{
	&Header::openbox( '100%', 'left', 'Run QoS' );
	print "<pre>";
	system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	print "<b>QoS has been restartet</b>";	
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'>Back</a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Zahlen Sie mit PayPal - schnell, kostenlos und sicher!">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "stop" )
{
	unlink "/var/ipcop/qos/settings/enable";
	&Header::openbox( '100%', 'left', 'Stop QoS' );
	print "<pre>";
	system("/usr/local/bin/qosctrl stop");	
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'>Back</a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Zahlen Sie mit PayPal - schnell, kostenlos und sicher!">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

my $sammler_running=`ps -A|grep sammler.pl|awk '{print \$1}'`;

$rulefile = "/var/ipcop/qos/settings/tc/classes";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
@tmpline = split( /\;/, $tmp[0] );
if ( $tmpline[0] ne "" )
{
	$ready = "yes";
	print "<a name='controll'>";
	&Header::openbox( '100%', 'left', "$Lang::tr{'qos control qos'}" );
	print "<form method='post' action='$ENV{'SCRIPT_NAME'}'>\n";
	if ( -e "/var/ipcop/qos/settings/enable" )
	{
		print <<END;
		<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='16.66%' align='center'>
			<input type='submit' name='ACTION' value='stop' class="stopButton" />
			</td>
			<td width='16.66%' align='center'>
			<input type='submit' name='ACTION' value='test' class="statusButton" />
			</td>
			<td width='16.66%' align='center'>
			<input type='submit' name='ACTION' value='restart' class="startButton" />
			</td>
			<td width='16.66%' align='center'>
			<input type='submit' name='ACTION' value='status' class="statusButton" />
			</td>
END
			if ( "x$sammler_running" ne "x" )
			{
				print "<td align='center' width='16.66%'>	<input type='submit' name='ACTION' value='show graphs' class='statusButton' /></td>";
				print "<td align='center' width='16.66%'>	<input type='submit' name='ACTION' value='stop collector' class='stopButton' /></td>";
			}
			else
			{
				print "<td align='center' width='16.66%'>	&nbsp;</td>";
				print "<td align='center' width='16.66%'>	<input type='submit' name='ACTION' value='start collector' class='startButton' /></td>";
			}
			print <<END;
		</tr>
		</table>
END
	}
else
	{
		print <<END;
		<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='33.33%' align='center'>
			<input type='submit' name='ACTION' value='start' class="startButton" />
			</td>
			<td width='33.33%' align='center'>
			<input type='submit' name='ACTION' value='test' class="statusButton" />
			</td>
			<td width='33.33%' align='center'>
			<input type='submit' name='ACTION' value='status' class="statusButton" />
			</td>
		</tr>
		</table>
END
	}
	print "</form>\n";
	&Header::closebox();
}

print "<a name='addclasses'>";
&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos add classes'} $REDDEVICE</font>" );
print <<END;
<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
END
$rulefile = "/var/ipcop/qos/settings/tc/settings";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
$RCEXIST = "";
foreach $tmpline (sort @tmp)
{
	@tcsettings = split( /\;/, $tmpline );
	if ( $tcsettings[0] eq "$REDDEVICE" )
	{
		$RCEXIST                   = "YES";
		$qossettings{'ROOTHANDLERED'} = $tcsettings[1];
		$qossettings{'INTERFACE'}  = $tcsettings[0];
		$qossettings{'TCPROTORED'}    = $tcsettings[2];
		$qossettings{'TCDEFAULTRED'}  = $tcsettings[3];
		$qossettings{'TCRATERED'}     = $tcsettings[4];
	}
}
if ( $RCEXIST ne "YES" )
{
	print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
		<td width='20%' align='left'> $REDDEVICE</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>
	<tr>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>	
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>		
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos default class'}:</td>
		<td width='20%' align='left'><select name='TCDEFAULTRED' err="please select a valid default class!" required="1" exclude="-1" >
END
	print "<option value=$qossettings{'TCDEFAULTRED'} $selected{'TCDEFAULTRED'}{$qossettings{'TCDEFAULTRED'}}>$qossettings{'TCDEFAULTRED'}</option>";
	print "<option value='-1'> </option>";
	for ( $c = 100 ; $c <= 199 ; $c++ )
	{
		print "<option value='$c' $selected{'TCDEFAULTRED'}{'$c'}>$c</option>";
	}
	print <<END;
		</select></td>
		<td width='60%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos upload in kbit'}:</td>
		<td width='20%' align='left'><input type='text' name='TCRATERED' value="$qossettings{'TCRATERED'}" err="please enter a valid upload speed!" required="1" /></td>
		<td width='60%' align='left'>( $Lang::tr{'qos max ul speed'} )</td>
	</tr>
	<tr>
		<td width='20%' align='center'>&nbsp;</td>
		<td width='20%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLERED' value='1' />
			<input type='hidden' name='INTERFACE' value='$REDDEVICE' />
			<input type='hidden' name='TCPROTORED' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
		</td>
		<td width='60%' align='center'>&nbsp;</td>
	</tr>
	</table>
END
}
if ( $RCEXIST eq "YES" )
{
	print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
		<td width='20%' align='left'><select name='TCCLASSRED' err="please enter a valid class!" required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCCLASSRED'} $selected{'TCCLASSRED'}{$qossettings{'TCCLASSRED'}}>$qossettings{'TCCLASSRED'}</option>";
	print "<option value='-1'> </option>";
	print "<option value=$qossettings{'TCCLASSRED'} $selected{'TCCLASSRED'}{$qossettings{'TCCLASSRED'}}>$qossettings{'TCCLASSRED'}</option>";
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	for ( $c = 100 ; $c <= 199 ; $c++ )
	{
		$EXISTS = "no";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
		}
		if ( $EXISTS ne "yes" )
		{
			print "<option value='$c' $selected{'TCCLASSRED'}{'$c'}>$c</option>";
		}
	}
	print <<END;
		</select></td>
END
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq "$REDDEVICE" )
		{
			print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
		}
	}
	print <<END;
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
		<td width='20%' align='left'><select name='TCPRIORED' err="please enter a valid priority!" required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCPRIORED'} $selected{'TCPRIORED'}{$qossettings{'TCPRIORED'}}>$qossettings{'TCPRIORED'}</option>";
	print "<option value='-1'> </option>";
	for ( $c = 1 ; $c <= 7 ; $c++ )
	{
		print "<option value='$c' $selected{'TCPRIORED'}{'$c'}>$c</option>";
	}
	print <<END;
		</select></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos minimum upload'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMINRED' value="$qossettings{'TCMINRED'}" err="please enter a valid upload speed!" required="1" /></td>
		<td width='60%' align='left'>( $Lang::tr{'qos upload interface'} )</td>
	</tr>
END
if ( $REDDEVICE eq "ppp0" )
{
#print <<END;
#	<tr>
#		<td width='20%' align='right'>MTU:</td>
#		<td width='20%' align='left'><input type='text' name='TCUMAXRED' value="$qossettings{'TCUMAXRED'}" err="please enter a valid MTU !" required="1" /></td>
#		<td width='60%' align='left'>( $Lang::tr{'qos default for'} $REDDEVICE: 1492 )</td>
#	</tr>
#END
}
else
{
#print <<END;
#	<tr>
#		<td width='20%' align='right'>MTU:</td>
#		<td width='20%' align='left'><input type='text' name='TCUMAXRED' value="$qossettings{'TCUMAXRED'}" err="please enter a valid MTU !" required="1" /></td>
#		<td width='60%' align='left'>( $Lang::tr{'qos default for'} $REDDEVICE: 1500 )</td>
#	</tr>
#END
}
print <<END;
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max delay'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXDELAYRED' value="$qossettings{'TCMAXDELAYRED'}" err="please enter a valid delay !" required="1" /></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max ul rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATERED' value="$qossettings{'TCMAXRATERED'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='60%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLERED' value='1' />
			<input type='hidden' name='TCPARENTRED' value='1' />
			<input type='hidden' name='INTERFACE' value='$REDDEVICE' />
			<input type='hidden' name='TCPROTORED' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='CLASS' />
		</td>
	</tr>
	</table>
END
}
print "</form>\n";
&Header::closebox();

&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos add classes'} imq0</font>" );
print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
$rulefile = "/var/ipcop/qos/settings/tc/settings";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
$RCEXIST = "";
foreach $tmpline (sort @tmp)
{
	@tcsettings = split( /\;/, $tmpline );
	if ( $tcsettings[0] eq "imq0" )
	{
		$RCEXIST                   = "YES";
		$qossettings{'ROOTHANDLEIMQ'} = $tcsettings[1];
		$qossettings{'INTERFACE'}  = $tcsettings[0];
		$qossettings{'TCPROTOIMQ'}    = $tcsettings[2];
		$qossettings{'TCDEFAULTIMQ'}  = $tcsettings[3];
		$qossettings{'TCRATEIMQ'}     = $tcsettings[4];
	}
}
if ( $RCEXIST ne "YES" )
{
	print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
		<td width='20%' align='left'> imq0</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>	
	<tr>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>	
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>	
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos default class'}:</td>
		<td width='20%' align='left'><select name='TCDEFAULTIMQ' err="please select a valid default class !" required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCDEFAULTIMQ'} $selected{'TCDEFAULTIMQ'}{$qossettings{'TCDEFAULTIMQ'}}>$qossettings{'TCDEFAULTIMQ'}</option>";
 	print "<option value='-1'> </option>";
	for ( $c = 200 ; $c <= 299 ; $c++ )
	{
		print "<option value='$c' $selected{'TCDEFAULTIMQ'}{'$c'}>$c</option>";
	}
	print <<END;
		</select></td>
		<td width='60%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos download in kbit'}:</td>
		<td width='20%' align='left'><input type='text' name='TCRATEIMQ' value="$qossettings{'TCRATEIMQ'}"  err="please enter a valid download speed!" required="1"/></td>
		<td width='60%' align='left'>( $Lang::tr{'qos max dl speed'} )</td>
	</tr>
	<tr>
		<td width='20%' align='center'>&nbsp;</td>
		<td width='20%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLEIMQ' value='2' />
			<input type='hidden' name='INTERFACE' value='imq0' />
			<input type='hidden' name='TCPROTOIMQ' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
		</td>
		<td width='60%' align='center'>&nbsp;</td>
	</tr>
	</table>
END
}
if ( $RCEXIST eq "YES" )
{
	print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
		<td width='20%' align='left'><select name='TCCLASSIMQ' err="please enter a valid class !" required="1" exclede="-1">
END
	print "<option value=$qossettings{'TCCLASSIMQ'} $selected{'TCCLASSIMQ'}{$qossettings{'TCCLASSIMQ'}}>$qossettings{'TCCLASSIMQ'}</option>";
 	print "<option value='-1'> </option>";
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	for ( $c = 200 ; $c <= 299 ; $c++ )
	{
		$EXISTS = "no";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
		}
		if ( $EXISTS ne "yes" )
		{
			print "<option value='$c' $selected{'TCCLASSIMQ'}{'$c'}>$c</option>";
		}
	}
	print <<END;
  	</select></td>
END
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq "imq0" )
		{
			print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
		}
	}
	print <<END;
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
		<td width='20%' align='left'><select name='TCPRIOIMQ' err="please enter a valid priority!" required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCPRIOIMQ'} $selected{'TCPRIOIMQ'}{$qossettings{'TCPRIOIMQ'}}>$qossettings{'TCPRIOIMQ'}</option>";
 	print "<option value='-1'> </option>";
	for ( $c = 1 ; $c <= 7 ; $c++ )
	{
		print "<option value='$c' $selected{'TCPRIOIMQ'}{'$c'}>$c</option>";
	}
	print <<END;
		</select></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos minimum download'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMINIMQ' value="$qossettings{'TCMINIMQ'}" err="please enter a valid download speed!" required="1" /></td>
		<td width='60%' align='left'>( $Lang::tr{'qos download interface'} )</td>
	</tr>
END
if ( $REDDEVICE eq "ppp0" )
{
#print <<END;
#	<tr>
#		<td width='20%' align='right'>MTU:</td>
#		<td width='20%' align='left'><input type='text' name='TCUMAXIMQ' value=$qossettings{'TCUMAXIMQ'} /></td>
#		<td width='60%' align='left'>( $Lang::tr{'qos default for'} imq0: 1492 )</td>
#	</tr>
#END
}
else
{
#print <<END;
#	<tr>
#		<td width='20%' align='right'>MTU:</td>
#		<td width='20%' align='left'><input type='text' name='TCUMAXIMQ' value=$qossettings{'TCUMAXIMQ'} err="please enter a valid MTU !" required="1" /></td>
#		<td width='60%' align='left'>( $Lang::tr{'qos default for'} imq0: 1500 )</td>
#	</tr>
#END
}
print <<END;
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max delay'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXDELAYIMQ' value="$qossettings{'TCMAXDELAYIMQ'}" err="please enter a valid delay !" required="1" /></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max dl rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEIMQ' value="$qossettings{'TCMAXRATEIMQ'}" err="please enter a valid maximum speed !" required="1" /></td>
		<td width='60%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLEIMQ' value='2' />
			<input type='hidden' name='TCPARENTIMQ' value='2' />
			<input type='hidden' name='INTERFACE' value='imq0' />
			<input type='hidden' name='TCPROTOIMQ' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='CLASS' />
		</td>
	</tr>
	</table>
END
}
print "</form>\n";
&Header::closebox();

&Header::openbox( '100%', 'left',"<font color='#00D200'>$Lang::tr{'qos add classes'} $netsettings{'GREEN_DEV'}</font>" );
print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
$rulefile = "/var/ipcop/qos/settings/tc/settings";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
$RCEXIST = "";
foreach $tmpline (sort @tmp)
{
	@tcsettings = split( /\;/, $tmpline );
	if ( $tcsettings[0] eq $netsettings{'GREEN_DEV'} )
	{
		$RCEXIST                   = "YES";
		$qossettings{'ROOTHANDLEGREEN'} = $tcsettings[1];
		$qossettings{'INTERFACE'}  = $tcsettings[0];
		$qossettings{'TCPROTOGREEN'}    = $tcsettings[2];
		$qossettings{'TCDEFAULTGREEN'}  = $tcsettings[3];
		$qossettings{'TCRATEGREEN'}     = $tcsettings[4];
	}
}
if ( $RCEXIST ne "YES" )
{
	print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
	<td width='20%' align='left'> $netsettings{'GREEN_DEV'}</td>
	<td width='20%' align='right'>&nbsp;</td>
	<td width='20%' align='right'>&nbsp;</td>
	<td width='20%' align='right'>&nbsp;</td>			
</tr>	
<tr>
	<td width='20%' align='right'>&nbsp;</td>
	<td width='20%' align='right'>&nbsp;</td>	
	<td width='20%' align='right'>&nbsp;</td>
	<td width='20%' align='right'>&nbsp;</td>
	<td width='20%' align='right'>&nbsp;</td>			
</tr>	
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos default class'}:</td>
	<td width='20%' align='left'><select name='TCDEFAULTGREEN' err="please select a valid default class !"  required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCDEFAULTGREEN'} $selected{'TCDEFAULTGREEN'}{$qossettings{'TCDEFAULTGREEN'}}>$qossettings{'TCDEFAULTGREEN'}</option>";
 	print "<option value='-1'> </option>";
	for ( $c = 300 ; $c <= 399 ; $c++ )
	{
		print "<option value='$c' $selected{'TCDEFAULTGREEN'}{'$c'}>$c</option>";
	}
	print <<END;
	</select></td>
	<td width='60%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
</tr>
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos speed in kbit'}:</td>
	<td width='20%' align='left'><input type='text' name='TCRATEGREEN' value="$qossettings{'TCRATEGREEN'}" err="please enter a valid speed!" required="1" /></td>
	<td width='60%' align='left'>( $Lang::tr{'qos max speed'} )</td>
</tr>
<tr>
	<td width='20%' align='center'>&nbsp;</td>
	<td width='20%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
		<input type='hidden' name='ROOTHANDLEGREEN' value='3' />
		<input type='hidden' name='INTERFACE' value='$netsettings{'GREEN_DEV'}' />
		<input type='hidden' name='TCPROTOGREEN' value='hfsc' />
		<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
	</td>
	<td width='60%' align='center'>&nbsp;</td>
</tr>
</table>
END
}
if ( $RCEXIST eq "YES" )
{
	print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
	<td width='20%' align='left'><select name='TCCLASSGREEN' err="please select a valid class!" required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCCLASSGREEN'} $selected{'TCCLASSGREEN'}{$qossettings{'TCCLASSGREEN'}}>$qossettings{'TCCLASSGREEN'}</option>";
 	print "<option value='-1'> </option>";
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	for ( $c = 300 ; $c <= 399 ; $c++ )
	{
		$EXISTS = "no";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
		}
		if ( $EXISTS ne "yes" )
		{
			print  "<option value='$c' $selected{'TCCLASSGREEN'}{'$c'}>$c</option>";
		}
	}
	print <<END;
	</select></td>
END
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq $netsettings{'GREEN_DEV'} )
		{
			print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
		}
	}
	print <<END;
</tr>
<tr>
	<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
	<td width='20%' align='left'><select name='TCPRIOGREEN' err="please select a valid priority!" required="1" exclude="-1">
END
	print "<option value=$qossettings{'TCPRIOGREEN'} $selected{'TCPRIOGREEN'}{$qossettings{'TCPRIOGREEN'}}>$qossettings{'TCPRIOGREEN'}</option>";
 	print "<option value='-1'> </option>";
	for ( $c = 1 ; $c <= 7 ; $c++ )
	{
		print "<option value='$c' $selected{'TCPRIOGREEN'}{'$c'}>$c</option>";
	}
	print <<END;
	</select></td>
	<td width='60%' align='left'>&nbsp;</td>
</tr>
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
	<td width='20%' align='left'><input type='text' name='TCMINGREEN' value="$qossettings{'TCMINGREEN'}" err="please enter a valid speed!" required="1" /></td>
	<td width='60%' align='left'>( $Lang::tr{'qos speed interface'} )</td>
</tr>
END
#<tr>
#	<td width='20%' align='right'>MTU:</td>
#	<td width='20%' align='left'><input type='text' name='TCUMAXGREEN' value=$qossettings{'TCUMAXGREEN'} err="please enter a valid MTU !" required="1" /></td>
#	<td width='60%' align='left'>( $Lang::tr{'qos default for'} $netsettings{'GREEN_DEV'}: 1500 )</td>
#</tr>
print <<END;
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos max delay'}:</td>
	<td width='20%' align='left'><input type='text' name='TCMAXDELAYGREEN' value="$qossettings{'TCMAXDELAYGREEN'}" err="please enter a valid delay !" required="1" /></td>
	<td width='60%' align='left'>&nbsp;</td>
</tr>
<tr>
	<td width='20%' align='right'>$Lang::tr{'qos max rate'}:</td>
	<td width='20%' align='left'><input type='text' name='TCMAXRATEGREEN' value="$qossettings{'TCMAXRATEGREEN'}" err="please enter a valid maximum speed !" required="1" /></td>
	<td width='60%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
		<input type='hidden' name='ROOTHANDLEGREEN' value='3' />
		<input type='hidden' name='TCPARENTGREEN' value='3' />
		<input type='hidden' name='INTERFACE' value='$netsettings{'GREEN_DEV'}' />
		<input type='hidden' name='TCPROTOGREEN' value='hfsc' />
		<input type='hidden' name='TCSAVE' value='CLASS' />
	</td>
</tr>
</table>
END
}
print "</form>\n";
&Header::closebox();

$qossettings{'TCDEFAULT'}="";
$qossettings{'TCRATE'}="";

if ( $netsettings{'BLUE_DEV'} ne '' )
{
	&Header::openbox( '100%', 'left',"<font color='#0000ff'>$Lang::tr{'qos add classes'} $netsettings{'BLUE_DEV'}</font>" );
	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	$RCEXIST = "";
	foreach $tmpline (sort @tmp)
	{
		@tcsettings = split( /\;/, $tmpline );
		if ( $tcsettings[0] eq $netsettings{'BLUE_DEV'} )
		{
			$RCEXIST                   = "YES";
			$qossettings{'ROOTHANDLEBLUE'} = $tcsettings[1];
			$qossettings{'INTERFACE'}  = $tcsettings[0];
			$qossettings{'TCPROTOBLUE'}    = $tcsettings[2];
			$qossettings{'TCDEFAULTBLUE'}  = $tcsettings[3];
			$qossettings{'TCRATEBLUE'}     = $tcsettings[4];
		}
	}
	if ( $RCEXIST ne "YES" )
	{
		print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
		<td width='20%' align='left'> $netsettings{'BLUE_DEV'}</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>	
	<tr>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>	
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>	
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos default class'}:</td>
		<td width='20%' align='left'><select name='TCDEFAULTBLUE' err="please select a valid default class!" required="1" exclude="-1">
END
		print "<option value=$qossettings{'TCDEFAULTBLUE'} $selected{'TCDEFAULTBLUE'}{$qossettings{'TCDEFAULTBLUE'}}>$qossettings{'TCDEFAULTBLUE'}</option>";
 		print "<option value='-1'> </option>";
		for ( $c = 500 ; $c <= 599 ; $c++ )
		{
			print "<option value='$c' $selected{'TCDEFAULTBLUE'}{'$c'}>$c</option>";
		}
		print <<END;
		</select></td>
		<td width='60%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos speed in kbit'}:</td>
		<td width='20%' align='left'><input type='text' name='TCRATEBLUE' value="$qossettings{'TCRATEBLUE'}"  err="please select a valid speed!" required="1"/></td>
		<td width='60%' align='left'>( $Lang::tr{'qos max dl speed'} )</td>
	</tr>
	<tr>
		<td width='20%' align='center'>&nbsp;</td>
		<td width='20%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLEBLUE' value='5' />
			<input type='hidden' name='INTERFACE' value='$netsettings{'BLUE_DEV'}' />
			<input type='hidden' name='TCPROTOBLUE' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
		</td>
		<td width='60%' align='center'>&nbsp;</td>
	</tr>
	</table>
END
	}
	if ( $RCEXIST eq "YES" )
	{
		print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
		<td width='20%' align='left'><select name='TCCLASSBLUE' err="please select a valid class!" required="1" exclude="-1">
END
		print "<option value=$qossettings{'TCCLASSBLUE'} $selected{'TCCLASSBLUE'}{$qossettings{'TCCLASSBLUE'}}>$qossettings{'TCCLASSBLUE'}</option>";
 		print "<option value='-1'> </option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 500 ; $c <= 599 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS ne "yes" )
			{
				print
				  "<option value='$c' $selected{'TCCLASSBLUE'}{'$c'}>$c</option>";
			}
		}
		print <<END;
  	</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq $netsettings{'BLUE_DEV'} )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
		<td width='20%' align='left'><select name='TCPRIOBLUE' err="please select a valid priority!" required="1" exclude="-1">
END
		print "<option value=$qossettings{'TCPRIOBLUE'} $selected{'TCPRIOBLUE'}{$qossettings{'TCPRIOBLUE'}}>$qossettings{'TCPRIOBLUE'}</option>";
	 	print "<option value='-1'> </option>";
		for ( $c = 1 ; $c <= 7 ; $c++ )
		{
			print "<option value='$c' $selected{'TCPRIOBLUE'}{'$c'}>$c</option>";
		}
		print <<END;
		</select></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMINBLUE' value="$qossettings{'TCMINBLUE'}" err="please select a valid speed!" required="1" /></td>
		<td width='60%' align='left'>( $Lang::tr{'qos speed interface'} )</td>
	</tr>
END
#	<tr>
#		<td width='20%' align='right'>MTU:</td>
#		<td width='20%' align='left'><input type='text' name='TCUMAXBLUE' value=$qossettings{'TCUMAXBLUE'}  err="please select a valid MTU!" required="1"/></td>
#		<td width='60%' align='left'>( $Lang::tr{'qos default for'} $netsettings{'BLUE_DEV'}: 1500 )</td>
#	</tr>
print <<END;
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max delay'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXDELAYBLUE' value="$qossettings{'TCMAXDELAYBLUE'}"  err="please select a valid delay!" required="1"/></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max speed'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEBLUE' value="$qossettings{'TCMAXRATEBLUE'}"  err="please select a valid delay!" required="1"/></td>
		<td width='60%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLEBLUE' value='5' />
			<input type='hidden' name='TCPARENTBLUE' value='5' />
			<input type='hidden' name='INTERFACE' value='$netsettings{'BLUE_DEV'}' />
			<input type='hidden' name='TCPROTOBLUE' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='CLASS' />
		</td>
	</tr>
	</table>
END
	}
	print "</form>\n";
	&Header::closebox();
}

$qossettings{'TCDEFAULT'}="";
$qossettings{'TCRATE'}="";

if ( $netsettings{'ORANGE_DEV'} ne '' )
{
	&Header::openbox( '100%', 'left', "<font color='E17100'>$Lang::tr{'qos add classes'} $netsettings{'ORANGE_DEV'}</font>" );
	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	$RCEXIST = "";
	foreach $tmpline (sort @tmp)
	{
		@tcsettings = split( /\;/, $tmpline );
		if ( $tcsettings[0] eq $netsettings{'ORANGE_DEV'} )
		{
			$RCEXIST                   = "YES";
			$qossettings{'ROOTHANDLEORANGE'} = $tcsettings[1];
			$qossettings{'INTERFACE'}  = $tcsettings[0];
			$qossettings{'TCPROTOORANGE'}    = $tcsettings[2];
			$qossettings{'TCDEFAULTORANGE'}  = $tcsettings[3];
			$qossettings{'TCRATEORANGE'}     = $tcsettings[4];
		}
	}
	if ( $RCEXIST ne "YES" )
	{
		print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
		<td width='20%' align='left'> $netsettings{'ORANGE_DEV'}</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>	
	<tr>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>	
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>
		<td width='20%' align='right'>&nbsp;</td>			
	</tr>	
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos default class'}:</td>
		<td width='20%' align='left'><select name='TCDEFAULTORANGE' err="please select a valid default class!" required="1" exclude="-1">
END
		print "<option value=$qossettings{'TCDEFAULTORANGE'} $selected{'TCDEFAULTORANGE'}{$qossettings{'TCDEFAULTORANGE'}}>$qossettings{'TCDEFAULTORANGE'}</option>";
	 	print "<option value='-1'> </option>";
		for ( $c = 400 ; $c <= 499 ; $c++ )
		{
			print "<option value='$c' $selected{'TCDEFAULTORANGE'}{'$c'}>$c</option>";
		}
		print <<END;
		</select></td>
		<td width='60%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos speed in kbit'}:</td>
		<td width='20%' align='left'><input type='text' name='TCRATEORANGE' value="$qossettings{'TCRATEORANGE'}" err="please select a valid speed!" required="1" /></td>
		<td width='60%' align='left'>( $Lang::tr{'qos max dl speed'} )</td>
	</tr>
	<tr>
		<td width='20%' align='center'>&nbsp;</td>
		<td width='20%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLEORANGE' value='4' />
			<input type='hidden' name='INTERFACE' value='$netsettings{'ORANGE_DEV'}' />
			<input type='hidden' name='TCPROTOORANGE' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
		</td>
		<td width='60%' align='center'>&nbsp;</td>
	</tr>
	</table>
END
	}
	if ( $RCEXIST eq "YES" )
	{
		print <<END;
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
		<td width='20%' align='left'><select name='TCCLASSORANGE' err="please select a valid class!" required="1" exclude="-1">
END
		print "<option value=$qossettings{'TCCLASSORANGE'} $selected{'TCCLASSORANGE'}{$qossettings{'TCCLASSORANGE'}}>$qossettings{'TCCLASSORANGE'}</option>";
 		print "<option value='-1'> </option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 400 ; $c <= 499 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS ne "yes" )
			{
				print
				  "<option value='$c' $selected{'TCCLASSORANGE'}{'$c'}>$c</option>";
			}
		}
		print <<END;
  	</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq $netsettings{'ORANGE_DEV'} )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
		<td width='20%' align='left'><select name='TCPRIOORANGE' err="please select a valid priority!" required="1" exclude="-1">
END
		print "<option value=$qossettings{'TCPRIOORANGE'} $selected{'TCPRIOORANGE'}{$qossettings{'TCPRIOORANGE'}}>$qossettings{'TCPRIOORANGE'}</option>";
	 	print "<option value='-1'> </option>";
		for ( $c = 1 ; $c <= 7 ; $c++ )
		{
			print "<option value='$c' $selected{'TCPRIOORANGE'}{'$c'}>$c</option>";
		}
		print <<END;
		</select></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMINORANGE' value="$qossettings{'TCMINORANGE'}" err="please select a valid speed!" required="1" /></td>
		<td width='60%' align='left'>( $Lang::tr{'qos speed interface'} )</td>
	</tr>
END
#	<tr>
#		<td width='20%' align='right'>MTU:</td>
#		<td width='20%' align='left'><input type='text' name='TCUMAXORANGE' value="$qossettings{'TCUMAXORANGE'}" err="please select a valid MTU!" required="1" /></td>
#		<td width='60%' align='left'>( $Lang::tr{'qos default for'} $netsettings{'ORANGE_DEV'}: 1500 )</td>
#	</tr>
print <<END;
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max delay'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXDELAYORANGE' value="$qossettings{'TCMAXDELAYORANGE'}" err="please select a valid delay!" required="1" /></td>
		<td width='60%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEORANGE' value="$qossettings{'TCMAXRATEORANGE'}" err="please select a valid speed!" required="1" /></td>
		<td width='60%' align='left'>
			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ROOTHANDLEORANGE' value='4' />
			<input type='hidden' name='TCPARENTORANGE' value='4' />
			<input type='hidden' name='INTERFACE' value='$netsettings{'ORANGE_DEV'}' />
			<input type='hidden' name='TCPROTOORANGE' value='hfsc' />
			<input type='hidden' name='TCSAVE' value='CLASS' />
		</td>
	</tr>
	</table>
END
	}
	print "</form>\n";
	&Header::closebox();
}

if ( $ready ne "" )
{
#	print "<a name='select ack'>";
	$rulefile = "/var/ipcop/qos/settings/tc/ack";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	my $ACTACK=$tmp[0];
	&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos selectack'}$REDDEVICE</font>" );
	print <<END;
	<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
	<table CELLSPACING='0' cellpadding='0' width='100%'>
	<tr>
		<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
		<td width='20%' align='left'><select name='TCPRIOACK' err="please enter a valid priority!" required="1" exclude="-1">
END
	print "<option value=$ACTACK $selected{'TCPRIOACK'}{$qossettings{'TCPRIOACK'}}>$ACTACK</option>";
	print "<option value='-1'> </option>";
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[1] ge 100 || $tmpline[1] le 199 )
		{
			print "<option value='$tmpline[1]' $selected{'TCPRIOACK'}{'$tmpline[1]'}>$tmpline[1]</option>";
		}
	}
	print <<END;
		</select></td>
		<td width='25%' align='center'>($Lang::tr{'qos ackpriority'}: $ACTACK)</td>
		<td width='35%' align='center'><input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
		<input type='hidden' name='ACK' value='YES' />
	</tr>
</tr>
</table>
</form>
END
&Header::closebox();

	
	print "<a name='addrules'>";
	&Header::openbox( '100%', 'left', "Add rule" );
	print <<END;
<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='33%' align='right'>$Lang::tr{'qos rulename'}:</td>
	<td width='33%' align='left'><input type='text' name='RULENAME' value="$qossettings{'RULENAME'}" err="please select a valid Rulename!" required="1"/></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'interface'}:</td>
	<td width='16,66%' align='left'><select name='DEV' err="please select a valid interface!" required="1" exclude="-1" >
	<option value=$qossettings{'DEV'} $selected{'DEV'}{$qossettings{'DEV'}}>$qossettings{'DEV'}</option>
	<option value='-1'> </option>
END
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		print "<option value='$tmpline[0]' $selected{'DEV'}{'$tmpline[0]'}>$tmpline[0]</option>";
	}
	print <<END;
	</select></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'protocol'}:</td>
	<td width='33%' align='left'><select name='PROT' err="please select a valid protocol!" required="1" exclude="-1">
END
	print "<option value=$qossettings{'PROT'} $selected{'PROT'}{$qossettings{'PROT'}}>$qossettings{'PROT'}</option>";
 	print "<option value='-1'> </option>";
	$rulefile = "/etc/protocols";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\ /, $ruleentry );
		next if $tmpline[0] =~ "#";
		print "<option value='$tmpline[0]' $selected{'PROT'}{'$tmpline[0]'}>$tmpline[0]</option>";
	}
	print <<END;
			</select></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'qos mark'}:</td>
	<td width='33%' align='left'><select name='MARK' err="please select a valid mark!" required="1" exclude="-1" >
	<option value=$qossettings{'MARK'} $selected{'MARK'}{$qossettings{'MARK'}}>$qossettings{'MARK'}</option>
	<option value='-1'> </option>
END
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		print "<option value='$tmpline[1]' $selected{'MARK'}{'$tmpline[1]'}>$tmpline[1]</option>";
	}
	print <<END;
			</select></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'source port'}:</td>
	<td width='33%' align='left'><input type='text' name='SPORT' value="$qossettings{'SPORT'}" /></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'dst port'}:</td>
	<td width='33%' align='left'><input type='text' name='DPORT' value="$qossettings{'DPORT'}" /></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'source ip'}:</td>
	<td width='33%' align='left'><input type='text' name='SOURCE' value="$qossettings{'SOURCE'}" /></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'destination ip'}:</td>
	<td width='33%' align='left'><input type='text' name='DEST' value="$qossettings{'DEST'}" /></td>
	<td width='33%' align='left'><input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
		<input type='hidden' name='L7' value='no' />
	</td>
</tr>
</table>
END
	print "</form>\n";
	&Header::closebox();

	print "<a name='addl7rules'>";
	&Header::openbox( '100%', 'left', "Add l7 rule" );
	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
	print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='33%' align='right'>$Lang::tr{'qos rulename'}:</td>
	<td width='33%' align='left'><input type='text' name='L7RULENAME' value="$qossettings{'L7RULENAME'}" err="please enter a valid Rulename!" required="1" /></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'interface'}:</td>
	<td width='16,66%' align='left'><select name='L7DEV' err="please select a valid device!" required="1" exclude="-1" >
	<option value=$qossettings{'L7DEV'} $selected{'L7DEV'}{$qossettings{'L7DEV'}}>$qossettings{'L7DEV'}</option>
	<option value='-1'> </option>
END
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		print "<option value='$tmpline[0]' $selected{'L7DEV'}{'$tmpline[0]'}>$tmpline[0]</option>";
	}
	print <<END;
	</select></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'protocol'}:</td>
	<td width='33%' align='left'><select name='L7PROT' err="please select a valid protocol!" required="1" exclude="-1" >
	<option value=$qossettings{'L7PROT'} $selected{'L7PROT'}{$qossettings{'L7PROT'}}>$qossettings{'L7PROT'}</option>
	<option value='-1'> </option>
END
	$dir = "/etc/l7-protocols/protocols";
	opendir( DIR, "$dir" );
	foreach $direntry ( sort readdir(DIR) )
	{
		next if $direntry eq ".";
		next if $direntry eq "..";
		next if -d "$dir/$direntry";
		@proto = split( /\./, $direntry );
		print "<option value='$proto[0]' $selected{'L7PROT'}{'$proto[0]'}>$proto[0]</option>";
	}
	closedir DIR;
	print <<END;
			</select></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'qos mark'}:</td>
	<td width='33%' align='left'><select name='L7MARK' err="please select a valid mark!" required="1" exclude="-1" >
	<option value=$qossettings{'L7MARK'} $selected{'L7MARK'}{$qossettings{'L7MARK'}}>$qossettings{'L7MARK'}</option>
	<option value='-1'> </option>
END
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		print "<option value='$tmpline[1]' $selected{'L7MARK'}{'$tmpline[1]'}>$tmpline[1]</option>";
	}
	print <<END;
			</select></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'source ip'}:</td>
	<td width='33%' align='left'><input type='text' name='L7SOURCE' value="$qossettings{'L7SOURCE'}" /></td>
	<td width='33%' align='center'>&nbsp;</td>
</tr>
<tr>
	<td width='33%' align='right'>$Lang::tr{'destination ip'}:</td>
	<td width='33%' align='left'><input type='text' name='L7DEST' value="$qossettings{'L7DEST'}" /></td>
	<td width='33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
		<input type='hidden' name='L7' value='yes' />
	</td>
</tr>
</table>
END
	print "</form>\n";
	&Header::closebox();
	print "<a href='#top'>top</a>";
}
print "<a name='deleterclasses'>";
&Header::openbox( '100%', 'left', "$Lang::tr{'qos eddel rootclass'}" );
print "<form method='post' action='$ENV{'SCRIPT_NAME'}#deleterclasses'>\n";
print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='13,33%' align='right'>$Lang::tr{'qos del rootclass'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
$rulefile = "/var/ipcop/qos/settings/tc/settings";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;

foreach $ruleentry (sort @tmp)
{
	@tmpline = split( /\;/, $ruleentry );
	print
"<option value='$tmpline[0]' $selected{'DEL'}{'$tmpline[0]'}>$tmpline[0]</option>";
}
print <<END;
			</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'delete'}' class="deleteButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
	</td>
END
print "</form>\n";
print "<td width='13,33%' align='right'>&nbsp;</td>";
print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
print <<END;
	<td width='13,33%' align='right'>$Lang::tr{'qos edit rootclass'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
$rulefile = "/var/ipcop/qos/settings/tc/settings";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;

foreach $ruleentry (sort @tmp)
{
	@tmpline = split( /\;/, $ruleentry );
	print
"<option value='$tmpline[0]' $selected{'DEL'}{'$tmpline[0]'}>$tmpline[0]</option>";
}
print <<END;
			</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'edit'}' class="editButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
	</td>
</tr>
</table>
END
print "</form>\n";

#&Header::closebox();
#print "<a href='#top'>top</a>";

print "<a name='rootclasses'>";

#&Header::openbox('100%', 'left', 'current rootclasses');
print <<END;
<table CELLSPACING='0' cellpadding='0' width="100%" align="center">
<tr bgcolor="#ff6464">
	<td width="20%" align="center"><b>Interface</b></td>
	<td width="20%" align="center"><b>Handle</b></td>
	<td width="20%" align="center"><b>$Lang::tr{'protocol'}</b></td>
	<td width="20%" align="center"><b>$Lang::tr{'qos default class'}</b></td>
	<td width="20%" align="center"><b>Maximum Rate</b></td>
<tr>
END
@otherrules = ();
if ( open( OTHER, "/var/ipcop/qos/settings/tc/settings" ) )
{
	@otherrules = <OTHER>;
	close(OTHER);
}
$i="";
foreach $line (@otherrules)
{
	@temp = split( /\;/, $line );
	$i++;
	if ($i % 2) {
		$bgcolor="#6464ff"; }
	else {
		$bgcolor="#3434ff"; }
	print <<END;
	<tr>
		<td width="20%" align="center" bgcolor="$bgcolor"><b>$temp[0]</b></td>
		<td width="20%" align="center" bgcolor="$bgcolor"><b>$temp[1]</b></td>
		<td width="20%" align="center" bgcolor="$bgcolor"><b>$temp[2]</b></td>
		<td width="20%" align="center" bgcolor="$bgcolor"><b>$temp[3]</b></td>
		<td width="20%" align="center" bgcolor="$bgcolor"><b>$temp[4]</b></td>
	<tr>
END
}
print "</table>\n";
&Header::closebox();
print "<a href='#top'>top</a>";

$rulefile = "/var/ipcop/qos/settings/tc/classes";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
@tmpline = split( /\;/, $tmp[0] );
if ( $tmpline[1] ne "" )
{
	print "<a name='deleteclasses'>";
	&Header::openbox( '100%', 'left', "$Lang::tr{'qos eddel class'}" );
	print "<form method='post' action='$ENV{'SCRIPT_NAME'}#deleteclasses'>\n";
	print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='13,33%' align='right'>$Lang::tr{'qos del class'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;

	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		print "<option value='$tmpline[1]' $selected{'DEL'}{'$tmpline[1]'}>$tmpline[1]</option>";
	}
	print <<END;
			</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'delete'}' class="deleteButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='TCSAVE' value='CLASS' />
	</td>
END
print "</form>\n";
print "<td width='13,33%' align='right'>&nbsp;</td>";
	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
	print <<END;
	<td width='13,33%' align='right'>$Lang::tr{'qos edit class'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;

	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		print "<option value='$tmpline[1]' $selected{'DEL'}{'$tmpline[1]'}>$tmpline[1]</option>";
	}
	print <<END;
			</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'edit'}' class="editButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='TCSAVE' value='CLASS' />
	</td>
</tr>
</table>
END
print "</form>\n";


#&Header::closebox();
#print "<a href='#top'>top</a>";
print "<a name='classes'>";
#&Header::openbox('100%', 'left', 'current classes');
print <<END;
<table CELLSPACING='0' cellpadding='0' width="100%" align="center">
<tr bgcolor="#ff6464">
	<td width="14.28%" align="center"><b>Handle</b></td>
	<td width="14.28%" align="center"><b>$Lang::tr{'qos class'}</b></td>
	<td width="14.28%" align="center"><b>Parent</b></td>
	<td width="14.28%" align="center"><b>$Lang::tr{'priority'}</b></td>
	<td width="14.28%" align="center"><b>Minimum Bandwidth</b></td>
END
#	<td width="14.28%" align="center"><b>MTU</b></td>
print <<END;
	<td width="12.5%" align="center"><b>$Lang::tr{'qos max delay'}</b></td>
	<td width="14.28%" align="center"><b>Maximum Bandwidth</b></td>
<tr>
END
@otherrules = ();
if ( open( OTHER, "/var/ipcop/qos/settings/tc/classes" ) )
{
	@otherrules = <OTHER>;
	close(OTHER);
}
for ( $c = 1 ; $c <= 5 ; $c++ )
{
	$i="";
	print "<tr bgcolor='#ff6464'><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><tr>";
	foreach $line (sort @otherrules)
	{
		@temp = split( /\;/, $line );
		if ( $temp[2] eq $c )
		{
			$i++;
			if ($i % 2) {
				$bgcolor="#6464ff"; }
			else {
				$bgcolor="#3434ff"; }
			print <<END;
			<tr>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[0]</b></td>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[1]</b></td>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[2]</b></td>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[3]</b></td>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[4]</b></td>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[5]</b></td>
				<td width="14.28%" align="center" bgcolor="$bgcolor"><b>$temp[6]</b></td>
			<tr>
END
		}
	}
}
print "</table>\n";
&Header::closebox();
print "<a href='#top'>top</a>";

print "<a name='deleterules'>";
&Header::openbox( '100%', 'left', "$Lang::tr{'qos eddel rule'}" );
print "<form method='post' action='$ENV{'SCRIPT_NAME#deleterules'}'>\n";
print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='13,33%' align='right'>$Lang::tr{'qos del rule'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
$rulefile = "/var/ipcop/qos/settings/other/rules";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;

foreach $ruleentry (sort @tmp)
{
	@tmpline = split( /\;/, $ruleentry );
	print "<option value='$tmpline[0]' $selected{'DEL'}{'$tmpline[0]'}>$tmpline[0]</option>";
}
print <<END;
	</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'delete'}' class="deleteButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='L7' value='no' />
	</td>
END
print "</form>\n";
print "<td width='13,33%' align='right'>&nbsp;</td>";
print "<form method='post' action='/cgi-bin/qos.cgi#addrules'>\n";
print <<END;
	<td width='13,33%' align='right'>$Lang::tr{'qos edit rule'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
$rulefile = "/var/ipcop/qos/settings/other/rules";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;

foreach $ruleentry (sort @tmp)
{
	@tmpline = split( /\;/, $ruleentry );
	print "<option value='$tmpline[0]' $selected{'DEL'}{'$tmpline[0]'}>$tmpline[0]</option>";
}
print <<END;
	</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'edit'}' class="editButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='L7' value='no' />
	</td>
</tr>
</table>
END
print "</form>\n";


#&Header::closebox();
#print "<a href='#top'>top</a>";

print "<a name='otherrules'>";

#&Header::openbox('100%', 'left', 'current rules');
print <<END;
<table CELLSPACING='0' cellpadding='0' border="0" width="100%" align="center">
<tr bgcolor="#ff6464" >
	<td  align="center" ><b>$Lang::tr{'qos rulename'}</b></td>
	<td  align="center" ><b>$Lang::tr{'protocol'}</b></td>
	<td  align="center" ><b>$Lang::tr{'qos mark'}</b></td>
	<td  align="center" ><b>$Lang::tr{'src port'}</b></td>
	<td  align="center" ><b>$Lang::tr{'dst port'}</b></td>
	<td  align="center" ><b>$Lang::tr{'source ip'}</b></td>
	<td  align="center" ><b>$Lang::tr{'destination ip'}</b></td>
	<td  align="center" ><b>$Lang::tr{'interface'}</b></td>
<tr>
END
@otherrules = ();
if ( open( OTHER, "/var/ipcop/qos/settings/other/rules" ) )
{
	@otherrules = <OTHER>;
	close(OTHER);
}
$i="";
foreach $line (sort @otherrules)
{
	$i++;
	@temp = split( /\;/, $line );
	if ($i % 2) {
		$bgcolor="#6464ff"; }
	else {
		$bgcolor="#3434ff"; }
	print <<END;
<tr>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[0]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[1]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[2]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[3]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[4]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[5]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[6]</b></td>
	<td  align="center" bgcolor="$bgcolor"><b>$temp[7]</b></td>
<tr>
END
}
print "</table>\n";
&Header::closebox();
print "<a href='#top'>top</a>";

print "<a name='deletel7rules'>";
&Header::openbox( '100%', 'left', "$Lang::tr{'qos eddel l7rule'}" );
print "<form method='post' action='$ENV{'SCRIPT_NAME'}#deletel7rules'>\n";
print <<END;
<table CELLSPACING='0' cellpadding='0' width='100%'>
<tr>
	<td width='13,33%' align='right'>$Lang::tr{'qos del l7rule'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
$rulefile = "/var/ipcop/qos/settings/layer7/rules";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;

foreach $ruleentry (sort @tmp)
{
	@tmpline = split( /\;/, $ruleentry );
	print "<option value='$tmpline[0]' $selected{'DEL'}{'$tmpline[0]'}>$tmpline[0]</option>";
}
print <<END;
	</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'delete'}' class="deleteButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='L7' value='yes' />
	</td>
END
print "</form>\n";
print "<td width='13,33%' align='right'>&nbsp;</td>";
print "<form method='post' action='/cgi-bin/qos.cgi#addl7rules'>\n";
print <<END;
	<td width='13,33%' align='right'>$Lang::tr{'qos edit l7rule'}:</td>
	<td width='13,33%' align='left'><select name='DEL'>
END
$rulefile = "/var/ipcop/qos/settings/layer7/rules";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;

foreach $ruleentry (sort @tmp)
{
	@tmpline = split( /\;/, $ruleentry );
	print "<option value='$tmpline[0]' $selected{'DEL'}{'$tmpline[0]'}>$tmpline[0]</option>";
}
print <<END;
	</select></td>
	<td width='13,33%' align='left'>
		<input type='submit' name='ACTION' value='$Lang::tr{'edit'}' class="editButton" />
		<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
		<input type='hidden' name='L7' value='yes' />
	</td>
</tr>
</table>
END
print "</form>\n";


#&Header::closebox();
#print "<a href='#top'>top</a>";

print "<a name='l7rules'>";

#&Header::openbox('100%', 'left', 'current layer7-rules');
print <<END;
<table CELLSPACING='0' cellpadding='0' width="100%" align="left">
<tr>
	<td align="center" bgcolor="#ff6464"><b>$Lang::tr{'name'}</b></td>
	<td align="center" bgcolor="#ff6464"><b>$Lang::tr{'protocol'}</b></td>
	<td align="center" bgcolor="#ff6464"><b>Mark</b></td>
	<td align="center" bgcolor="#ff6464"><b>Interface</b></td>
	<td align="center" bgcolor="#ff6464"><b>$Lang::tr{'source ip'}</b></td>
	<td align="center" bgcolor="#ff6464"><b>$Lang::tr{'destination ip'}</b></td>
<tr>
END
@l7rules = ();
if ( open( L7, "/var/ipcop/qos/settings/layer7/rules" ) )
{
	@l7rules = <L7>;
	close(L7);
}
$i="";
foreach $line (sort @l7rules)
{
	$i++;
	if ($i % 2) {
		$bgcolor="#6464ff"; }
	else {
		$bgcolor="#3434ff"; }
	@temp = split( /\;/, $line );
	print <<END;
<tr>
	<td align="center" bgcolor="$bgcolor"><b>$temp[0]</b></td>
	<td align="center" bgcolor="$bgcolor"><b>$temp[1]</b></td>
	<td align="center" bgcolor="$bgcolor"><b>$temp[2]</b></td>
	<td align="center" bgcolor="$bgcolor"><b>$temp[3]</b></td>
	<td align="center" bgcolor="$bgcolor"><b>$temp[4]</b></td>
	<td align="center" bgcolor="$bgcolor"><b>$temp[5]</b></td>
<tr>
END
}
print "</table>\n";
&Header::closebox();
print "<a href='#top'>top</a>";
}
&Header::closebigbox();
print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Zahlen Sie mit PayPal - schnell, kostenlos und sicher!">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
print "<a name='bottom'>";
&Header::closepage();

sub checkversionenabled
{
	my $localname     = $_[0];
	my $localversion  = $_[1];
	my $i             = 0;
	my @tmpversion    = ();
	my @serverversion = ();
	my $return        = &downloadversions();
	if ( $return =~ m/^HTTP\/\d+\.\d+ 200/ )
	{
		my @online = split( /---Versions---\n/, $return );
		chomp( $online[1] );
		@tmpversion = split( /\;/, $online[1] );
		while ( $tmpversion[$i] )
		{
			@serverversion = split( /\,/, $tmpversion[$i] );
			if ( $serverversion[0] eq $localname )
			{
				if ( $serverversion[1] gt $localversion )
				{
					return "There is a newer version available",
					  $serverversion[1];
				}
				else
				{
					return "0", "0";
				}
			}
			$i++;
		}
	}
	else
	{
		return "unable to connect to mhaddons.tk, please try again later.";
	}
}

sub downloadversions
{
	use IO::Socket;
	use File::Copy;
	unless ( -e "${General::swroot}/red/active" )
	{
		return "could not download latest versions list, not connected";
	}

	my %proxysettings = ();
	&General::readhash( "${General::swroot}/proxy/settings", \%proxysettings );

	my $peer     = 'mh-lantech.css-hamburg.de';
	my $peerport = 80;

	if ( $_ = $proxysettings{'UPSTREAM_PROXY'} )
	{
		( $peer, $peerport ) = (
/^(?:[a-zA-Z ]+\:\/\/)?(?:[A-Za-z0-9\_\.\-]*?(?:\:[A-Za-z0-9\_\.\-]*?)?\@)?([a-zA-Z0-9\.\_\-]*?)(?:\:([0-9]{1,5}))?(?:\/.*?)?$/
		);
	}

	my $sock = '';
	unless (
		$sock = new IO::Socket::INET(
			PeerAddr => $peer,
			PeerPort => $peerport,
			Proto    => 'tcp',
			Timeout  => 5
		)
	  )
	{
		return 'could not connect to mhaddons.tk';
		return 0;
	}
	my $GET_CMD = '';
	$GET_CMD =
	  "GET http://mh-lantech.css-hamburg.de/ipcop/versions.txt HTTP/1.1\r\n";
	$GET_CMD .= "Host: mh-lantech.css-hamburg.de\r\n";
	$GET_CMD .= "Cache-Control: no-cache\r\n";
	$GET_CMD .= "Connection: close\r\n\r\n";
	print $sock "$GET_CMD";

	my $ret = '';
	while (<$sock>)
	{
		$ret .= $_;
	}
	close($sock);
	return $ret;
}
