#!/usr/bin/perl -w
#
#####################################################################################################
#
#   				(c) Markus Hoffmann, 2005-open end
#
#####################################################################################################
#
# COPYRIGHT NOTICE                                                        
# Copyright 2005 Markus Hoffmann
# All Rights Reserved.                     
# EMail: ipcop@mh-lantech.de
# URL  : http://www.mhaddons.tk
# License: CreativeCommons, some right restricted ( http://creativecommons.org/licenses/by-nd/2.5/ )
#

use RRDs;

use strict;

# enable only the following on debugging purpose
#use warnings;
use CGI::Carp 'fatalsToBrowser';

require '/var/ipcop/general-functions.pl';
require "${General::swroot}/lang.pl";
require "${General::swroot}/header.pl";

my %cgiparams=();
my @cgigraphs=();
my @graphs=();
my $iface='';

my $RRDTEMP="";
my $PNGTEMP="";
my $PNGTEMP1="";
my $PNGTEMP2="";
my $PNGTEMP3="";
my $PNGTEMP4="";
my $ERROR="";

&Header::showhttpheaders();

$ENV{'QUERY_STRING'} =~ s/&//g;
@cgigraphs = split(/graph=/,$ENV{'QUERY_STRING'});
$cgigraphs[1] = '' unless defined $cgigraphs[1];

&Header::openpage($Lang::tr{'qos graphs'}, 1, '');
&Header::openbigbox('100%', 'left');

if ($cgigraphs[1] != "") {
	@graphs = split( /\:/, $cgigraphs[1]);
	my $graph=$graphs[0];
	my $graphname = $graphs[1];
	&Header::openbox('100%', 'center', "$Lang::tr{'graph'} for Class $graphname ");

	print "<div align='center'><pre>";

	if ($graphs[1] eq "dropped")
	{
		$RRDTEMP = "/var/log/rrd/";
		$RRDTEMP .= $graph;
		chomp ($RRDTEMP);
		$RRDTEMP .= ".rrd";

		$PNGTEMP = "/home/httpd/html/qos/";
		$PNGTEMP .= "$graph";
		chomp ($PNGTEMP);
		$PNGTEMP .= ".hour.png";
	
		unlink $PNGTEMP;
	
       	 RRDs::graph ("$PNGTEMP",
              	  "--start", "-3240", "-aPNG", "-i", "-z",
	                "--alt-y-grid", "-w 800", "-h 150", "-r",
       	         "--color", "SHADEA#EAE9EE",
              	  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
       	         "-t $Lang::tr{'qos class'} $graph",
              	  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
	                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
       	         "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
              	  "AREA:pkts#00FFFF:packets",
	                "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
       	         "LINE3:dropped#FF0000:dropped",
              	  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
	                "LINE3:overlimit#0000FF:overlimit",
       	         "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
              	  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP1 = "/home/httpd/html/qos/";
		$PNGTEMP1 .= "$graph";
		$PNGTEMP1 .= ".day.png";
	
		unlink $PNGTEMP1;

	        RRDs::graph ("$PNGTEMP1",
              	  "--start", "-86400", "-aPNG", "-i", "-z",
	                "--alt-y-grid", "-w 800", "-h 150", "-r",
       	         "--color", "SHADEA#EAE9EE",
              	  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
       	         "-t $Lang::tr{'qos class'} $graph",
              	  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
	                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
       	         "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
              	  "AREA:pkts#00FFFF:packets",
	                "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
       	         "LINE3:dropped#FF0000:dropped",
              	  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
	                "LINE3:overlimit#0000FF:overlimit",
       	         "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
              	  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP2 = "/home/httpd/html/qos/";
		$PNGTEMP2 .= "$graph";
		$PNGTEMP2 .= ".week.png";

		unlink $PNGTEMP2;

	        RRDs::graph ("$PNGTEMP2",
       	         "--start", "-604800", "-aPNG", "-i", "-z",
	                "--alt-y-grid", "-w 800", "-h 150", "-r",
       	         "--color", "SHADEA#EAE9EE",
              	  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
       	         "-t $Lang::tr{'qos class'} $graph",
              	  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
	                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
       	         "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
              	  "AREA:pkts#00FFFF:packets",
	                "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
       	         "LINE3:dropped#FF0000:dropped",
              	  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
	                "LINE3:overlimit#0000FF:overlimit",
       	         "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
              	  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP3 = "/home/httpd/html/qos/";
		$PNGTEMP3 .= "$graph";
		$PNGTEMP3 .= ".month.png";

		unlink $PNGTEMP3;

	        RRDs::graph ("$PNGTEMP3",
       	         "--start", "-3024000", "-aPNG", "-i", "-z",
	                "--alt-y-grid", "-w 800", "-h 150", "-r",
       	         "--color", "SHADEA#EAE9EE",
              	  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
       	         "-t $Lang::tr{'qos class'} $graph",
              	  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
	                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
       	         "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
              	  "AREA:pkts#00FFFF:packets",
	                "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
       	         "LINE3:dropped#FF0000:dropped",
              	  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
	                "LINE3:overlimit#0000FF:overlimit",
       	         "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
              	  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP4 = "/home/httpd/html/qos/";
		$PNGTEMP4 .= "$graph";
		$PNGTEMP4 .= ".year.png";

		unlink $PNGTEMP4;

	        RRDs::graph ("$PNGTEMP4",
       	         "--start", "-31536000", "-aPNG", "-i", "-z",
	                "--alt-y-grid", "-w 800", "-h 150", "-r",
       	         "--color", "SHADEA#EAE9EE",
              	  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
       	         "-t $Lang::tr{'qos class'} $graph",
              	  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
	                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
       	         "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
              	  "AREA:pkts#00FFFF:packets",
	                "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
       	         "LINE3:dropped#FF0000:dropped",
              	  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
	                "LINE3:overlimit#0000FF:overlimit",
       	         "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
              	  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;


	       print "<img src='/qos/$graph.hour.png' border='0' /><br />";
       	print "<img src='/qos/$graph.day.png' border='0' /><br />";
	       print "<img src='/qos/$graph.week.png' border='0' /><br />";
       	print "<img src='/qos/$graph.month.png' border='0' /><br />";
	       print "<img src='/qos/$graph.year.png' border='0' /><br />";
		print "</div></pre>";
	}
	if ($graphs[1] eq "borrowed")
	{
		$RRDTEMP = "/var/log/rrd/";
		$RRDTEMP .= $graph;
		chomp ($RRDTEMP);
		$RRDTEMP .= ".rrd";

		$PNGTEMP = "/home/httpd/html/qos/";
		$PNGTEMP .= "$graph";
		chomp ($PNGTEMP);
		$PNGTEMP .= ".hour.png";
	
		unlink $PNGTEMP;
	
       	 RRDs::graph ("$PNGTEMP",
              	  "--start", "-3240", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:lended=$RRDTEMP:lended:AVERAGE",
             		  "DEF:borrowed=$RRDTEMP:borrowed:AVERAGE",
	                "DEF:giants=$RRDTEMP:giants:AVERAGE",
             		  "AREA:lended#99ff99:lended",
			  "GPRINT:lended:LAST:lended\\:%8.3lf %s packets\\j",
             		  "LINE3:borrowed#f70566:borrowed",
	                "GPRINT:borrowed:LAST:borrowed\\:%8.3lf %s packets\\j",
             		  "LINE3:giants#05ad05:giants",
	                "GPRINT:giants:LAST:giants\\:%8.3lf %s packets\\j",
             		  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP1 = "/home/httpd/html/qos/";
		$PNGTEMP1 .= "$graph";
		$PNGTEMP1 .= ".day.png";
	
		unlink $PNGTEMP1;

	        RRDs::graph ("$PNGTEMP1",
              	  "--start", "-86400", "-aPNG", "-i", "-z",
              	  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
              	  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:lended=$RRDTEMP:lended:AVERAGE",
              	  "DEF:borrowed=$RRDTEMP:borrowed:AVERAGE",
		         "DEF:giants=$RRDTEMP:giants:AVERAGE",
              	  "AREA:lended#99ff99:lended",
			  "GPRINT:lended:LAST:lended\\:%8.3lf %s packets\\j",
             		  "LINE3:borrowed#f70566:borrowed",
	                "GPRINT:borrowed:LAST:borrowed\\:%8.3lf %s packets\\j",
             		  "LINE3:giants#05ad05:giants",
	                "GPRINT:giants:LAST:giants\\:%8.3lf %s packets\\j",
             		  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP2 = "/home/httpd/html/qos/";
		$PNGTEMP2 .= "$graph";
		$PNGTEMP2 .= ".week.png";

		unlink $PNGTEMP2;

	        RRDs::graph ("$PNGTEMP2",
       	         "--start", "-604800", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:lended=$RRDTEMP:lended:AVERAGE",
             		  "DEF:borrowed=$RRDTEMP:borrowed:AVERAGE",
	                "DEF:giants=$RRDTEMP:giants:AVERAGE",
             		  "AREA:lended#99ff99:lended",
			  "GPRINT:lended:LAST:lended\\:%8.3lf %s packets\\j",
             		  "LINE3:borrowed#f70566:borrowed",
	                "GPRINT:borrowed:LAST:borrowed\\:%8.3lf %s packets\\j",
             		  "LINE3:giants#05ad05:giants",
	                "GPRINT:giants:LAST:giants\\:%8.3lf %s packets\\j",
             		  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP3 = "/home/httpd/html/qos/";
		$PNGTEMP3 .= "$graph";
		$PNGTEMP3 .= ".month.png";

		unlink $PNGTEMP3;

	        RRDs::graph ("$PNGTEMP3",
       	         "--start", "-3024000", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:lended=$RRDTEMP:lended:AVERAGE",
             		  "DEF:borrowed=$RRDTEMP:borrowed:AVERAGE",
	                "DEF:giants=$RRDTEMP:giants:AVERAGE",
             		  "AREA:lended#99ff99:lended",
			  "GPRINT:lended:LAST:lended\\:%8.3lf %s packets\\j",
             		  "LINE3:borrowed#f70566:borrowed",
	                "GPRINT:borrowed:LAST:borrowed\\:%8.3lf %s packets\\j",
             		  "LINE3:giants#05ad05:giants",
	                "GPRINT:giants:LAST:giants\\:%8.3lf %s packets\\j",
             		  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP4 = "/home/httpd/html/qos/";
		$PNGTEMP4 .= "$graph";
		$PNGTEMP4 .= ".year.png";

		unlink $PNGTEMP4;

	        RRDs::graph ("$PNGTEMP4",
       	         "--start", "-31536000", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:lended=$RRDTEMP:lended:AVERAGE",
             		  "DEF:borrowed=$RRDTEMP:borrowed:AVERAGE",
	                "DEF:giants=$RRDTEMP:giants:AVERAGE",
             		  "AREA:lended#99ff99:lended",
			  "GPRINT:lended:LAST:lended\\:%8.3lf %s packets\\j",
             		  "LINE3:borrowed#f70566:borrowed",
	                "GPRINT:borrowed:LAST:borrowed\\:%8.3lf %s packets\\j",
             		  "LINE3:giants#05ad05:giants",
	                "GPRINT:giants:LAST:giants\\:%8.3lf %s packets\\j",
             		  );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;


	       print "<img src='/qos/$graph.hour.png' border='0' /><br />";
       	print "<img src='/qos/$graph.day.png' border='0' /><br />";
	       print "<img src='/qos/$graph.week.png' border='0' /><br />";
       	print "<img src='/qos/$graph.month.png' border='0' /><br />";
	       print "<img src='/qos/$graph.year.png' border='0' /><br />";
		print "</div></pre>";
	}
	if ($graphs[1] eq "token")
	{
		$RRDTEMP = "/var/log/rrd/";
		$RRDTEMP .= $graph;
		chomp ($RRDTEMP);
		$RRDTEMP .= ".rrd";

		$PNGTEMP = "/home/httpd/html/qos/";
		$PNGTEMP .= "$graph";
		chomp ($PNGTEMP);
		$PNGTEMP .= ".hour.png";
	
		unlink $PNGTEMP;
	
       	 RRDs::graph ("$PNGTEMP",
              	  "--start", "-3240", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:tokens=$RRDTEMP:tokens:AVERAGE",
             		  "DEF:ctokens=$RRDTEMP:ctokens:AVERAGE",
	                "AREA:tokens#cc99cc:tokens",
			  "GPRINT:tokens:LAST:tokens\\:%8.3lf %s\\j",
	                "LINE3:ctokens#9900ff:ctokens",
             		  "GPRINT:ctokens:LAST:ctokens\\:%8.3lf %s\\j",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP1 = "/home/httpd/html/qos/";
		$PNGTEMP1 .= "$graph";
		$PNGTEMP1 .= ".day.png";
	
		unlink $PNGTEMP1;

	        RRDs::graph ("$PNGTEMP1",
              	  "--start", "-86400", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:tokens=$RRDTEMP:tokens:AVERAGE",
             		  "DEF:ctokens=$RRDTEMP:ctokens:AVERAGE",
	                "AREA:tokens#cc99cc:tokens",
			  "GPRINT:tokens:LAST:tokens\\:%8.3lf %s\\j",
	                "LINE3:ctokens#9900ff:ctokens",
             		  "GPRINT:ctokens:LAST:ctokens\\:%8.3lf %s\\j",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP2 = "/home/httpd/html/qos/";
		$PNGTEMP2 .= "$graph";
		$PNGTEMP2 .= ".week.png";

		unlink $PNGTEMP2;

	        RRDs::graph ("$PNGTEMP2",
       	         "--start", "-604800", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:tokens=$RRDTEMP:tokens:AVERAGE",
             		  "DEF:ctokens=$RRDTEMP:ctokens:AVERAGE",
	                "AREA:tokens#cc99cc:tokens",
			  "GPRINT:tokens:LAST:tokens\\:%8.3lf %s\\j",
	                "LINE3:ctokens#9900ff:ctokens",
            		  "GPRINT:ctokens:LAST:ctokens\\:%8.3lf %s\\j",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP3 = "/home/httpd/html/qos/";
		$PNGTEMP3 .= "$graph";
		$PNGTEMP3 .= ".month.png";

		unlink $PNGTEMP3;

	        RRDs::graph ("$PNGTEMP3",
       	         "--start", "-3024000", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:tokens=$RRDTEMP:tokens:AVERAGE",
             		  "DEF:ctokens=$RRDTEMP:ctokens:AVERAGE",
	                "AREA:tokens#cc99cc:tokens",
			  "GPRINT:tokens:LAST:tokens\\:%8.3lf %s\\j",
	                "LINE3:ctokens#9900ff:ctokens",
             		  "GPRINT:ctokens:LAST:ctokens\\:%8.3lf %s\\j",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP4 = "/home/httpd/html/qos/";
		$PNGTEMP4 .= "$graph";
		$PNGTEMP4 .= ".year.png";

		unlink $PNGTEMP4;

	        RRDs::graph ("$PNGTEMP4",
       	         "--start", "-31536000", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:tokens=$RRDTEMP:tokens:AVERAGE",
             		  "DEF:ctokens=$RRDTEMP:ctokens:AVERAGE",
	                "AREA:tokens#cc99cc:tokens",
			  "GPRINT:tokens:LAST:tokens\\:%8.3lf %s\\j",
	                "LINE3:ctokens#9900ff:ctokens",
             		  "GPRINT:ctokens:LAST:ctokens\\:%8.3lf %s\\j",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;


	       print "<img src='/qos/$graph.hour.png' border='0' /><br />";
       	print "<img src='/qos/$graph.day.png' border='0' /><br />";
	       print "<img src='/qos/$graph.week.png' border='0' /><br />";
       	print "<img src='/qos/$graph.month.png' border='0' /><br />";
	       print "<img src='/qos/$graph.year.png' border='0' /><br />";
		print "</div></pre>";
	}
	if ($graphs[1] eq "kbit")
	{
		$RRDTEMP = "/var/log/rrd/";
		$RRDTEMP .= $graph;
		chomp ($RRDTEMP);
		$RRDTEMP .= ".rrd";

		$PNGTEMP = "/home/httpd/html/qos/";
		$PNGTEMP .= "$graph";
		chomp ($PNGTEMP);
		$PNGTEMP .= ".hour.png";
	
		unlink $PNGTEMP;
	
       	 RRDs::graph ("$PNGTEMP",
              	  "--start", "-3240", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:rate=$RRDTEMP:rate:AVERAGE",
			  "CDEF:krate=rate,1024,/",
			  "CDEF:brate=rate,1024,/,8,/",
	                "AREA:krate#FFBE7D:kbit",
			  "GPRINT:krate:LAST:rate\\: %8.3lf kbit\\j",
			  "GPRINT:brate:LAST:rate\\:%8.2lf kbyte\\r",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP1 = "/home/httpd/html/qos/";
		$PNGTEMP1 .= "$graph";
		$PNGTEMP1 .= ".day.png";
	
		unlink $PNGTEMP1;

	        RRDs::graph ("$PNGTEMP1",
              	  "--start", "-86400", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:rate=$RRDTEMP:rate:AVERAGE",
			  "CDEF:krate=rate,1024,/",
			  "CDEF:brate=rate,1024,/,8,/",
	                "AREA:krate#FFBE7D:kbit",
			  "GPRINT:krate:LAST:rate\\: %8.3lf kbit\\j",
			  "GPRINT:brate:LAST:rate\\:%8.2lf kbyte\\r",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP2 = "/home/httpd/html/qos/";
		$PNGTEMP2 .= "$graph";
		$PNGTEMP2 .= ".week.png";

		unlink $PNGTEMP2;

	        RRDs::graph ("$PNGTEMP2",
       	         "--start", "-604800", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:rate=$RRDTEMP:rate:AVERAGE",
			  "CDEF:krate=rate,1024,/",
			  "CDEF:brate=rate,1024,/,8,/",
	                "AREA:krate#FFBE7D:kbit",
			  "GPRINT:krate:LAST:rate\\: %8.3lf kbit\\j",
			  "GPRINT:brate:LAST:rate\\:%8.2lf kbyte\\r",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP3 = "/home/httpd/html/qos/";
		$PNGTEMP3 .= "$graph";
		$PNGTEMP3 .= ".month.png";

		unlink $PNGTEMP3;

	        RRDs::graph ("$PNGTEMP3",
       	         "--start", "-3024000", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:rate=$RRDTEMP:rate:AVERAGE",
			  "CDEF:krate=rate,1024,/",
			  "CDEF:brate=rate,1024,/,8,/",
	                "AREA:krate#FFBE7D:kbit",
			  "GPRINT:krate:LAST:rate\\: %8.3lf kbit\\j",
			  "GPRINT:brate:LAST:rate\\:%8.2lf kbyte\\r",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;

		$PNGTEMP4 = "/home/httpd/html/qos/";
		$PNGTEMP4 .= "$graph";
		$PNGTEMP4 .= ".year.png";

		unlink $PNGTEMP4;

	        RRDs::graph ("$PNGTEMP4",
       	         "--start", "-31536000", "-aPNG", "-i", "-z",
             		  "--alt-y-grid", "-w 800", "-h 150", "-r",
	                "--color", "SHADEA#EAE9EE",
             		  "--color", "SHADEB#EAE9EE",
	                "--color", "BACK#EAE9EE",
	                "-t $Lang::tr{'qos class'} $graph",
	                "DEF:rate=$RRDTEMP:rate:AVERAGE",
			  "CDEF:krate=rate,1024,/",
			  "CDEF:brate=rate,1024,/,8,/",
	                "AREA:krate#FFBE7D:kbit",
			  "GPRINT:krate:LAST:rate\\: %8.3lf kbit\\j",
			  "GPRINT:brate:LAST:rate\\:%8.2lf kbyte\\r",
	                );
	        $ERROR = RRDs::error;
       	 print "Error in RRD::graph for class $graph: $ERROR\n" if $ERROR;


	       print "<img src='/qos/$graph.hour.png' border='0' /><br />";
       	print "<img src='/qos/$graph.day.png' border='0' /><br />";
	       print "<img src='/qos/$graph.week.png' border='0' /><br />";
       	print "<img src='/qos/$graph.month.png' border='0' /><br />";
	       print "<img src='/qos/$graph.year.png' border='0' /><br />";
		print "</div></pre>";
	}
	&Header::closebox();
}
&Header::closebigbox();
print "<div align='center'><form method='post' action='/cgi-bin/qos.cgi' /><input type=submit name='ACTION' value='show graphs'><input type=submit name='ACTION' value='mainmenu'></form></div>";
print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
&Header::closepage();








