#! /usr/bin/perl -w
#####################################################################################################
#
#   				(c) Markus Hoffmann, 2005-open end
#
#####################################################################################################
#
# COPYRIGHT NOTICE                                                        
# Copyright 2005 Markus Hoffmann
# All Rights Reserved.                     
# EMail: ipcop@mh-lantech.de
# URL  : http://www.mhaddons.tk
#
# License: CreativeCommons, some right restricted ( http://creativecommons.org/licenses/by-nd/2.5/ )
#
#####################################################################################################
#
# 				    Im Script muss nichts veraendert werden
#				Nothings got to be changed in this script to work
#
#####################################################################################################
#

use RRDs;

require '/var/ipcop/general-functions.pl';

my %netsettings = ();
&General::readhash( "/var/ipcop/ethernet/settings", \%netsettings );

#open(STDOUT, ">/var/log/sammler.log") || die "Can't redirect stdout";
#open(STDERR, ">/var/log/sammler.err") || die "Can't redirect stderr";

#
# added to remove databases older then 7 days 
#
my $DIFF=();
my $dir="/var/log/rrd";
opendir(DIR, "$dir");
foreach my $direntry (readdir(DIR))
{
	next if $direntry eq ".";
	next if $direntry eq "..";
	next if $direntry !~ "1" && $direntry !~ "2" && $direntry !~ "3" && $direntry !~ "4" && $direntry !~ "5";
	next if -d "$dir/$direntry";
	if (-f "$dir/$direntry")
	{
		my ($s, $m, $h, $D, $M, $Y) = localtime((stat ("$dir/$direntry"))[9]); #Last modify time since the epoch
		my ($s1, $m1, $h1, $D1, $M1, $Y1) = localtime;
		if  ( $M == $M1 )
		{
			$DIFF=$D1 - $D;
#			print "$direntry is $DIFF days old\n";
		}
		if  ( $M < $M1 )
		{
			$DIFF=$D - $D1;
#			print "$direntry is $DIFF days old\n";
		}
		if ($DIFF > 7)
		{
			print "$direntry is more then 7 Days old, removing...\n";
			unlink "$dir/$direntry";
		}
	}
}
#
# added to remove databases older then 7 days
#

&sig_handler_setup;
print "Becoming a daemon..\n";
&daemonize;

my @CLASSES="";
my $CMD1="";
my $CMD2="";
my $CMD3="";
my $CMD4="";
my $RRDTEMP="";
my $QOSTEMP1="";
my $QOSTEMP2="";
my $QOSTEMP3="";
my @class="";

my $RED_UP=`cat /var/ipcop/red/iface`;
my $RED_DOWN="imq0";
my $GREEN_UP="$netsettings{'GREEN_DEV'}";
my $GREEN_DOWN="imq1";
my $BLUE_UP="$netsettings{'BLUE_DEV'}";
my $BLUE_DOWN="imq2";
my $ORANGE_UP="$netsettings{'ORANGE_DEV'}";
my $ORANGE_DOWN="imq3";

my @INTERFACES=`ifconfig |cut -d" " -f1|awk '{ if (\$1 != "" && \$1 != "lo") print \$1; }'`;

while (1) {

	foreach my $INTERFACE (sort @INTERFACES)
	{
		chomp($INTERFACE);
		my @classes1 = `/var/ipcop/qos/bin/tc -s -d filter show dev $INTERFACE 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
		my @classes = split( /\ /, "@classes1" ); 
		foreach my $line ( sort @classes )
		{
			@class = split( /\:/, $line );
			{
				$CMD1="/var/ipcop/qos/bin/tc -s -d class show dev $INTERFACE | grep -w \"hfsc $class[0]:";
				$CMD2="/var/ipcop/qos/bin/tc -s -d class show dev $INTERFACE | grep -w \"hfsc $class[0]:";
				$CMD3="/var/ipcop/qos/bin/tc -s -d class show dev $INTERFACE | grep -w \"hfsc $class[0]:";
				$CMD1 .= $class[1];
				$CMD2 .= $class[1];
				$CMD3 .= $class[1];
				chomp ($CMD1);
				chomp ($CMD2);
				chomp ($CMD3);
				$CMD1 .= "\" -A 4 | grep Sent | tr -d [:punct:] | awk '{print \$4\":\"\$7\":\"\$9 }'";
				$CMD2 .= "\" -A 4 | grep period | tr -d [:punct:] | awk '{print \$2}'";
				$CMD3 .= "\" -A 4 | grep period | tr -d [:punct:] | awk '{print \$4}'";
				$QOSTEMP1=`$CMD1`;
				$QOSTEMP2=`$CMD2`;
				$QOSTEMP3=`$CMD3`;
				chomp ($QOSTEMP1);
				chomp ($QOSTEMP2);
				chomp ($QOSTEMP3);

	


# added for debug start
#			print "\n\nInterface: $INTERFACE Klasse0: $class[0]\n\nBefehl:$CMD1\n";
#			print "Klasse: $class[1] Pakets/Dropped/Overlimits: $QOSTEMP1  Period: $QOSTEMP2 Work: $QOSTEMP3\n";
#			print "N:$QOSTEMP1:$QOSTEMP2:$QOSTEMP3\n";
# added for debug end

				$RRDTEMP = "/var/log/rrd/";
				$RRDTEMP .= $class[1];
				chomp ($RRDTEMP);
				$RRDTEMP .= ".rrd";
	
				if (! -f $RRDTEMP) {
				print "rrd does not exist: $RRDTEMP\n";
					RRDs::create($RRDTEMP, 
				               "--step=15",
			             		 "DS:pkts:COUNTER:30:0:U",
		              		 "DS:dropped:COUNTER:30:0:U",
              				 "DS:overlimit:COUNTER:30:0:U",
				               "DS:period:COUNTER:30:0:U",
       		       		 "DS:work:COUNTER:30:0:U",
       	       			 "RRA:AVERAGE:0.3:1:1440",     # 6h zu 15s
	       	       		 "RRA:AVERAGE:0.3:4:1440",     # 24h zu 1m
			              	 "RRA:AVERAGE:0.3:20:2016",     # 1 Woche zu 5m
			       	        "RRA:AVERAGE:0.3:120:1448",    # 1 Monat zu 30 Minuten
              				 "RRA:AVERAGE:0.3:960:2196",   # 1 Jahr zu 60 Minuten
			       	       );
				  	$ERR = RRDs::error;
			  		die("While creating $RRDTEMP: $ERR") if $ERR;
				}
	
				RRDs::update( "$RRDTEMP", "N:$QOSTEMP1:$QOSTEMP2:$QOSTEMP3");
	
			}

		@CLASSES="";
		$CMD1="";
		$CMD2="";
		$CMD3="";
		$RRDTEMP="";
		$QOSTEMP1="";
		$QOSTEMP2="";
		$QOSTEMP3="";
		}
	}
	sleep 15;
}

exit 0;

sub daemonize {
  my ($home);
  if (fork()) {
  # parent
    exit(0);
  } else {
    # child
    print "sammler process id $$\n";
    open (GPID, ">/var/run/sammler.pl.pid");
    print GPID $$;
    close (GPID);
    setpgrp(0,0);                   # become process leader
    close(STDOUT);
    close(STDIN);
    close(STDERR);
    print "Testing...\n";
  }
} 

sub sig_handler_setup {
  $SIG{TERM} = \&clean_up_and_exit; # kill
  $SIG{QUIT} = \&clean_up_and_exit; # kill -3
  $SIG{HUP} = \&clean_up_and_exit; # kill -1
}

sub clean_up_and_exit {
  print "received kill sig.. shutting down\n";
  unlink "/var/run/sammler.pl.pid";
  exit;
}