#!/bin/bash
#
#####################################################################################################
#
#   				(c) Markus Hoffmann, 2005-open end
#
#####################################################################################################
#
# COPYRIGHT NOTICE                                                        
# Copyright 2005 Markus Hoffmann
# All Rights Reserved.                     
# EMail: ipcop@mh-lantech.de
# URL  : http://www.mhaddons.tk
#
# License: CreativeCommons, some right restricted ( http://creativecommons.org/licenses/by-nd/2.5/ )
#
#####################################################################################################
#
# 				    Im Script muss nichts veraendert werden
#				Nothings got to be changed in this script to work
#
#####################################################################################################
#

if [ -e "/var/lock/subsys/qos.sh" ]
then
	exit -1
fi

TC="/var/ipcop/qos/bin/tc"
IP="/var/ipcop/qos/bin/ip"
IPTABLES="/var/ipcop/qos/bin/iptables"
REDDEVICE=$(/bin/cat /var/ipcop/red/iface 2>/dev/null| /usr/bin/tr -d '\012' 2>/dev/null)

/bin/touch /var/lock/subsys/qos.sh
while [ "x$REDDEVICE" == "x" ]
do
	sleep 15
	REDDEVICE=$(/bin/cat /var/ipcop/red/iface 2>/dev/null| /usr/bin/tr -d '\012' 2>/dev/null)
done

MTURED=`/sbin/ifconfig $REDDEVICE|grep MTU|cut -d: -f2|cut -d" " -f1`;

if [ "$1" = "test" ]
then
	RUNNING=`$TC -s filter show dev $REDDEVICE`
	$IPTABLES -I INPUT -p icmp -j ACCEPT
	echo -e "\ntesting QoS with different hosts"
	echo -e "\nfirst without QoS:\n"
	/var/ipcop/qos/bin/qos.sh stop>/dev/null 2>&1
	sleep 3
	TESTHOSTS="www.web.de www.spiegel.de www.yahoo.com www.google.com"
	for i in $TESTHOSTS
	do
		echo -e "$i\t\t\c"
		sleep 1
		/bin/ping -q -c 5 -s 1400 $i|grep round
	done
	echo -e "\nnow with QoS:\n"
	/var/ipcop/qos/bin/qos.sh>/dev/null 2>&1
	sleep 3
	for i in $TESTHOSTS
	do
		echo -e "$i\t\t\c"
		/bin/ping -q -c 5 -s 1400 $i|grep round
	done
	echo -e ""
	echo -e ""
	$IPTABLES -D INPUT -p icmp -j ACCEPT
	if [ "x$RUNNING" == "x" ]
	then
		/var/ipcop/qos/bin/qos.sh stop>/dev/null 2>&1
	fi
	/bin/rm -f /var/lock/subsys/qos.sh	
	exit 0
fi
	
if [ "$1" = "status" ]
then
	TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`
	for i in $TCSETTINGS
	do
	 IFACE=`echo $i|cut -d";" -f1`
	 CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
        echo -e "\n[qdisc for $IFACE]"
        $TC -s qdisc show dev $IFACE
        echo -e "\n[class for $IFACE]"
        $TC -s class show dev $IFACE
        echo -e "\n[filter for $IFACE]"
        $TC -s filter show dev $IFACE
        echo -e "\n[iptables for $IFACE]"
        $IPTABLES -t mangle -L $CHAINNAME -v -x -n 2> /dev/null
	 echo -e "\n\n\n"
	done
	/bin/rm -f /var/lock/subsys/qos.sh
       exit 0
fi

if [ "$1" == "stop" ]
then
TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`
for i in $TCSETTINGS
do
	IFACE=`echo $i|cut -d";" -f1`
	HANDLE=`echo $i|cut -d";" -f2`
	PROTO="hfsc"
	DEFAULT=`echo $i|cut -d";" -f4`
	RATE=`echo $i|cut -d";" -f5`
	CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
	CLASSES=`cat /var/ipcop/qos/settings/tc/classes`
	for j in $CLASSES
	do
		ROOTHANDLE=`echo $j|cut -d";" -f1`	
		CLASS=`echo $j|cut -d";" -f2`
		CLASSHANDLE=`echo $j|cut -d";" -f3`
		CLASSPRIO=`echo $j|cut -d";" -f4`
		CLASSMIN=`echo $j|cut -d";" -f5`
		MAXDELAY=`echo $j|cut -d";" -f6`
		MAXRATE=`echo $j|cut -d";" -f7`
		if [ ${ROOTHANDLE} == ${HANDLE} ]
		then
			$TC filter delete dev $IFACE parent ${ROOTHANDLE}: prio ${CLASSPRIO} protocol ip handle $CLASS fw flowid ${ROOTHANDLE}:${CLASS} >/dev/null 2>&1
			if [ $CLASSMIN -ne 1 ]
			then
				CMD="$TC class del dev $IFACE parent ${HANDLE}:${CLASSHANDLE} classid ${CLASSHANDLE}:${CLASS} $PROTO \
											rt m1 ${CLASSMINNEW}kbit d ${MAXDELAY}ms m2 ${CLASSMIN}kbit \
											ls m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit \
											ul m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit"
			else
				CLASSMIN=$(($MAXRATE/5*2))
				if [ ${CLASSMIN} -le 0 ]
				then
					CLASSMIN=1
				fi
				CMD="$TC class del dev $IFACE parent ${HANDLE}:${CLASSHANDLE} classid ${CLASSHANDLE}:${CLASS} $PROTO \
											ls m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit \
											ul m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit"
			fi
			RUNCMD=`echo $CMD`
			$RUNCMD  >/dev/null 2>&1
		fi
	done
	$TC class delete dev $IFACE parent $HANDLE: classid $HANDLE:1 $PROTO ls rate ${RATE}kbit ul rate ${RATE}kbit >/dev/null 2>&1
	$TC qdisc delete dev $IFACE root handle $HANDLE: $PROTO default $DEFAULT >/dev/null 2>&1
	if [ "$IFACE" == "imq0" ]
	then
		$IPTABLES -t mangle --delete PREROUTING -i $REDDEVICE -j $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1
		$IP link set imq0 down >/dev/null 2>&1
		$IPTABLES -t mangle -D PREROUTING -i $REDDEVICE -j IMQ --todev 0 >/dev/null 2>&1
		/sbin/rmmod imq >/dev/null 2>&1
	else
		$IPTABLES -t mangle --delete POSTROUTING -o $IFACE -j $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1
	fi
done
echo -e "QoS has been stopped !"
/bin/rm -f /var/lock/subsys/qos.sh
exit 0
fi

if [ $REDDEVICE == "ppp0" ]
then
	$IP link set dev $REDDEVICE txqlen 500
fi

TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`
for i in $TCSETTINGS
do
	IFACE=`echo $i|cut -d";" -f1`
	HANDLE=`echo $i|cut -d";" -f2`
	PROTO="hfsc"
	DEFAULT=`echo $i|cut -d";" -f4`
	RATE=`echo $i|cut -d";" -f5`
	CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
	CLASSES=`cat /var/ipcop/qos/settings/tc/classes`
	for j in $CLASSES
	do
		ROOTHANDLE=`echo $j|cut -d";" -f1`	
		CLASS=`echo $j|cut -d";" -f2`
		CLASSHANDLE=`echo $j|cut -d";" -f3`
		CLASSPRIO=`echo $j|cut -d";" -f4`
		CLASSMIN=`echo $j|cut -d";" -f5`
		MAXDELAY=`echo $j|cut -d";" -f6`
		MAXRATE=`echo $j|cut -d";" -f7`
		CLASSMINNEW=$(($CLASSMIN/5*2))
		MAXRATENEW=$(($MAXRATE/5*2))
		if [ ${CLASSMINNEW} -le 0 ]
		then
			CLASSMINNEW=1
		fi
		if [ ${MAXRATENEW} -le 0 ]
		then
			MAXRATENEW=1
		fi

		if [ ${ROOTHANDLE} == ${HANDLE} ]
		then
			if [ $CLASSMIN -ne 1 ]
			then
				CMD="$TC class del dev $IFACE parent ${CLASSHANDLE}:${HANDLE} classid ${CLASSHANDLE}:${CLASS} $PROTO \
											rt m1 ${CLASSMINNEW}kbit d ${MAXDELAY}ms m2 ${CLASSMIN}kbit \
											ls m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit \
											ul m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit"
			else	
				CLASSMIN=$(($MAXRATE/5*2))
				if [ ${CLASSMIN} -le 0 ]
				then
					CLASSMIN=1
				fi
				CMD="$TC class del dev $IFACE parent ${CLASSHANDLE}:${HANDLE} classid ${CLASSHANDLE}:${CLASS} $PROTO \
											ls m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit \
											ul m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit"
			fi
			RUNCMD=`echo $CMD`
			$RUNCMD  >/dev/null 2>&1
		fi
	done
	$TC class delete dev $IFACE parent $HANDLE: classid $HANDLE:$CLASSHANDLE $PROTO ls rate ${RATE}kbit ul rate ${RATE}kbit >/dev/null 2>&1
	$TC qdisc delete dev $IFACE root handle $HANDLE: $PROTO default $DEFAULT >/dev/null 2>&1

	if [ "$IFACE" == "imq0" ]
	then
		$IPTABLES -t mangle --delete PREROUTING -i $REDDEVICE -j $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --delete PREROUTING -i $REDDEVICE -j $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1
		$IP link set imq0 down >/dev/null 2>&1
		$IPTABLES -t mangle -D PREROUTING -i $REDDEVICE -j IMQ --todev 0 >/dev/null 2>&1
	else
		$IPTABLES -t mangle --delete POSTROUTING -o $IFACE -j $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1
		$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1
	fi

	if [ "$IFACE" == "imq0" ]
	then
		insmod imq numdevs=1  >/dev/null 2>&1
		insmod ipt_IMQ >/dev/null 2>&1
		sleep 5
		$IP link set imq0 up
		sleep 5
		$IPTABLES -t mangle -A PREROUTING -i $REDDEVICE -j IMQ --todev 0
	fi

	$TC qdisc add dev $IFACE root handle $HANDLE: $PROTO default $DEFAULT
	$TC class add dev $IFACE parent $HANDLE: classid $HANDLE:$HANDLE $PROTO ls rate ${RATE}kbit ul rate ${RATE}kbit
	CLASSES=`cat /var/ipcop/qos/settings/tc/classes`
	for j in $CLASSES
	do
		ROOTHANDLE=`echo $j|cut -d";" -f1`	
		CLASS=`echo $j|cut -d";" -f2`
		CLASSHANDLE=`echo $j|cut -d";" -f3`
		CLASSPRIO=`echo $j|cut -d";" -f4`
		CLASSMIN=`echo $j|cut -d";" -f5`
		MAXDELAY=`echo $j|cut -d";" -f6`
		MAXRATE=`echo $j|cut -d";" -f7`
		CLASSMINNEW=$(($CLASSMIN/5*2))
		MAXRATENEW=$(($MAXRATE/5*2))
		if [ ${CLASSMINNEW} -le 0 ]
		then
			CLASSMINNEW=1
		fi
		if [ ${MAXRATENEW} -le 0 ]
		then
			MAXRATENEW=1
		fi
		
		if [ ${ROOTHANDLE} == ${HANDLE} ]
		then 
			if [ $CLASSMIN -ne 1 ]
			then
				CMD="$TC class add dev $IFACE parent ${CLASSHANDLE}:${HANDLE} classid ${CLASSHANDLE}:${CLASS} $PROTO \
											rt m1 ${CLASSMINNEW}kbit d ${MAXDELAY}ms m2 ${CLASSMIN}kbit \
											ls m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit \
											ul m1 ${CLASSMIN}kbit d ${MAXDELAY}ms m2 ${MAXRATE}kbit"
			else
				CLASSMIN=$(($MAXRATE/5*2))
				if [ ${CLASSMIN} -le 0 ]
				then
					CLASSMIN=1
				fi
				CMD="$TC class add dev $IFACE parent ${CLASSHANDLE}:${HANDLE} classid ${CLASSHANDLE}:${CLASS} $PROTO \
											ls m1 ${MAXRATENEW} d ${MAXDELAY}ms m2 ${MAXRATE}kbit \
											ul m1 ${MAXRATENEW} d ${MAXDELAY}ms m2 ${MAXRATE}kbit"
			fi
			RUNCMD=`echo $CMD`
			$RUNCMD
			$TC filter add dev $IFACE parent ${ROOTHANDLE}: prio ${CLASSPRIO} protocol ip handle $CLASS fw flowid ${ROOTHANDLE}:${CLASS}
		fi
	done
done

for i in $TCSETTINGS
do
	IFACE=`echo $i|cut -d";" -f1`
	DEFAULT=`echo $i|cut -d";" -f4`
	CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
	ACKPRIO=`cat /var/ipcop/qos/settings/tc/ack`

	if [ $IFACE == "imq0" ]
	then
		$IPTABLES -t mangle --new-chain $CHAINNAME
		$IPTABLES -t mangle --insert PREROUTING -i $REDDEVICE -j $CHAINNAME
	else
		if [ $IFACE == $REDDEVICE ]
		then
			$IPTABLES -t mangle --new-chain $CHAINNAME
			$IPTABLES -t mangle --insert POSTROUTING -o $IFACE -j $CHAINNAME
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ACK ACK -m length --length :64 -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ACK ACK -m length --length :64 -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ACK ACK -m length --length :64 -j RETURN
####test######

			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags SYN,RST SYN -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags SYN,RST SYN -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags SYN,RST SYN -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -m length --length 40:100 -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -m length --length 40:100 -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --syn -m length --length 40:68 -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --syn -m length --length 40:68 -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --syn -m length --length 40:68 -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL SYN,ACK -m length --length 40:68 -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL SYN,ACK -m length --length 40:68 -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL SYN,ACK -m length --length 40:68 -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK -m length --length 40:100 -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK -m length --length 40:100 -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK -m length --length 40:100 -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL RST -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL RST -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL RST -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK,RST -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK,RST -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK,RST -j RETURN
			
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK,FIN -j TOS --set-tos 4
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK,FIN -j MARK --set-mark $ACKPRIO
			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p tcp --tcp-flags ALL ACK,FIN -j RETURN

####test######

		else
			$IPTABLES -t mangle --new-chain $CHAINNAME
			$IPTABLES -t mangle --insert POSTROUTING -o $IFACE -j $CHAINNAME
		fi
	fi
done

RULES=`cat /var/ipcop/qos/settings/layer7/rules`
for i in $RULES
do
NAME=`echo $i|cut -d";" -f1`
PROTO=`echo $i|cut -d";" -f2`
PRIO=`echo $i|cut -d";" -f3`
IFACE=`echo $i|cut -d";" -f4`
SOURCE=`echo $i|cut -d";" -f5`
DESTINATION=`echo $i|cut -d";" -f6`
CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
if [ $IFACE != "imq0" ]
then
	if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN
	fi
	if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN
	fi
	if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN
	fi
	if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN
	fi
else
	if [ "x$SOURCE" != "x"  ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN
	else
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN
	fi
fi
done

RULES=`cat /var/ipcop/qos/settings/other/rules`
for i in $RULES
do
NAME=`echo $i|cut -d";" -f1`
PROTO=`echo $i|cut -d";" -f2`
PRIO=`echo $i|cut -d";" -f3`
SPORT=`echo $i|cut -d";" -f4`
DPORT=`echo $i|cut -d";" -f5`
SOURCE=`echo $i|cut -d";" -f6`
DESTINATION=`echo $i|cut -d";" -f7`
IFACE=`echo $i|cut -d";" -f8`
CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
if [ "x$SPORT" != "x" ]
then 
	SRANGE=`expr index $SPORT ":"`
else
	SRANGE=0
fi
if [ "x$DPORT" != "x" ]
then 
	DRANGE=`expr index $DPORT ":"`
else
	DRANGE=0
fi
if [ $PROTO == "tcp" -o $PROTO == "udp" ]
then
	if [ $SRANGE -eq 0 -a $DRANGE -eq 0 ]
	then
	  if [ $IFACE != "imq0" ]
	  then	
  		if [ "x$SPORT" == "x" -a "x$DPORT" == "x" ]
	  	then
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN
  			fi
	  		if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO
 				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j RETURN
  			fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j RETURN
  			fi
	  	fi
  		if [ "x$SPORT" != "x" -a "x$DPORT" != "x" ]
	  	then
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	  		then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
	  	fi
  		if [ "x$SPORT" != "x" -a "x$DPORT" == "x" ]
	  	then
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j RETURN
  			fi
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j RETURN
  			fi
	  		if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --sport $SPORT -j RETURN
  			fi
  		fi
	  	if [ "x$SPORT" == "x" -a "x$DPORT" != "x" ]
  		then
	  		if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j RETURN
  			fi
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j RETURN
  			fi
	  		if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --dport $DPORT -j RETURN
  			fi
  		fi
	  else
  		if [ "x$SPORT" == "x" -a "x$DPORT" == "x" ]
	  	then
  			if [ "x$SOURCE" == "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j MARK --set-mark $PRIO
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j RETURN
			else
				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j RETURN
  			fi
  		fi
	  	if [ "x$SPORT" != "x" -a "x$DPORT" != "x" ]
  		then
	  		if [ "x$SOURCE" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
			else
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
  		fi
	  	if [ "x$SPORT" != "x" -a "x$DPORT" == "x" ]
  		then
	  		if [ "x$SOURCE" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --sport $SPORT -j RETURN
			else
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j RETURN
  			fi
	  	fi
  		if [ "x$SPORT" == "x" -a "x$DPORT" != "x" ]
	  	then
  			if [ "x$SOURCE" == "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --dport $DPORT -j RETURN
			else
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j RETURN
  			fi
  		fi
	  fi
	else
	  if [ $IFACE != "imq0" ]
	  then	
  		if [ "x$SPORT" == "x" -a "x$DPORT" == "x" ]
	  	then
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN
  			fi
	  		if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO
 				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j RETURN
  			fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j RETURN
  			fi
	  	fi
  		if [ "x$SPORT" != "x" -a "x$DPORT" != "x" ]
	  	then
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	  		then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
	  	fi
  		if [ "x$SPORT" != "x" -a "x$DPORT" == "x" ]
	  	then
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT -j RETURN
  			fi
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT -j RETURN
  			fi
	  		if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT -j RETURN
  			fi
  		fi
	  	if [ "x$SPORT" == "x" -a "x$DPORT" != "x" ]
  		then
	  		if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT -j RETURN
  			fi
  			if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT -j RETURN
	  		fi
  			if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT -j RETURN
  			fi
	  		if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT -j RETURN
  			fi
  		fi
	  else
  		if [ "x$SPORT" == "x" -a "x$DPORT" == "x" ]
	  	then
  			if [ "x$SOURCE" == "x" ]
	  		then
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j MARK --set-mark $PRIO
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j RETURN
			else
				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j RETURN
  			fi
  		fi
	  	if [ "x$SPORT" != "x" -a "x$DPORT" != "x" ]
  		then
	  		if [ "x$SOURCE" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
			else
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN
  			fi
  		fi
	  	if [ "x$SPORT" != "x" -a "x$DPORT" == "x" ]
  		then
	  		if [ "x$SOURCE" == "x" ]
  			then
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT -j RETURN
			else
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT -j RETURN
  			fi
	  	fi
  		if [ "x$SPORT" == "x" -a "x$DPORT" != "x" ]
	  	then
  			if [ "x$SOURCE" == "x" ]
  			then
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT -j RETURN
			else
	  			$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO
  				$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT -j RETURN
  			fi
  		fi
	  fi
	fi
else
  if [ $IFACE != "imq0" ]
  then
	if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN
	fi
	if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j RETURN
	fi
	if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j RETURN
	fi
	if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j RETURN
	fi
  else
	if [ "x$SOURCE" != "x" -a "x$DESTINATION" != "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN
	fi
	if [ "x$SOURCE" != "x" -a "x$DESTINATION" == "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j RETURN
	fi
	if [ "x$SOURCE" == "x" -a "x$DESTINATION" != "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO -j RETURN
	fi
	if [ "x$SOURCE" == "x" -a "x$DESTINATION" == "x" ]
	then
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j MARK --set-mark $PRIO
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j RETURN
	fi
  fi
fi
done


TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`
for i in $TCSETTINGS
do
	IFACE=`echo $i|cut -d";" -f1`
	DEFAULT=`echo $i|cut -d";" -f4`
	CHAINNAME=`echo -e "QOS$IFACE"| tr [:lower:] [:upper:]`
  	if [ $IFACE != "imq0" ]
  	then
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -j MARK --set-mark $DEFAULT
		$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -j RETURN
	else
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -j MARK --set-mark $DEFAULT
		$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -j RETURN	
	fi
done

/bin/rm -f /var/lock/subsys/qos.sh

exit 0

