#!/usr/bin/perl -w
#
#####################################################################################################
#
#   				(c) Markus Hoffmann, 2005-open end
#
#####################################################################################################
#
# COPYRIGHT NOTICE                                                        
# Copyright 2005 Markus Hoffmann
# All Rights Reserved.                     
# EMail: ipcop@mh-lantech.de
# URL  : http://www.mhaddons.tk
#
# License: CreativeCommons, some right restricted ( http://creativecommons.org/licenses/by-nd/2.5/ )
#
#####################################################################################################
#
# 				    Im Script muss nichts veraendert werden
#				Nothings got to be changed in this script to work
#
#####################################################################################################
#
# Rev. 1.5.0.251106 
#
use strict;

sub backround {
	if ( -e "/var/run/qos.pl.pid" ) { exit(0); }
	if (fork()) {
	exit(0);
	} else {
		open (GPID, ">>/var/run/qos.pl.pid");
		print GPID $$;
		close (GPID);
		setpgrp(0,0);
		close(STDOUT);
		close(STDIN);
		close(STDERR);
	}
}

my $DEBUG=0;
my @INPUT="";
if (@ARGV) {@INPUT=@ARGV;}
if ( $INPUT[1] && $INPUT[1] eq "debug" ) { $DEBUG=1; }

#some error testing
my $ACKPRIO=`cat /var/ipcop/qos/settings/tc/ack`; chomp($ACKPRIO);
if ( "x$ACKPRIO" eq "x" ) { print "No ACK-priority defined, exiting...\n"; unlink "/var/ipcop/qos/settings/enable"; exit (0); }
my $HASNOIMQ=`grep -v imq /var/ipcop/qos/settings/tc/settings`; chomp($HASNOIMQ);
my $HASIMQ=`grep imq /var/ipcop/qos/settings/tc/settings`; chomp($HASIMQ);
if ( "x$HASIMQ" ne "x" && "x$HASNOIMQ" eq "x" ) { print "No other device than imq defined, exiting...\n"; unlink "/var/ipcop/qos/settings/enable"; exit (0); }
my $REDDEVICE=`cat /var/ipcop/red/iface 2>/dev/null`; chomp ($REDDEVICE);
if ( "x$REDDEVICE" eq "x" ) { 
	&backround;
	while ( "x$REDDEVICE" eq "x" ) {
		sleep 15;
		$REDDEVICE=`cat /var/ipcop/red/iface 2>/dev/null`;
		chomp ($REDDEVICE);
	}
	unlink "/var/run/qos.pl.pid";
}

my $CMD;
my $SC;
my $DC;
my $PING;
my $TOS;
my $RUNNING;
my @TCSETTINGS;
my $IFACE;
my @RULES;
my $CHAINNAME;
my @temp;
my $temp;
my $HANDLE;
my $PROTO;
my $R2Q;
my $DEFAULT;
my $RATE;
my $i;
my $j;
my $count=0;
my $PARENTCLASS;
my $DESTINATION;
my $DRANGE;
my $SRANGE;
my $SOURCE;
my $DPORT;
my $SPORT;
my @CLASSES;
my $ROOTHANDLE;
my $CLASS;
my $SUBCLASS;
my @SUBCLASSES;
my $CLASSHANDLE;
my $CLASSPRIO;
my $CLASSRATE;
my $CEIL;
my $TMPCEIL;
my $PRIO;
my $NAME;
my $BURST="";
my $CBURST="";
my $BURST1="";
my $CBURST1="";
my $PERTURB;
my $DEF;
my $TC="/sbin/tc";
my $IP="/sbin/ip";
my $IPTABLES="/sbin/iptables";
my $MTURED=` /sbin/ifconfig $REDDEVICE|grep MTU|cut -d: -f2|cut -d" " -f1`;
chomp ($MTURED);
my $TESTHOSTS="www.web.de www.spiegel.de www.yahoo.com www.google.com";

if ( $INPUT[0] eq "test" )
{
	$CMD="$TC -s filter show dev $REDDEVICE";
	$RUNNING=qx( $CMD );
	$CMD="$IPTABLES -I CUSTOMINPUT -p icmp -j ACCEPT";
	`$CMD`;
	print  "\ntesting QoS with different hosts\n";
	print  "\nfirst without QoS:\n\n";
	`/var/ipcop/qos/bin/qos.pl stop>/dev/null 2>&1`;
	sleep 5;
	foreach $i ( split(/\ /,$TESTHOSTS) )
	{
		print  "$i\t\t";
		sleep 1;
		$CMD="/bin/ping -q -c 5 -s 1400 $i|grep round";
		$PING=qx( $CMD );
		print "$PING\n";
	}
	print  "\nnow with QoS:\n\n";
	`/var/ipcop/qos/bin/qos.pl>/dev/null 2>&1`;
	sleep 5;
	foreach $i ( split(/\ /,$TESTHOSTS) )
	{
		print  "$i\t\t";
		$CMD="/bin/ping -q -c 5 -s 1400 $i|grep round";
		$PING=qx( $CMD );
		print "$PING\n";
	}
	$CMD="$IPTABLES -D CUSTOMINPUT -p icmp -j ACCEPT";
	`$CMD`;
	if ( "x$RUNNING" eq "x" )
	{
		`/var/ipcop/qos/bin/qos.pl stop>/dev/null 2>&1`;
	}	
	exit 0;
}

if ( $INPUT[0] eq "status" )
{
	@TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`;
	foreach $i ( @TCSETTINGS )
	{
		chomp ($i);
		@temp = split(/\;/,$i);
	 	$IFACE = $temp[0];
		$CHAINNAME = "QOS".$IFACE;
		$CHAINNAME =~ tr/a-z/A-Z/;
        	print  "\n[qdisc for $IFACE]\n";
        	$CMD = "$TC -s qdisc show dev $IFACE";
		$temp = `$CMD`;
		print $temp."\n";
        	print  "\n[class for $IFACE]\n";
             	$CMD = "$TC -s class show dev $IFACE";
		$temp = `$CMD`;
		print $temp."\n";
        	print  "\n[filter for $IFACE]\n";
             	$CMD = "$TC -s filter show dev $IFACE";
		$temp=`$CMD`;
		print $temp."\n";
        	print  "\n[iptables for $IFACE]\n";
             	$CMD = "$IPTABLES -t mangle -L $CHAINNAME -v -x -n 2> /dev/null";
		$temp = `$CMD`;
		print $temp."\n";
	}
       exit 0;
}

if ( $INPUT[0] eq "stop" )
{
	@TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`;
	foreach $i ( @TCSETTINGS )
	{
		chomp ($i);
		@temp = split(/\;/,$i);
	 	$IFACE = $temp[0];
		$HANDLE = $temp[1];
		$PROTO = $temp[2];
		$DEFAULT = $temp[3];
		$RATE = $temp[4];
		$CHAINNAME = "QOS".$IFACE;
		$CHAINNAME =~ tr/a-z/A-Z/;

		$CMD="$TC qdisc delete dev $IFACE root >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
	
		if ( $IFACE eq "imq0" )
		{
			$CMD="$IPTABLES -t mangle --delete PREROUTING -i $REDDEVICE -j $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="$IPTABLES -t mangle --flush $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="$IPTABLES -t mangle --delete-chain $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="$IP link set imq0 down";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="$IPTABLES -t mangle -D PREROUTING -i $REDDEVICE -j IMQ --todev 0";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="/sbin/rmmod imq >/dev/null 2>&1";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		}
		else
		{
			$CMD="$IPTABLES -t mangle --delete POSTROUTING -o $IFACE -j $CHAINNAME >/dev/null 2>&1";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			$CMD="$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		}
	}
	if ( $DEBUG eq 1 ) { print  "\nQoS has been stopped !\n"; } else { print  "QoS has been stopped !\n"; }
	exit 0;
}

if ( $REDDEVICE eq "ppp0" ) {
	$CMD="$IP link set dev $REDDEVICE txqlen 10";
	if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
}

@TCSETTINGS=`cat /var/ipcop/qos/settings/tc/settings`;
foreach $i ( @TCSETTINGS )
{
	if ( $DEBUG eq 1 ) { print "\n"; }
	chomp ($i);
	@temp = split(/\;/,$i);
 	$IFACE = $temp[0];
	$HANDLE = $temp[1];
	$PROTO = $temp[2];
	$DEFAULT = $temp[3];
	$RATE = $temp[4];
	$CHAINNAME = "QOS".$IFACE;
	$CHAINNAME =~ tr/a-z/A-Z/;

	$CMD="$TC qdisc delete dev $IFACE root >/dev/null 2>&1";
	if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

	if ( $IFACE eq "imq0" )
	{
		$CMD="$IPTABLES -t mangle --delete PREROUTING -i $REDDEVICE -j $CHAINNAME >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IP link set imq0 down >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle -D PREROUTING -i $REDDEVICE -j IMQ --todev 0 >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="/sbin/rmmod imq >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
	}
	else
	{
		$CMD="$IPTABLES -t mangle --delete POSTROUTING -o $IFACE -j $CHAINNAME >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle --flush $CHAINNAME >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle --delete-chain $CHAINNAME >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
	}

	if ( $IFACE eq "imq0" )
	{
		$CMD="/sbin/modprobe imq numdevs=1  >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="/sbin/insmod ipt_IMQ  >/dev/null 2>&1";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		sleep 5;
		$CMD="$IP link set imq0 up";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		sleep 5;
		$CMD="$IPTABLES -t mangle -A PREROUTING -i $REDDEVICE -j IMQ --todev 0";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
	}

# Specify queue discipline
#$R2Q=int($RATE*100/8/1454);
#$R2Q = sprintf("%.0f" , $R2Q);
#
#	if ( "$IFACE" eq "ppp0" )
#	{
#		$R2Q=16384;
#	}
#	else
#	{
#		$R2Q=16384;
#	}

	$R2Q    = int ( ($RATE * 1024) / 16384 );
	$RATE = int ( ($RATE * 100) / 101 );

	$CMD="$TC qdisc add dev $IFACE root handle ".$HANDLE.": $PROTO default $DEFAULT r2q $R2Q";
	
	if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

# Set root class
	if ( $IFACE eq $REDDEVICE )
	{
		$CMD="$TC class add dev $IFACE parent $HANDLE: classid $HANDLE:$HANDLE $PROTO rate ".$RATE."kbit ceil ".$RATE."kbit mtu ".$MTURED;
	} else {
		$CMD="$TC class add dev $IFACE parent $HANDLE: classid $HANDLE:$HANDLE $PROTO rate ".$RATE."kbit ceil ".$RATE."kbit";
	}
	
	if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

	@CLASSES=`cat /var/ipcop/qos/settings/tc/classes`;
	foreach $j ( @CLASSES )
	{
		if ( $DEBUG eq 1 ) { print "\n"; }
		chomp ( $j );
		@temp = split(/\;/,$j);
		$ROOTHANDLE = $temp[0];	
		$CLASS = $temp[1];
		$CLASSHANDLE = $temp[2];
		$CLASSPRIO = $temp[3];
		$CLASSRATE = $temp[4];
		$CEIL = $temp[5];
		$BURST = $temp[6];
		$CBURST = $temp[7];
		$PERTURB = $temp[8];

		if ( $ROOTHANDLE eq $HANDLE )
		{ 
# Specify classes
			if ( $CLASSRATE ne 0 )
			{
				$CMD="$TC class add dev $IFACE parent ".$ROOTHANDLE.":".$CLASSHANDLE." classid ".$CLASSHANDLE.":".$CLASS." ".$PROTO." rate ".$CLASSRATE."kbit ceil ".$CEIL."kbit prio ".$CLASSPRIO;
			}
			else
			{
				$TMPCEIL = int($CEIL/10*1);
				$CMD="$TC class add dev $IFACE parent ".$ROOTHANDLE.":".$CLASSHANDLE." classid ".$CLASSHANDLE.":".$CLASS." ".$PROTO." rate ".$TMPCEIL."kbit ceil ".$CEIL."kbit prio ".$CLASSPRIO;
			}

			if ( $BURST )
			{
				$CMD=$CMD." burst ".$BURST."k";
			}

			if ( $CBURST )
			{
				$CMD=$CMD." cburst ".$CBURST."k";
			}

			if ( $IFACE eq $REDDEVICE )
			{
				$CMD=$CMD." mtu ".$MTURED;
			}				
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

			$CMD="$TC filter add dev $IFACE parent ".$CLASSHANDLE.":0 protocol ip prio ".$CLASSPRIO." handle ".$CLASS." fw classid ".$CLASSHANDLE.":".$CLASS;
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

			if ( ! $PERTURB )
			{
				$CMD="$TC qdisc add dev $IFACE parent ".$CLASSHANDLE.":".$CLASS." handle ".$CLASS.": sfq perturb 10";
			}
			else
			{
				$CMD="$TC qdisc add dev $IFACE parent ".$CLASSHANDLE.":".$CLASS." handle ".$CLASS.": sfq perturb ".$PERTURB;
			}
			if ( $CLASSPRIO eq 1 )
			{
				$CMD="$TC qdisc add dev $IFACE parent ".$CLASSHANDLE.":".$CLASS." handle ".$CLASS.": pfifo limit 2";
				
				#if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			}
			
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			if ( $DEBUG eq 1 ) { print "\n"; }
		}
	}

	@SUBCLASSES=`cat /var/ipcop/qos/settings/tc/subclasses`;
	foreach $j ( @SUBCLASSES )
	{
		if ( $DEBUG eq 1 ) { print "\n"; }
		chomp ( $j );
		@temp = split(/\;/,$j);
		$ROOTHANDLE = $temp[0];	
		$PARENTCLASS = $temp[1];
		$SUBCLASS = $temp[2];
		$CLASSPRIO = $temp[3];
		$CLASSRATE = $temp[4];
		$CEIL = $temp[5];
		$BURST = $temp[6];
		$CBURST = $temp[7];
		$PERTURB = $temp[8];

		if ( $ROOTHANDLE eq $HANDLE )
		{
			if ( $CLASSRATE ne 0 )
			{
				$CMD="$TC class add dev $IFACE parent ".$ROOTHANDLE.":".$PARENTCLASS." classid ".$ROOTHANDLE.":".$SUBCLASS." ".$PROTO." rate ".$CLASSRATE."kbit ceil ".$CEIL."kbit prio ".$CLASSPRIO;
			}
			else
			{
				$TMPCEIL = $CEIL/4*1;
				$CMD="$TC class add dev $IFACE parent ".$ROOTHANDLE.":".$PARENTCLASS." classid ".$ROOTHANDLE.":".$SUBCLASS." ".$PROTO." rate ".$TMPCEIL."kbit ceil ".$CEIL."kbit prio ".$CLASSPRIO;
			}

			if ( $BURST )
			{
				$CMD=$CMD." burst ".$BURST."k";
			}

			if ( $CBURST )
			{
				$CMD=$CMD." cburst ".$CBURST."k";
			}

			if ( $IFACE eq $REDDEVICE )
			{
				$CMD=$CMD." mtu ".$MTURED;
			}

			
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

			$CMD="$TC filter add dev $IFACE parent ".$ROOTHANDLE.":0 protocol ip prio ".$CLASSPRIO." handle ".$SUBCLASS." fw classid ".$ROOTHANDLE.":".$SUBCLASS;
			
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

			if ( ! $PERTURB )
			{
				$CMD="$TC qdisc add dev $IFACE parent ".$ROOTHANDLE.":".$SUBCLASS." handle ".$SUBCLASS.": sfq perturb 10";
			}
			else
			{
				$CMD="$TC qdisc add dev $IFACE parent ".$ROOTHANDLE.":".$SUBCLASS." handle ".$SUBCLASS.": sfq perturb ".$PERTURB;
			}
			if ( $CLASSPRIO eq "1" )
			{
				$CMD="$TC qdisc add dev $IFACE parent ".$ROOTHANDLE.":".$SUBCLASS." handle ".$SUBCLASS.": pfifo limit 2";
				
				#if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			}
#			
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		}
	}

}

foreach $i ( @TCSETTINGS )
{
	if ( $DEBUG eq 1 ) { print "\n"; }
	chomp ($i);
	@temp = split(/\;/,$i);
 	$IFACE = $temp[0];
	$DEFAULT = $temp[3];
	$CHAINNAME = "QOS".$IFACE;
	$CHAINNAME =~ tr/a-z/A-Z/;
	$ACKPRIO=`cat /var/ipcop/qos/settings/tc/ack`;
	chomp ($ACKPRIO);
	if ( "$IFACE" eq "imq0" )
	{
		$CMD="/sbin/modprobe imq numdevs=1 >/dev/null 2>&1";
		
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle --new-chain $CHAINNAME";
		
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
		$CMD="$IPTABLES -t mangle --insert PREROUTING -i $REDDEVICE -j $CHAINNAME";
		
		if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -j DSCP --set-dscp 46";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -j MARK --set-mark $ACKPRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		if ( $DEBUG eq 1 ) { print "\n"; }

	}
	else
	{
		if ( $IFACE eq $REDDEVICE )
		{
			$CMD="$IPTABLES -t mangle --new-chain $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

			$CMD="$IPTABLES -t mangle --insert POSTROUTING -o $IFACE -j $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }
			if ( $DEBUG eq 1 ) { print "\n"; }

########test#########
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -p tcp --syn -m length --length 40:68 -j TOS --set-tos 16";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -p tcp --syn -m length --length 40:68 -j MARK --set-mark $ACKPRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -p tcp --syn -m length --length 40:68 -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			if ( $DEBUG eq 1 ) { print "\n"; }
########test#########

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -j DSCP --set-dscp 46";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -j MARK --set-mark $ACKPRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p icmp -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			if ( $DEBUG eq 1 ) { print "\n"; }
		}
		else
		{
			$CMD="$IPTABLES -t mangle --new-chain $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

			$CMD="$IPTABLES -t mangle --insert POSTROUTING -o $IFACE -j $CHAINNAME";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; `$CMD`; } else { `$CMD`; }

		}

	}
}



@RULES=`cat /var/ipcop/qos/settings/layer7/rules`;
foreach $i ( @RULES )
{
	if ( $DEBUG eq 1 ) { print "\n"; }
	chomp ($i);
	@temp = split(/\;/,$i);
 	$NAME = $temp[0];
	$PROTO = $temp[1];
	$PRIO = $temp[2];
	$IFACE = $temp[3];
	$SOURCE = $temp[4];
	$DESTINATION = $temp[5];
	$TOS = $temp[6];
	if ( $TOS ) { chomp($TOS); }
	if ( $TOS eq "24" || $TOS eq "46" ) { 
		$TOS = "DSCP --set-dscp ".$TOS;
	} else {
		$TOS = "TOS --set-tos ".$TOS;
	}
	$CHAINNAME = "QOS".$IFACE;
	$CHAINNAME =~ tr/a-z/A-Z/;


	if ( $IFACE ne "imq0" )
	{
		if ( ! $SOURCE && ! $DESTINATION )
		{
			if ( $TOS ) {
				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j $TOS";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
		if ( $SOURCE && ! $DESTINATION )
		{
			if ( $TOS ) {
				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j $TOS";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
		if ( $SOURCE && $DESTINATION )
		{
			if ( $TOS ) {
				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j $TOS";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
		if ( ! $SOURCE && $DESTINATION )
		{
			if ( $TOS ) {
				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j $TOS";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
	}
	else
	{
		if ( $SOURCE )
		{
			if ( $TOS ) {
				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j $TOS";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
		else
		{
			if ( $TOS ) {
				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j $TOS";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j MARK --set-mark $PRIO";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -m layer7 --l7dir /etc/l7-protocols/protocols --l7proto $PROTO -j RETURN";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
	}
}

@RULES=`cat /var/ipcop/qos/settings/other/rules`;
foreach $i ( @RULES )
{
	if ( $DEBUG eq 1 ) { print "\n"; }
	chomp ($i);
	@temp = split(/\;/,$i);
 	$NAME = $temp[0];
	$PROTO = $temp[1];
	$PRIO = $temp[2];
	$SPORT = $temp[3];
	$DPORT = $temp[4];
	$SOURCE = $temp[5];
	$DESTINATION = $temp[6];
	$IFACE = $temp[7];
	$TOS = $temp[8];
	if ( $TOS ) { chomp($TOS); }
	if ( $TOS eq "24" || $TOS eq "46" ) { 
		$TOS = "DSCP --set-dscp ".$TOS;
	} else {
		$TOS = "TOS --set-tos ".$TOS;
	}
	$CHAINNAME = "QOS".$IFACE;
	$CHAINNAME =~ tr/a-z/A-Z/;


	if ( $SPORT )
	{
		$SRANGE = index ($SPORT,":");
		$SRANGE++;
	}
	else
	{
		$SRANGE=0;
	}

	if ( $DPORT )
	{ 
		$DRANGE = index ($DPORT,":");
		$DRANGE++;
	}
	else
	{
		$DRANGE=0;
	}

#print  "\nSRANGE/DRANGE: ".$SRANGE." ".$DRANGE."\n\n";

if ( $PROTO eq "tcp" || $PROTO eq "udp" )
{
	if ( $SRANGE eq 0 && $DRANGE eq 0 )
	{
	  if ( $IFACE ne "imq0" )
	  {	
  		if ( ! $SPORT && ! $DPORT )
	  	{
  			if ( $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  		if ( $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

 				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  			if ( ! $SOURCE && $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  		}
  			if ( ! $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  	}
###########################
  		if ( $SPORT && $DPORT )
	  	{
			if ( $SPORT !~ "," && $DPORT !~ "," )
			{
				if ( $SOURCE && $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( $SOURCE && ! $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		  		}
  				if ( ! $SOURCE && ! $DESTINATION )
  				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT =~ "," )
			{
				my @SPORTS = split (',',$SPORT);
				foreach $SC ( @SPORTS )
				{
		  			if ( $SOURCE && $DESTINATION )
			  		{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		  			}
					if ( $SOURCE && ! $DESTINATION )
  					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
	
			  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		  			if ( ! $SOURCE && $DESTINATION )
			  		{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
		
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
	  				if ( ! $SOURCE && ! $DESTINATION )
					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
				}
			}
			if ( $SPORT !~ "," && $DPORT =~ "," )
			{
	  			if ( $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
				if ( $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
	  			if ( ! $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT !~ "," )
			{
	  			if ( $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
				if ( $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
	  			if ( ! $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
	  	}
#################################
  		if ( $SPORT && ! $DPORT )
	  	{
  			if ( $SOURCE && $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  			if ( $SOURCE && ! $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  		}
  			if ( ! $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  		if ( ! $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
	  	if ( ! $SPORT && $DPORT )
  		{
	  		if ( $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  			if ( $SOURCE && ! $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  		}
  			if ( ! $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -m multiport --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  		if ( ! $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -m multiport --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
	  } else {
  		if ( ! $SPORT && ! $DPORT )
	  	{
  			if ( ! $SOURCE )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			} else {
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}

###########################
  		if ( $SPORT && $DPORT )
	  	{
  			if ( $SPORT !~ "," && $DPORT !~ "," )
	  		{
  				if ( $SOURCE && $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( $SOURCE && ! $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
  				if ( ! $SOURCE && ! $DESTINATION )
  				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
		  	}
			if ( $SPORT =~ "," && $DPORT =~ "," )
			{
				my @SPORTS = split (',',$SPORT);
				foreach $SC ( @SPORTS )
				{
		  			if ( $SOURCE && $DESTINATION )
			  		{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		  			}
					if ( $SOURCE && ! $DESTINATION )
  					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
	
			  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		  			if ( ! $SOURCE && $DESTINATION )
			  		{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
		
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
	  				if ( ! $SOURCE && ! $DESTINATION )
					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
				}
			}
			if ( $SPORT !~ "," && $DPORT =~ "," )
			{
	  			if ( $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
				if ( $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
	  			if ( ! $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT  -m multiport --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT !~ "," )
			{
	  			if ( $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
				if ( $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
	  			if ( ! $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT  -m multiport --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
	  	}
#################################
		if ( $SPORT && ! $DPORT )
		{
			if ( ! $SOURCE )
			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			} else {
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			}
		}
  		if ( ! $SPORT && $DPORT )
	  	{
  			if ( ! $SOURCE )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -m multiport --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			} else {
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -m multiport --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
	  }
	} else {
	  if ( $IFACE ne "imq0" )
	  {	
  		if ( ! $SPORT && ! $DPORT )
	  	{
  			if ( $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  		if ( $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

 				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  			if ( ! $SOURCE && $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  		}
  			if ( ! $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  	}
###########################
  		if ( $SPORT && $DPORT )
	  	{
			if ( $SPORT !~ "," && $DPORT !~ "," )
			{
				if ( $SOURCE && $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( $SOURCE && ! $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && $DESTINATION )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		  		}
  				if ( ! $SOURCE && ! $DESTINATION )
  				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT =~ "," )
			{
				my @SPORTS = split (',',$SPORT);
				foreach $SC ( @SPORTS )
				{
		  			if ( $SOURCE && $DESTINATION )
			  		{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SC  -m multiport --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		  			}
					if ( $SOURCE && ! $DESTINATION )
  					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SC  --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
	
			  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SC  --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SC  --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		  			if ( ! $SOURCE && $DESTINATION )
			  		{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SC  --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
		
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SC  --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SC  --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
	  				if ( ! $SOURCE && ! $DESTINATION )
					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SC  --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SC  --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SC  --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
				}
			}
			if ( $SPORT !~ "," && $DPORT =~ "," )
			{
	  			if ( $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT  --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
				if ( $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT  --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT  --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT  --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
	  			if ( ! $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT  --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT  --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT  --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT  --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT  --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT  --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT !~ "," )
			{
	  			if ( $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT  --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  			}
				if ( $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT  --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT  --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT  --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
	  			if ( ! $SOURCE && $DESTINATION )
		  		{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT  --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
		
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT  --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT  --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE && ! $DESTINATION )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT  --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT  --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT  --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
	  	}
#################################
  		if ( $SPORT && ! $DPORT )
	  	{
  			if ( $SOURCE && $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  			if ( $SOURCE && ! $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  		}
  			if ( ! $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  		if ( ! $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
	  	if ( ! $SPORT && $DPORT )
  		{
	  		if ( $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  			if ( $SOURCE && ! $DESTINATION )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  		}
  			if ( ! $SOURCE && $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  		if ( ! $SOURCE && ! $DESTINATION )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
	  } else {
  		if ( ! $SPORT && ! $DPORT )
	  	{
  			if ( ! $SOURCE )
	  		{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			} else {
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
  		if ( $SPORT && $DPORT )
	  	{
			if ( $SPORT !~ "," && $DPORT !~ "," )
			{
  				if ( $SOURCE )
	  			{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

	  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
  				if ( ! $SOURCE )
  				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT --dport $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT =~ "," )
			{
				my @SPORTS = split (',',$SPORT);
				foreach $SC ( @SPORTS )
				{
					if ( $SOURCE )
  					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SC  --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}
	
			  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SC  --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
	  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SC  --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	  				if ( ! $SOURCE )
					{
						if ( $TOS ) {
							$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SC  --dports $DPORT -j $TOS";
							if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
						}

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SC  --dports $DPORT -j MARK --set-mark $PRIO";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SC  --dports $DPORT -j RETURN";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	  				}
				}
			}
			if ( $SPORT !~ "," && $DPORT =~ "," )
			{
				if ( $SOURCE )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT  --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT  --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT  --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
  				if ( ! $SOURCE )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT  --dports $DPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT  --dports $DPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT  --dports $DPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
			if ( $SPORT =~ "," && $DPORT !~ "," )
			{
				if ( $SOURCE )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT  --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}
	
		  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT  --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	
  					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT  --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}
  				if ( ! $SOURCE )
				{
					if ( $TOS ) {
						$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT  --sports $SPORT -j $TOS";
						if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
					}

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT  --sports $SPORT -j MARK --set-mark $PRIO";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT  --sports $SPORT -j RETURN";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  				}
			}
	  	}
	  	if ( $SPORT && ! $DPORT )
  		{
	  		if ( ! $SOURCE )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			} else {
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --sport $SPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
	  	}
  		if ( ! $SPORT && $DPORT )
	  	{
  			if ( ! $SOURCE )
  			{
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
			} else {
				if ( $TOS ) {
					$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT -j $TOS";
					if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
				}

	  			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT -j MARK --set-mark $PRIO";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

  				$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO --dport $DPORT -j RETURN";
				if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
  			}
  		}
	  }
	}
} else {
  if ( $IFACE ne "imq0" )
  {
	if ( $SOURCE && $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
	if ( $SOURCE && ! $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -s $SOURCE -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
	if ( ! $SOURCE && $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -d $DESTINATION -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
	if ( ! $SOURCE && ! $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
  } else {
	if ( $SOURCE && $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -d $DESTINATION -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
	if ( $SOURCE && ! $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -s $SOURCE -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
	if ( ! $SOURCE && $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -d $DESTINATION -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
	if ( ! $SOURCE && ! $DESTINATION )
	{
		if ( $TOS ) {
			$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j $TOS";
			if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		}
		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j MARK --set-mark $PRIO";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }

		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -p $PROTO -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	}
  }
}
}

if ( $DEBUG eq 1 ) { print " \n"; }

@RULES=`cat /var/ipcop/qos/settings/tc/settings`;
foreach $i ( @RULES )
{
	chomp ($i);
	@temp = split(/\;/,$i);
 	$DEF = $temp[3];
	$IFACE = $temp[0];
	$CHAINNAME = "QOS".$IFACE;
	$CHAINNAME =~ tr/a-z/A-Z/;
  	if ( $IFACE ne "imq0" )
  	{
		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -j MARK --set-mark $DEF";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		$CMD="$IPTABLES -t mangle -A $CHAINNAME -o $IFACE -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
	} else {
		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -j MARK --set-mark $DEF";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }
		$CMD="$IPTABLES -t mangle -A $CHAINNAME -i $REDDEVICE -j RETURN";
		if ( $DEBUG eq 1 ) { print "$CMD\n"; system($CMD); } else { system($CMD); }	
	}
}

if ( $DEBUG eq 1 ) { print  "\nQoS has been started !\n"; } else { print  "QoS has been started !\n"; }

exit 0;


