#!/usr/bin/perl
#
#####################################################################################################
#
#   				(c) Markus Hoffmann, 2005-open end
#
#####################################################################################################
#
# COPYRIGHT NOTICE                                                        
# Copyright 2005 Markus Hoffmann
# All Rights Reserved.                     
# EMail: ipcop@mh-lantech.de
# URL  : http://www.mhaddons.tk
# License: CreativeCommons, some right restricted ( http://creativecommons.org/licenses/by-nd/2.5/ )
#

use strict;

# enable only the following on debugging purpose
#use warnings;
use CGI::Carp 'fatalsToBrowser';
use RRDs;

require '/var/ipcop/general-functions.pl';
require "${General::swroot}/lang.pl";
require "${General::swroot}/header.pl";

my $REBOOT=`/sbin/insmod ipt_layer7 2>&1|grep unresolved`;
my $refresh = '';
#$refresh = "<meta http-equiv='refresh' content='60;' />";

&Header::showhttpheaders();
&Header::openpage('QoS', 1, $refresh);

if ( $REBOOT ) {
	&Header::openbigbox( '100%', 'left', '');
	&Header::openbox( '100%', 'left', "$Lang::tr{'error messages'}" );
	print <<END;
<table width="100%" cellspacing="0" border="0">
	<tr>
		<td width="100%" bgcolor="#dd0000" align="center">&nbsp;</td>
	<tr>
	<tr>
		<td width="100%" bgcolor="#dd0000" align="center"><font size="+2" color="#ffffff"><b>$Lang::tr{'qosreboot'}<b></font></td>
	<tr>
	<tr>
		<td width="100%" bgcolor="#dd0000" align="center">&nbsp;</td>
	<tr>
</table>
END
	&Header::closebox();
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	&Header::closepage();
	exit 0;
}

print <<END;

<script type="text/javascript">
<!--
function BorderOn (id) { id.className='btnOn'  }
function BorderOff(id) { id.className='btnOff' }
//-->
</script>

<style type=text/css>
.btnOn {
	 height: 20px;
	 width: 20px;
        border-right: #D5F0FF 2px Inset;
        border-top: #D5F0FF 2px Inset;
        border-left: #D5F0FF 2px Inset;
        border-bottom: #D5F0FF 2px Inset;
        text-align: Center;
        text-decoration: None;
}

.btnOff {
	 height: 20px;
	 width: 20px;
        border-right: #D5F0FF 2px Outset;
        border-top: #D5F0FF 2px Outset;
        border-left: #D5F0FF 2px Outset;
        border-bottom: #D5F0FF 2px Outset;
        text-align: Center;
        text-decoration: None;
}
</style>



    <link rel="stylesheet" type="text/css" href="/include/jsvall.css" >
    <script language="javascript" src="/include/jsval.js"></script>

<!-- FREE code from WWW.CGISCRIPT.NET, LLC -->
<STYLE TYPE="text/css"><!--
 BODY {
  scrollbar-arrow-color:#ff0000;
  scrollbar-track-color:#ff0000;
  scrollbar-shadow-color:#330099;
  scrollbar-face-color:#0000ff;
  scrollbar-highlight-color:#0099ff;
  scrollbar-darkshadow-color:#000099;
  scrollbar-3dlight-color:#33ffff;
 }
//--></STYLE>

<style type="text/css"><!--
.editButton{
border-right: #0000B0 3px inset;
border-top: #429CFF 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #429CFF 3px outset;
color: #00FFFF;
border-bottom: #0000B0 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #364AFE; 
}
-->
</style>
<style type="text/css"><!--
.startButton{
border-right: #007700 3px inset;
border-top: #00FF00 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #00FF00 3px outset;
color: #80FF80;
border-bottom: #007700 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #00C100; 
}
-->
</style>
<style type="text/css"><!--
.stopButton{
border-right: #8A0000 3px inset;
border-top: #FF3535 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #FF3535 3px outset;
color: #FF2B2B;
border-bottom: #8A0000 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #C60000; 
}
-->
</style>
<style type="text/css"><!--
.deleteButton{
border-right: #808080 3px inset;
border-top: #FFFFFF 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #FFFFFF 3px outset;
color: #939393;
border-bottom: #646464 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #000000; 
}
-->
</style>
<style type="text/css"><!--
.statusButton{
border-right: #C46200 3px inset;
border-top: #FFB76F 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #FFB76F 3px outset;
color: #E6E600;
border-bottom: #C46200 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #FF8000; 
}
-->
</style>
<style type="text/css"><!--
.saveButton{
border-style:  3;
border-style:  beveled;
font-weight:Bold;
font-size: 10pt; 
color: #000000;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #6CFFB6; 
}
-->
</style>
<style type="text/css"><!--
.defaultButton{
border-right: #6E6E6E 3px inset;
border-top: #D0D0D0 3px outset;
font-weight:Bold;
font-size: 10pt; 
border-left: #D0D0D0 3px outset;
color: #000000 ;
border-bottom: #6E6E6E 3px inset;
font-family: Verdana, Arial, Helvetica, sans-serif;
background-color: #FFFFFF; 
}
-->
</style>

</head>
END

my $MODNAME      = "QoS_NG";
my $MODVERSION   = "1.5.2";
my @LOCALCHECK   = ();
my @VCHECK       = &checkversion( $MODNAME, $MODVERSION );
my $errormessage = "";
if ( $VCHECK[0] eq "There is a newer version available" )
{
	$errormessage = "There is a newer version available";
}

my $ERROR="";
my $RRDTEMP="";
my $PNGTEMP="";
my $PNGTEMP1="";
my $PNGTEMP2="";
my $PNGTEMP3="";
my $line1="";
my $line2="";
my $line3="";
my $i           = "";
my $bgcolor	  = "";
my $deltmp      = "";
my $rulefile    = "";
my $ruleentry   = ();
my @tmpline     = ();
my @tmp         = ();
my $EXISTS      = "";
my $RCEXIST     = "";
my $c           = ();
my $ready       = ();
my $ruleentry   = "";
my $dir         = "";
my $direntry    = "";
my $tmpline     = "";
my @proto       = ();
my $line        = "";
my @otherrules  = ();
my @temp        = ();
my @l7rules     = ();
my $REDDEVICE   = `cat /var/ipcop/red/iface`;
my %qossettings = ();
my @tcsettings  = ();
my $gif = '';
my $toggle = '';
my $gdesc = '';
$qossettings{'EDIT'}        = '';
$qossettings{'EDITCLASS'}        = '';
$qossettings{'EDITSUBCLASS'}        = '';
$qossettings{'EDITRULE'}        = '';
$qossettings{'EDITL7'}        = '';
$qossettings{'DEV'}        = '';
$qossettings{'L7DEV'}        = '';
$qossettings{'TC'}         = '';
$qossettings{'IP'}         = '';
$qossettings{'IPTABLES'}   = '';
$qossettings{'ACTION'}     = '';
$qossettings{'PROT'}       = '';
$qossettings{'L7PROT'}     = '';
$qossettings{'RULENAME'}   = '';
$qossettings{'L7RULENAME'} = '';
$qossettings{'MARK'}       = '';
$qossettings{'L7MARK'}       = '';
$qossettings{'SPORT'}      = '';
$qossettings{'DPORT'}      = '';
$qossettings{'SOURCE'}     = '';
$qossettings{'DEST'}       = '';
$qossettings{'L7SOURCE'}     = '';
$qossettings{'L7DEST'}       = '';
$qossettings{'L7'}         = '';
$qossettings{'DEL'}        = '';
$qossettings{'ROOTHANDLE'} = '';
$qossettings{'INTERFACE'}  = '';
$qossettings{'TCPROTO'}    = '';
$qossettings{'TCDEFAULTRED'}  = '';
$qossettings{'TCRATERED'}     = '';
$qossettings{'TCDEFAULTIMQ'}  = '';
$qossettings{'TCRATEIMQ'}     = '';
$qossettings{'TCDEFAULTGREEN'}  = '';
$qossettings{'TCRATEGREEN'}     = '';
$qossettings{'TCDEFAULTORANGE'}  = '';
$qossettings{'TCRATEORANGE'}     = '';
$qossettings{'TCDEFAULTBLUE'}  = '';
$qossettings{'TCRATEBLUE'}     = '';
$qossettings{'TCDEFAULT'}  = '';
$qossettings{'TCRATE'}     = '';
$qossettings{'TCSAVE'}     = '';
$qossettings{'TCPARENT'}   = '';
$qossettings{'TCCLASS'}    = '';
$qossettings{'TCPRIO'}     = '';
$qossettings{'TCMIN'}      = '';
$qossettings{'TCUMAX'}     = '';
$qossettings{'TCMAXDELAY'} = '';
$qossettings{'ROOTHANDLERED'} = '';
$qossettings{'TCCLASSRED'} = '';
$qossettings{'TCPARENTRED'} = '';
$qossettings{'TCPRIORED'} = '';
$qossettings{'TCMINRED'} = '';
$qossettings{'TCUMAXRED'} = '';
$qossettings{'TCMAXDELAYRED'} = '';
$qossettings{'ROOTHANDLEIMQ'} = '';
$qossettings{'TCCLASSIMQ'} = '';
$qossettings{'TCPARENTIMQ'} = '';
$qossettings{'TCPRIOIMQ'} = '';
$qossettings{'TCMINIMQ'} = '';
$qossettings{'TCUMAXIMQ'} = '';
$qossettings{'TCMAXDELAYIMQ'} = '';
$qossettings{'ROOTHANDLEGREEN'} = '';
$qossettings{'TCCLASSGREEN'} = '';
$qossettings{'TCPARENTGREEN'} = '';
$qossettings{'TCPRIOGREEN'} = '';
$qossettings{'TCMINGREEN'} = '';
$qossettings{'TCUMAXGREEN'} = '';
$qossettings{'TCMAXDELAYGREEN'} = '';
$qossettings{'ROOTHANDLEORANGE'} = '';
$qossettings{'TCCLASSORANGE'} = '';
$qossettings{'TCPARENTORANGE'} = '';
$qossettings{'TCPRIOORANGE'} = '';
$qossettings{'TCMINORANGE'} = '';
$qossettings{'TCUMAXORANGE'} = '';
$qossettings{'TCMAXDELAYORANGE'} = '';
$qossettings{'ROOTHANDLEBLUE'} = '';
$qossettings{'TCCLASSBLUE'} = '';
$qossettings{'TCPARENTBLUE'} = '';
$qossettings{'TCPRIOBLUE'} = '';
$qossettings{'TCPRIOACK'} = '';
$qossettings{'TCMINBLUE'} = '';
$qossettings{'TCUMAXBLUE'} = '';
$qossettings{'TCMAXDELAYBLUE'} = '';
$qossettings{'TCMAXRATERED'} = '';
$qossettings{'TCMAXRATEIMQ'} = '';
$qossettings{'TCMAXRATEBLUE'} = '';
$qossettings{'TCMAXRATEGREEN'} = '';
$qossettings{'TCMAXRATEORANGE'} = '';
$qossettings{'ACK'} = '';
$qossettings{'TODO'} = '';
$qossettings{'BURST'} = '';
$qossettings{'CBURST'} = '';
$qossettings{'BURSTRED'} = '';
$qossettings{'CBURSTRED'} = '';
$qossettings{'BURSTIMQ'} = '';
$qossettings{'CBURSTIMQ'} = '';
$qossettings{'BURSTGREEN'} = '';
$qossettings{'CBURSTGREEN'} = '';
$qossettings{'BURSTBLUE'} = '';
$qossettings{'CBURSTBLUE'} = '';
$qossettings{'BURSTORANGE'} = '';
$qossettings{'CBURSTORANGE'} = '';
$qossettings{'TCPARENTCLASSORANGE'} = '';
$qossettings{'TCPARENTCLASSGREEN'} = '';
$qossettings{'TCPARENTCLASSRED'} = '';
$qossettings{'TCPARENTCLASSIMQ'} = '';
$qossettings{'TCPARENTCLASSBLUE'} = '';
$qossettings{'TCSUBCLASSORANGE'} = '';
$qossettings{'TCSUBCLASSGREEN'} = '';
$qossettings{'TCSUBCLASSRED'} = '';
$qossettings{'TCSUBCLASSIMQ'} = '';
$qossettings{'TCSUBCLASSBLUE'} = '';
$qossettings{'APPLY'} = '';

&Header::getcgihash( \%qossettings );

my %TOS=();
$TOS{'0x00'}="Normal-Service";
$TOS{'0x02'}="Minimize-Cost";
$TOS{'0x04'}="Maximize-Reliability";
$TOS{'0x08'}="Maximize-Throughput";
$TOS{'0x10'}="Minimize-Delay";
$TOS{'24'}="voice control protocols";
$TOS{'46'}="voice (RTP)";

my %netsettings = ();
&General::readhash( "/var/ipcop/ethernet/settings", \%netsettings );

if (   $qossettings{'ACTION'} eq $Lang::tr{'toggle enable disable'} )
{
	unlink "/var/ipcop/qos/settings/apply";
	if (   $qossettings{'APPLY'} eq "on" )
	{
		system("/bin/touch /var/ipcop/qos/settings/apply");
	}
	$qossettings{'ACTION'}='';
	&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
}

if (   $qossettings{'ACTION'} eq "start collector" )
{
	system("/bin/touch /var/ipcop/qos/settings/enable_sammler");
	system("/usr/local/bin/qosctrl sammlerstart >/dev/null 2>&1");
	$qossettings{'ACTION'}='';
}

if (   $qossettings{'ACTION'} eq "stop collector" )
{
	unlink "/var/ipcop/qos/settings/enable_sammler";
	system("/usr/local/bin/qosctrl sammlerstop >/dev/null 2>&1");
	$qossettings{'ACTION'}='';
}

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'ACK'} eq 'YES' )
{
	$rulefile = "/var/ipcop/qos/settings/tc/ack";
	open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
	print FILE <<END;
$qossettings{'TCPRIOACK'}
END
	close FILE;
	if ( -e "/var/ipcop/qos/settings/apply" )
	{
		system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	}
	$qossettings{'ACK'}='';
	$qossettings{'ACTION'}='';
}

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'TCSAVE'} eq 'CLASS' )
{
	if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLERED'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSRED'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTRED'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIORED'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINRED'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXRED'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATERED'};
		$qossettings{'BURST'} = $qossettings{'BURSTRED'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTRED'};
	}

	if ( $qossettings{'INTERFACE'} eq "imq0" )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEIMQ'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSIMQ'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTIMQ'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOIMQ'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINIMQ'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXIMQ'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEIMQ'};
		$qossettings{'BURST'} = $qossettings{'BURSTIMQ'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTIMQ'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEGREEN'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSGREEN'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTGREEN'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOGREEN'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINGREEN'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXGREEN'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEGREEN'};
		$qossettings{'BURST'} = $qossettings{'BURSTGREEN'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTGREEN'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEORANGE'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSORANGE'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTORANGE'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOORANGE'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINORANGE'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXORANGE'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEORANGE'};
		$qossettings{'BURST'} = $qossettings{'BURSTORANGE'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTORANGE'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEBLUE'};
		$qossettings{'TCCLASS'} = $qossettings{'TCCLASSBLUE'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTBLUE'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOBLUE'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINBLUE'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXBLUE'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEBLUE'};
		$qossettings{'BURST'} = $qossettings{'BURSTBLUE'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTBLUE'};
	}

	if (   $qossettings{'ROOTHANDLE'} eq "" || $qossettings{'TCMAXRATE'} eq '' || $qossettings{'TCCLASS'} eq "" || $qossettings{'TCPARENT'}   eq "" || $qossettings{'TCPRIO'} eq "" || $qossettings{'TCMIN'} eq "" )
	{
		$errormessage = "Please enter all required fields !";
	}
	unless ($errormessage)
	{

		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] ne $qossettings{'TCCLASS'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;

		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'ROOTHANDLE'};$qossettings{'TCCLASS'};$qossettings{'TCPARENT'};$qossettings{'TCPRIO'};$qossettings{'TCMIN'};$qossettings{'TCMAXRATE'};$qossettings{'BURST'};$qossettings{'CBURST'};
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';

		$qossettings{'TCCLASSRED'} = '';
		$qossettings{'TCMINRED'}    = '1';
		$qossettings{'TCPRIORED'}     = '';

		$qossettings{'TCCLASSGREEN'} = '';
		$qossettings{'TCMINGREEN'}    = '1';
		$qossettings{'TCPRIOGREEN'}     = '';

		$qossettings{'TCCLASSBLUE'} = '';
		$qossettings{'TCMINBLUE'}    = '1';
		$qossettings{'TCPRIOBLUE'}     = '';

		$qossettings{'TCCLASSORANGE'} = '';
		$qossettings{'TCMINORANGE'}    = '1';
		$qossettings{'TCPRIOORANGE'}     = '';

		$qossettings{'TCCLASSIMQ'} = '';
		$qossettings{'TCMINIMQ'}    = '1';
		$qossettings{'TCPRIOIMQ'}     = '';

		$qossettings{'TCMAXRATERED'} = '';
		$qossettings{'TCMAXRATEIMQ'} = '';
		$qossettings{'TCMAXRATEBLUE'} = '';
		$qossettings{'TCMAXRATEGREEN'} = '';
		$qossettings{'TCMAXRATEORANGE'} = '';

		$qossettings{'CBURST'} = '';
		$qossettings{'CBURST'} = '';
		$qossettings{'CBURSTRED'} = '';
		$qossettings{'CBURSTRED'} = '';
		$qossettings{'CBURSTGREEN'} = '';
		$qossettings{'CBURSTGREEN'} = '';
		$qossettings{'CBURSTIMQ'} = '';
		$qossettings{'CBURSTIMQ'} = '';
		$qossettings{'CBURSTBLUE'} = '';
		$qossettings{'CBURSTBLUE'} = '';
		$qossettings{'CBURSTORANGE'} = '';
		$qossettings{'CBURSTORANGE'} = '';

		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		if ( -e "/var/ipcop/qos/settings/apply" )
		{
			system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
		}
	}
}


####################
#
# added for subclassse
#
if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'TCSAVE'} eq 'SUBCLASS' )
{
	if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLERED'};
		$qossettings{'TCSUBCLASS'} = $qossettings{'TCSUBCLASSRED'};
		$qossettings{'TCPARENTCLASS'} = $qossettings{'TCPARENTCLASSRED'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTRED'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIORED'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINRED'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXRED'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATERED'};
		$qossettings{'BURST'} = $qossettings{'BURSTRED'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTRED'};
	}

	if ( $qossettings{'INTERFACE'} eq "imq0" )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEIMQ'};
		$qossettings{'TCSUBCLASS'} = $qossettings{'TCSUBCLASSIMQ'};
		$qossettings{'TCPARENTCLASS'} = $qossettings{'TCPARENTCLASSIMQ'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTIMQ'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOIMQ'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINIMQ'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXIMQ'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEIMQ'};
		$qossettings{'BURST'} = $qossettings{'BURSTIMQ'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTIMQ'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEGREEN'};
		$qossettings{'TCSUBCLASS'} = $qossettings{'TCSUBCLASSGREEN'};
		$qossettings{'TCPARENTCLASS'} = $qossettings{'TCPARENTCLASSGREEN'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTGREEN'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOGREEN'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINGREEN'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXGREEN'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEGREEN'};
		$qossettings{'BURST'} = $qossettings{'BURSTGREEN'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTGREEN'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEORANGE'};
		$qossettings{'TCSUBCLASS'} = $qossettings{'TCSUBCLASSORANGE'};
		$qossettings{'TCPARENTCLASS'} = $qossettings{'TCPARENTCLASSORANGE'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTORANGE'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOORANGE'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINORANGE'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXORANGE'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEORANGE'};
		$qossettings{'BURST'} = $qossettings{'BURSTORANGE'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTORANGE'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
	{
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEBLUE'};
		$qossettings{'TCSUBCLASS'} = $qossettings{'TCSUBCLASSBLUE'};
		$qossettings{'TCPARENTCLASS'} = $qossettings{'TCPARENTCLASSBLUE'};
		$qossettings{'TCPARENT'} = $qossettings{'TCPARENTBLUE'};
		$qossettings{'TCPRIO'} = $qossettings{'TCPRIOBLUE'};
		$qossettings{'TCMIN'} = $qossettings{'TCMINBLUE'};
		$qossettings{'TCUMAX'} = $qossettings{'TCUMAXBLUE'};
		$qossettings{'TCMAXRATE'} = $qossettings{'TCMAXRATEBLUE'};
		$qossettings{'BURST'} = $qossettings{'BURSTBLUE'};
		$qossettings{'CBURST'} = $qossettings{'CBURSTBLUE'};
	}

	if (   $qossettings{'ROOTHANDLE'} eq "" || $qossettings{'TCPARENTCLASS'} eq "" || $qossettings{'TCMAXRATE'} eq '' || $qossettings{'TCSUBCLASS'} eq "" || $qossettings{'TCPRIO'} eq "" || $qossettings{'TCMIN'} eq "" )
	{
		$errormessage = "Please enter all required fields !";
		$qossettings{'TODO'}="create subclass";
	}
	unless ($errormessage)
	{

		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[2] ne $qossettings{'TCSUBCLASS'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;

		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'ROOTHANDLE'};$qossettings{'TCPARENTCLASS'};$qossettings{'TCSUBCLASS'};$qossettings{'TCPRIO'};$qossettings{'TCMIN'};$qossettings{'TCMAXRATE'};$qossettings{'BURST'};$qossettings{'CBURST'};
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCPARENTCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';

		$qossettings{'TCSUBCLASSRED'} = '';
		$qossettings{'TCPARENTCLASSRED'} = '';
		$qossettings{'TCMINRED'}    = '1';
		$qossettings{'TCPRIORED'}     = '';

		$qossettings{'TCSUBCLASSGREEN'} = '';
		$qossettings{'TCPARENTCLASSGREEN'} = '';
		$qossettings{'TCMINGREEN'}    = '1';
		$qossettings{'TCPRIOGREEN'}     = '';

		$qossettings{'TCSUBCLASSBLUE'} = '';
		$qossettings{'TCPARENTCLASSBLUE'} = '';
		$qossettings{'TCMINBLUE'}    = '1';
		$qossettings{'TCPRIOBLUE'}     = '';

		$qossettings{'TCSUBCLASSORANGE'} = '';
		$qossettings{'TCPARENTCLASSORANGE'} = '';
		$qossettings{'TCMINORANGE'}    = '1';
		$qossettings{'TCPRIOORANGE'}     = '';

		$qossettings{'TCSUBCLASSIMQ'} = '';
		$qossettings{'TCPARENTCLASSIMQ'} = '';
		$qossettings{'TCMINIMQ'}    = '1';
		$qossettings{'TCPRIOIMQ'}     = '';

		$qossettings{'TCMAXRATERED'} = '';
		$qossettings{'TCMAXRATEIMQ'} = '';
		$qossettings{'TCMAXRATEBLUE'} = '';
		$qossettings{'TCMAXRATEGREEN'} = '';
		$qossettings{'TCMAXRATEORANGE'} = '';

		$qossettings{'CBURST'} = '';
		$qossettings{'CBURST'} = '';
		$qossettings{'CBURSTRED'} = '';
		$qossettings{'CBURSTRED'} = '';
		$qossettings{'CBURSTGREEN'} = '';
		$qossettings{'CBURSTGREEN'} = '';
		$qossettings{'CBURSTIMQ'} = '';
		$qossettings{'CBURSTIMQ'} = '';
		$qossettings{'CBURSTBLUE'} = '';
		$qossettings{'CBURSTBLUE'} = '';
		$qossettings{'CBURSTORANGE'} = '';
		$qossettings{'CBURSTORANGE'} = '';

		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		if ( -e "/var/ipcop/qos/settings/apply" )
		{
			system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
		}
	}
}

#
# end added for subclasse
#
####################

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
{
	if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTRED'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATERED'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLERED'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTORED'};
	}

	if ( $qossettings{'INTERFACE'} eq "imq0" )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTIMQ'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEIMQ'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEIMQ'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOIMQ'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTGREEN'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEGREEN'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEGREEN'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOGREEN'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTORANGE'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEORANGE'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEORANGE'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOORANGE'};
	}

	if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
	{
		$qossettings{'TCDEFAULT'} = $qossettings{'TCDEFAULTBLUE'};
		$qossettings{'TCRATE'} = $qossettings{'TCRATEBLUE'};
		$qossettings{'ROOTHANDLE'} = $qossettings{'ROOTHANDLEBLUE'};
		$qossettings{'TCPROTO'} = $qossettings{'TCPROTOBLUE'};
	}

	if (   $qossettings{'INTERFACE'} eq "" || $qossettings{'ROOTHANDLE'} eq "" || $qossettings{'TCPROTO'}    eq "" || $qossettings{'TCDEFAULT'}  eq "" || $qossettings{'TCRATE'}     eq "" )
	{
		$errormessage = "No empty fields allowed !                $qossettings{'INTERFACE'}";
	}

	unless ($errormessage)
	{

		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'INTERFACE'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;

		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'INTERFACE'};$qossettings{'ROOTHANDLE'};$qossettings{'TCPROTO'};$qossettings{'TCDEFAULT'};$qossettings{'TCRATE'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';
		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
	}
}

if (   $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'L7'} eq 'yes' )
{
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[1] eq $qossettings{'L7MARK'} )
		{
			$errormessage = "match";
		}
	}
	$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[2] eq $qossettings{'L7MARK'} )
		{
			$errormessage = "match";
		}
	}
	if ( $errormessage eq "match" )
	{
		$errormessage = "";
	}
	else
	{
		$errormessage = "No class found for mark !";
		$qossettings{'TODO'} = "add layer7 rule";

	}
	if ( $qossettings{'L7SOURCE'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'L7SOURCE'})) { $errormessage = $Lang::tr{'source ip bad'}; 
		$qossettings{'TODO'} = "add layer7 rule";
		}
	}
	if ( $qossettings{'L7DEST'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'L7DEST'})) { $errormessage = $Lang::tr{'destination ip bad'};
		$qossettings{'TODO'} = "add layer7 rule";
		}
	}

	if ( $qossettings{'L7RULENAME'} =~ " " )
	{
		$errormessage = "No spaces allowed in Rulename !";
		$qossettings{'TODO'} = "add layer7 rule";
	}

	if ( length($qossettings{'L7RULENAME'}) > 15 )
	{
		$errormessage = "Rulename to long, only 15 chars allowed !";
		$qossettings{'TODO'} = "add layer7 rule";
	}

	if ( $qossettings{'L7DEV'} eq "imq0" && $qossettings{'L7DEST'} ne "" )
	{
		$errormessage = "You could not set a Destination Ip with the imq0 !";
		$qossettings{'TODO'} = "add layer7 rule";
	}

	if ($qossettings{'L7DEV'} eq $REDDEVICE)
	{
		if ($qossettings{'L7MARK'} lt 100 || $qossettings{'L7MARK'} ge 200)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add layer7 rule";
		}
	}
	if ($qossettings{'L7DEV'} eq "imq0")
	{
		if ($qossettings{'L7MARK'} lt 200 || $qossettings{'L7MARK'} ge 300)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add layer7 rule";
		}
	}
	if ($qossettings{'L7DEV'} eq $netsettings{'GREEN_DEV'})
	{
		if ($qossettings{'L7MARK'} lt 300 || $qossettings{'L7MARK'} ge 400)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add layer7 rule";
		}
	}
	if ($qossettings{'L7DEV'} eq $netsettings{'GREEN_BLUE'})
	{
		if ($qossettings{'L7MARK'} lt 500 || $qossettings{'L7MARK'} ge 600)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add layer7 rule";
		}
	}
	if ($qossettings{'L7DEV'} eq $netsettings{'ORANGE_DEV'})
	{
		if ($qossettings{'L7MARK'} lt 400 || $qossettings{'L7MARK'} ge 500)
		{
			$errormessage = "This mark is not for $qossettings{'L7DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add layer7 rule";
		}
	}
	unless ($errormessage)
	{

		$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'L7RULENAME'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;

		$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'L7RULENAME'};$qossettings{'L7PROT'};$qossettings{'L7MARK'};$qossettings{'L7DEV'};$qossettings{'L7SOURCE'};$qossettings{'L7DEST'};$qossettings{'L7TOS'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'L7MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'L7SOURCE'}     = '';
		$qossettings{'L7DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'L7DEV'}        = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';
		$qossettings{'L7TOS'}     = '';
		$qossettings{'TODO'} = "";
		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		if ( -e "/var/ipcop/qos/settings/apply" )
		{
			system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
		}
	}
}

if ( $qossettings{'ACTION'} eq $Lang::tr{'save'} && $qossettings{'L7'} eq 'no' )
{
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[1] eq $qossettings{'MARK'} )
		{
			$errormessage = "match";
			$qossettings{'TODO'} = "add rule";
		}
	}
	$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[2] eq $qossettings{'MARK'} )
		{
			$errormessage = "match";
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ( $errormessage eq "match" )
	{
		$errormessage = "";
	}
	else
	{
		$errormessage = "No class found for mark !";
		$qossettings{'TODO'} = "add rule";
	}

	if ( $qossettings{'SOURCE'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'SOURCE'})) { $errormessage = $Lang::tr{'source ip bad'};
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ( $qossettings{'DEST'} ne '' )
	{ 
		unless(&General::validipormask($qossettings{'DEST'})) { $errormessage = $Lang::tr{'destination ip bad'}; 
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ( $qossettings{'SPORT'} ne '' )
	{ 
		unless(&General::validport($qossettings{'SPORT'}) || &General::validportrange($qossettings{'SPORT'}, 'src')) { $errormessage = "invalid $Lang::tr{'src port'}(s)";
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ( $qossettings{'DPORT'} ne '' )
	{ 
		unless(&General::validport($qossettings{'DPORT'}) || &General::validportrange($qossettings{'DPORT'}, 'dest')) { $errormessage = "invalid $Lang::tr{'dst port'}(s)"; 
			$qossettings{'TODO'} = "add rule";
		}
	}

	if ( $qossettings{'DPORT'} ne '' && $qossettings{'SPORT'} ne '')
	{ 
		if ( $qossettings{'DPORT'} =~ "\," || $qossettings{'SPORT'} =~ "\," )
		{
			$errormessage = "You could not use sourceports and destination ports if you are using multiple ports!";
			$qossettings{'TODO'} = "add rule";
		}
		if ( $qossettings{'DPORT'} =~ "\:" || $qossettings{'SPORT'} =~ "\:" || $qossettings{'DPORT'} =~ "\-" || $qossettings{'SPORT'} =~ "\-")
		{
			$errormessage = "You could not use portranges if you are using source- and destinationports!";
			$qossettings{'TODO'} = "add rule";
		}
	}

	if ($qossettings{'DEV'} eq $REDDEVICE)
	{
		if ($qossettings{'MARK'} lt 100 || $qossettings{'MARK'} ge 200)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ($qossettings{'DEV'} eq "imq0")
	{
		if ($qossettings{'MARK'} lt 200 || $qossettings{'MARK'} ge 300)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ($qossettings{'DEV'} eq $netsettings{'GREEN_DEV'})
	{
		if ($qossettings{'MARK'} lt 300 || $qossettings{'MARK'} ge 400)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ($qossettings{'DEV'} eq $netsettings{'GREEN_BLUE'})
	{
		if ($qossettings{'MARK'} lt 500 || $qossettings{'MARK'} ge 600)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add rule";
		}
	}
	if ($qossettings{'DEV'} eq $netsettings{'ORANGE_DEV'})
	{
		if ($qossettings{'MARK'} lt 400 || $qossettings{'MARK'} ge 500)
		{
			$errormessage = "This mark is not for $qossettings{'DEV'}. Please use a valid mark !";	
			$qossettings{'TODO'} = "add rule";
		}
	}

	if ( $qossettings{'RULENAME'} =~ " " )
	{
		$errormessage = "No spaces allowed in Rulename !";
		$qossettings{'TODO'} = "add rule";
	}

	if ( $qossettings{'DEV'} eq "imq0" && $qossettings{'DEST'} ne "" )
	{
		$errormessage = "You could not set a Destination Ip with the imq0 !";
		$qossettings{'TODO'} = "add rule";
	}

	if ( length($qossettings{'RULENAME'}) > 15 )
	{
		$errormessage = "Rulename to long, only 15 chars allowed !";
		$qossettings{'TODO'} = "add rule";
	}

	if ( $qossettings{'SPORT'} ne '' || $qossettings{'DPORT'} ne '' )
	{
		if ( $qossettings{'PROT'} ne 'tcp' && $qossettings{'PROT'} ne 'udp' )
		{
			$errormessage = "You could not set ports when you use protocols other then tcp or udp !";
			$qossettings{'TODO'} = "add rule";
		}
	}

	unless ($errormessage)
	{

		$rulefile = "/var/ipcop/qos/settings/other/rules";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'RULENAME'} )
			{
				print FILE $ruleentry;
			}
		}

		$qossettings{'SPORT'} =~ tr/-/:/; # replace all - with colons just in case someone used -
		$qossettings{'SPORT'} =~ s/\ \:\ /\:/; # replace all spaces
		$qossettings{'DPORT'} =~ tr/-/:/; # replace all - with colons just in case someone used -
		$qossettings{'DPORT'} =~ s/\ \:\ /\:/; # replace all spaces
		open( FILE, ">> $rulefile" ) or die "Unable to write $rulefile";
		print FILE <<END;
$qossettings{'RULENAME'};$qossettings{'PROT'};$qossettings{'MARK'};$qossettings{'SPORT'};$qossettings{'DPORT'};$qossettings{'SOURCE'};$qossettings{'DEST'};$qossettings{'DEV'};$qossettings{'TOS'}
END
		close FILE;
		$qossettings{'ACTION'}     = '';
		$qossettings{'PROT'}       = '';
		$qossettings{'L7PROT'}     = '';
		$qossettings{'RULENAME'}   = '';
		$qossettings{'MARK'}       = '';
		$qossettings{'L7RULENAME'} = '';
		$qossettings{'SPORT'}      = '';
		$qossettings{'DPORT'}      = '';
		$qossettings{'SOURCE'}     = '';
		$qossettings{'DEST'}       = '';
		$qossettings{'L7'}         = '';
		$qossettings{'DEL'}        = '';
		$qossettings{'DEV'}        = '';
		$qossettings{'ROOTHANDLE'} = '';
		$qossettings{'TCCLASS'}    = '';
		$qossettings{'TCPARENT'}   = '';
		$qossettings{'TCPRIO'}     = '';
		$qossettings{'TCMIN'}      = '1';
		$qossettings{'TCUMAX'}     = '';
		$qossettings{'TCPROTO'}    = '';
		$qossettings{'TCDEFAULT'}  = '';
		$qossettings{'TCRATE'}     = '';
		$qossettings{'TODO'} 	= "";
		&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
		if ( -e "/var/ipcop/qos/settings/apply" )
		{
			system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
		}
	}
}

if ( $qossettings{'ACTION'} eq $Lang::tr{'delete'} )
{
	if ( $qossettings{'L7'} ne '' || $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
	{
		if ( $qossettings{'L7'} eq 'no' )
		{
			$rulefile = "/var/ipcop/qos/settings/other/rules";
		}
		if ( $qossettings{'L7'} eq 'yes' )
		{
			$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		}
		if ( $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
		{
			$rulefile = "/var/ipcop/qos/settings/tc/settings";
		}
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		$deltmp="";
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;
	}

	if ( $qossettings{'TCSAVE'} eq 'SUBCLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[2] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;
	}

	if ( $qossettings{'TCSAVE'} eq 'CLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		open( FILE, "> $rulefile" ) or die "Unable to write $rulefile";
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] ne $qossettings{'DEL'} )
			{
				print FILE $ruleentry;
			}
		}
		close FILE;
	}
	&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
	my $failed="";
	my $CHECK=$qossettings{'DEL'} / 100;
	$CHECK = substr($CHECK, 0, 1); 
	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	foreach $ruleentry (sort @tmp)
	{
		@tmpline = split( /\;/, $ruleentry );
		if ( $tmpline[0] eq $CHECK )
		{
			$failed="ok";
		}
	}
	if ( $failed eq "ok" )
	{
		if ( -e "/var/ipcop/qos/settings/apply" )
		{
			system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
		}
	}
}


if ( $qossettings{'ACTION'} eq $Lang::tr{'edit'} )
{
	if ( $qossettings{'L7'} eq 'no' )
	{
		$rulefile = "/var/ipcop/qos/settings/other/rules";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq $qossettings{'DEL'} )
			{
			$qossettings{'RULENAME'}=$tmpline[0];
			$qossettings{'PROT'}=$tmpline[1];
			$qossettings{'MARK'}=$tmpline[2];
			$qossettings{'SPORT'}=$tmpline[3];
			$qossettings{'SPORT'} =~ s/\:/\ \:\ /; # set all spaces
			$qossettings{'DPORT'}=$tmpline[4];
			$qossettings{'DPORT'} =~ s/\:/\ \:\ /; # set all spaces
			$qossettings{'SOURCE'}=$tmpline[5];
			$qossettings{'DEST'}=$tmpline[6];
			$qossettings{'DEV'}=$tmpline[7];
			$qossettings{'TOS'}=$tmpline[8];
			chomp($qossettings{'TOS'});
			}
		}
	}

	if ( $qossettings{'L7'} eq 'yes' )
	{
		$rulefile = "/var/ipcop/qos/settings/layer7/rules";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq $qossettings{'DEL'} )
			{
			$qossettings{'L7RULENAME'}=$tmpline[0];
			$qossettings{'L7PROT'}=$tmpline[1];
			$qossettings{'L7MARK'}=$tmpline[2];
			$qossettings{'L7DEV'}=$tmpline[3];
			$qossettings{'L7SOURCE'}=$tmpline[4];
			$qossettings{'L7DEST'}=$tmpline[5];
			$qossettings{'L7TOS'}=$tmpline[6];
			chomp($qossettings{'L7TOS'});
			}
		}
	}

	if ( $qossettings{'TCSAVE'} eq 'ROOTCLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
			foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq $qossettings{'DEL'} )
			{
				$qossettings{'INTERFACE'}=$tmpline[0];
				if ( $qossettings{'INTERFACE'} eq $REDDEVICE )
				{
					$qossettings{'TCDEFAULTRED'} = $tmpline[3];
					$qossettings{'TCRATERED'} = $tmpline[4];
				}


				if ( $qossettings{'INTERFACE'} eq "imq0" )
				{
					$qossettings{'TCDEFAULTIMQ'} = $tmpline[3];
					$qossettings{'TCRATEIMQ'} = $tmpline[4];
				}

				if ( $qossettings{'INTERFACE'} eq $netsettings{'GREEN_DEV'} )
				{
					$qossettings{'TCDEFAULTGREEN'} = $tmpline[3];
					$qossettings{'TCRATEGREEN'} = $tmpline[4];
				}

				if ( $qossettings{'INTERFACE'} eq $netsettings{'ORANGE_DEV'} )
				{
					$qossettings{'TCDEFAULTORANGE'} = $tmpline[3];
					$qossettings{'TCRATEORANGE'} = $tmpline[4];
				}

				if ( $qossettings{'INTERFACE'} eq $netsettings{'BLUE_DEV'} )
				{
					$qossettings{'TCDEFAULTBLUE'} = $tmpline[3];
					$qossettings{'TCRATEBLUE'} = $tmpline[4];
				}
			}
		}
	}

	if ( $qossettings{'TCSAVE'} eq 'SUBCLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[2] eq $qossettings{'DEL'} )
			{
				if ( $qossettings{'DEL'} ge "1000" && $qossettings{'DEL'} le "1999" )
				{
					$qossettings{'TCPARENTCLASSRED'}=$tmpline[1];
					$qossettings{'TCSUBCLASSRED'}=$tmpline[2];
					$qossettings{'TCPRIORED'}=$tmpline[3];
					$qossettings{'TCMINRED'}=$tmpline[4];
					$qossettings{'TCMAXRATERED'}=$tmpline[5];
					$qossettings{'BURSTRED'}=$tmpline[6];
					$qossettings{'CBURSTRED'}=$tmpline[7];
				}


				if ( $qossettings{'DEL'} ge "2000" && $qossettings{'DEL'} le "2999" )
				{
					$qossettings{'TCPARENTCLASSIMQ'}=$tmpline[1];
					$qossettings{'TCSUBCLASSIMQ'}=$tmpline[2];
					$qossettings{'TCPRIOIMQ'}=$tmpline[3];
					$qossettings{'TCMINIMQ'}=$tmpline[4];
					$qossettings{'TCMAXRATEIMQ'}=$tmpline[5];
					$qossettings{'BURSTIMQ'}=$tmpline[6];
					$qossettings{'CBURSTIMQ'}=$tmpline[7];
				}

				if ( $qossettings{'DEL'} ge "3000" && $qossettings{'DEL'} le "3999" )
				{
					$qossettings{'TCPARENTCLASSGREEN'}=$tmpline[1];				
					$qossettings{'TCSUBCLASSGREEN'}=$tmpline[2];
					$qossettings{'TCPRIOGREEN'}=$tmpline[3];
					$qossettings{'TCMINGREEN'}=$tmpline[4];
					$qossettings{'TCMAXRATEGREEN'}=$tmpline[5];
					$qossettings{'BURSTGREEN'}=$tmpline[6];
					$qossettings{'CBURSTGREEN'}=$tmpline[7];
				}

				if ( $qossettings{'DEL'} ge "4000" && $qossettings{'DEL'} le "4999" )
				{
					$qossettings{'TCPARENTCLASSORANGE'}=$tmpline[1];				
					$qossettings{'TCSUBCLASSORANGE'}=$tmpline[2];
					$qossettings{'TCPRIOORANGE'}=$tmpline[3];
					$qossettings{'TCMINORANGE'}=$tmpline[4];
					$qossettings{'TCMAXRATEORANGE'}=$tmpline[5];
					$qossettings{'BURSTORANGE'}=$tmpline[6];
					$qossettings{'CBURSTORANGE'}=$tmpline[7];
				}

				if ( $qossettings{'DEL'} ge "5000" && $qossettings{'DEL'} le "5999" )
				{
					$qossettings{'TCPARENTCLASSBLUE'}=$tmpline[1];				
					$qossettings{'TCSUBCLASSBLUE'}=$tmpline[2];
					$qossettings{'TCPRIOBLUE'}=$tmpline[3];
					$qossettings{'TCMINBLUE'}=$tmpline[4];
					$qossettings{'TCMAXRATEBLUE'}=$tmpline[5];
					$qossettings{'BURSTBLUE'}=$tmpline[6];
					$qossettings{'CBURSTBLUE'}=$tmpline[7];
				}
			}
		}
	}


	if ( $qossettings{'TCSAVE'} eq 'CLASS' )
	{
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] eq $qossettings{'DEL'} )
			{
				if ( $qossettings{'DEL'} ge "100" && $qossettings{'DEL'} le "199" )
				{
					$qossettings{'TCCLASSRED'}=$tmpline[1];
					$qossettings{'TCPRIORED'}=$tmpline[3];
					$qossettings{'TCMINRED'}=$tmpline[4];
					$qossettings{'TCMAXRATERED'}=$tmpline[5];
					$qossettings{'BURSTRED'}=$tmpline[6];
					$qossettings{'CBURSTRED'}=$tmpline[7];
				}


				if ( $qossettings{'DEL'} ge "200" && $qossettings{'DEL'} le "299" )
				{
					$qossettings{'TCCLASSIMQ'}=$tmpline[1];
					$qossettings{'TCPRIOIMQ'}=$tmpline[3];
					$qossettings{'TCMINIMQ'}=$tmpline[4];
					$qossettings{'TCMAXRATEIMQ'}=$tmpline[5];
					$qossettings{'BURSTIMQ'}=$tmpline[6];
					$qossettings{'CBURSTIMQ'}=$tmpline[7];
				}

				if ( $qossettings{'DEL'} ge "300" && $qossettings{'DEL'} le "399" )
				{
					$qossettings{'TCCLASSGREEN'}=$tmpline[1];
					$qossettings{'TCPRIOGREEN'}=$tmpline[3];
					$qossettings{'TCMINGREEN'}=$tmpline[4];
					$qossettings{'TCMAXRATEGREEN'}=$tmpline[5];
					$qossettings{'BURSTGREEN'}=$tmpline[6];
					$qossettings{'CBURSTGREEN'}=$tmpline[7];
				}

				if ( $qossettings{'DEL'} ge "400" && $qossettings{'DEL'} le "499" )
				{
					$qossettings{'TCCLASSORANGE'}=$tmpline[1];
					$qossettings{'TCPRIOORANGE'}=$tmpline[3];
					$qossettings{'TCMINORANGE'}=$tmpline[4];
					$qossettings{'TCMAXRATEORANGE'}=$tmpline[5];
					$qossettings{'BURSTORANGE'}=$tmpline[6];
					$qossettings{'CBURSTORANGE'}=$tmpline[7];
				}

				if ( $qossettings{'DEL'} ge "500" && $qossettings{'DEL'} le "599" )
				{
					$qossettings{'TCCLASSBLUE'}=$tmpline[1];
					$qossettings{'TCPRIOBLUE'}=$tmpline[3];
					$qossettings{'TCMINBLUE'}=$tmpline[4];
					$qossettings{'TCMAXRATEBLUE'}=$tmpline[5];
					$qossettings{'BURSTBLUE'}=$tmpline[6];
					$qossettings{'CBURSTBLUE'}=$tmpline[7];
				}
			}
		}
	}
	&General::writehash( "${General::swroot}/qos/settings/settings", \%qossettings );
}


if ( $REDDEVICE eq "ppp0" )
{
	if ( $qossettings{'TCUMAXRED'} eq '' )
	{
		$qossettings{'TCUMAXRED'} = "1492";
	}
	if ( $qossettings{'TCUMAXIMQ'} eq '' )
	{
		$qossettings{'TCUMAXIMQ'} = "1492";
	}
}
else
{
	if ( $qossettings{'TCUMAXRED'} eq '' )
	{
		$qossettings{'TCUMAXRED'} = "1500";
	}
	if ( $qossettings{'TCUMAXIMQ'} eq '' )
	{
		$qossettings{'TCUMAXIMQ'} = "1500";
	}
}

if ( $qossettings{'TCUMAXGREEN'} eq '' )
{
	$qossettings{'TCUMAXGREEN'} = "1500";
}
if ( $qossettings{'TCUMAXORANGE'} eq '' )
{
	$qossettings{'TCUMAXORANGE'} = "1500";
}
if ( $qossettings{'TCUMAXBLUE'} eq '' )
{
	$qossettings{'TCUMAXBLUE'} = "1500";
}

print "<a name='top'>";

print <<END;
<script language="JavaScript" src="/include/overlib_mini.js" type="text/javascript"></script>
<div id="overDiv" style="position: absolute; z-index: 10000; background-image: none; left: 122px; top: 252px; visibility: hidden;"></div>
<script language="JavaScript" type="text/javascript">
		<!--
		function showInfo(name) {
			var pattern = /\b \b/ig;
			name = name.replace(pattern,'_');
			name = name.toLowerCase();
			var src ='/cgi-bin/qosgraphs.cgi?graph='+name+':prev';
			html = '<img border="1" src="'+src+'" name="imagelib" alt="No preview available" width="545" height="255" />';
			return overlib(html, CAPTION, "preview $Lang::tr{'qos class'} "+name)
		}
		-->
</script>
END

&Header::openbigbox( '100%', 'left', '', $errormessage);
if ( $VCHECK[0] eq "There is a newer version available" )
{
	print <<END;
<table CELLSPACING='0' cellpadding='0' width="100%" bgcolor="#ff0000">
<tr>
	<td align="center" width="25%"><b>modname</b></td>
	<td align="center" width="25%"><b>local version</b></td>
	<td align="center" width="25%"><b>online version</b></td>
	<td align="center" width="25%"><b>status</b></td>
</tr>
&nbsp;
<tr>
	<td align="center" width="25%"><b><a href='http://mh-lantech.css-hamburg.de/ipcop/download.php?view.176' target='_blank'>$MODNAME</a></b></td>
	<td align="center" width="25%"><b>$MODVERSION</b></td>
	<td align="center" width="25%"><b><a href='http://mh-lantech.css-hamburg.de/ipcop/request.php?176' target='_blank'>$VCHECK[1]</a></b></td>
	<td align="center" width="25%"><b>$VCHECK[0]<b></td>
</tr>
<tr><td>&nbsp;</td></tr>
</table>
END
}

if ( $errormessage ne "" )
{
	&Header::openbox( '100%', 'left', "$Lang::tr{'error messages'}" );
	print "<b>$errormessage</b>\n";
	&Header::closebox();
}



my %selected = ();
$selected{'PROT'}{'udp'}                  = '';
$selected{'PROT'}{'tcp'}                  = '';
$selected{'PROT'}{ $qossettings{'PROT'} } = "selected";
$dir                                      = "/etc/l7-protocols/protocols";
opendir( DIR, "$dir" );
foreach $direntry ( readdir(DIR) )
{
	next if $direntry eq ".";
	next if $direntry eq "..";
	next if -d "$dir/$direntry";
	@proto = split( /\./, $direntry );
	$selected{'L7PROT'}{'$proto[0]'} = '';
}
$selected{'L7PROT'}{ $qossettings{'L7PROT'} } = "selected";
for ( $c = 1 ; $c <= 100 ; $c++ )
{
	$selected{'MARK'}{'$c'} = '';
}
$selected{'MARK'}{ $qossettings{'MARK'} } = "selected";
for ( $c = 100 ; $c <= 199 ; $c++ )
{
	$selected{'TCDEFAULT'}{'$c'} = '';
}
$selected{'TCDEFAULT'}{ $qossettings{'TCDEFAULT'} } = "TCDEFAULT";
for ( $c = 100 ; $c <= 199 ; $c++ )
{
	$selected{'TCCLASS'}{'$c'} = '';
}
$selected{'TCCLASS'}{ $qossettings{'TCCLASS'} } = "TCCLASS";
for ( $c = 1 ; $c <= 7 ; $c++ )
{
	$selected{'TCPRIO'}{'$c'} = '';
}
$selected{'TCPRIO'}{ $qossettings{'TCPRIO'} } = "TCPRIO";

if ( $qossettings{'ACTION'} eq "test" )
{
	&Header::openbox( '100%', 'left', 'QoS Test' );
	print "<pre><b>";
	system("/usr/local/bin/qosctrl test");
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if (   $qossettings{'ACTION'} eq "update layer7" )
{
	&Header::openbox( '100%', 'left', 'Update layer7 patterns' );
	print "<pre><b>";
	print "Updating layer7 patterns..................";
	system("/usr/local/bin/qosctrl l7update");
	print " finished\n\n";
	system("/usr/bin/tail /var/log/messages|grep Layer7|/usr/bin/tail -1");
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "status" )
{
	print "<a name='log'>";
	&Header::openbox( '100%', 'left', 'log' );
	print "<pre>";
	print "Status:\n<hr>\n";
	system("/usr/local/bin/qosctrl status");
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----MIIHNwYJKoZIhvcNAQcEoIIHKDCCByQCAQExggEwMIIBLAIBADCBlDCBjjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtQYXlQYWwgSW5jLjETMBEGA1UECxQKbGl2ZV9jZXJ0czERMA8GA1UEAxQIbGl2ZV9hcGkxHDAaBgkqhkiG9w0BCQEWDXJlQHBheXBhbC5jb20CAQAwDQYJKoZIhvcNAQEBBQAEgYBfPdUCXsoV+Zr5Lao4lEeCWzeP9TxOj526ycPQdatNw6Yh7I4m2rCBJ9tBp0FjkYwiWN354NUNHEnGqA5hoI+6S9JwoCJkgGhIJrYIY2qhClyEbY04+5vslILDhH8O5FjLFnVYJL+SFVvPN4qicEM+Nt0CCrwigP7wI5TyswQmNTELMAkGBSsOAwIaBQAwgbQGCSqGSIb3DQEHATAUBggqhkiG9w0DBwQIwZkp3y1W/ZaAgZBiaOokq82hmna0NTfiL7umRyx2ft3SJ47hYecqyqD52wSRm5mH7Kh/7+Nu+GTbNZSgC5UWbwFLR/G0sOwH72+gOhZoUp3JdNpUu0I32hfD0zsMR1WdGZ+HvZ3tc8xF7/qpsBh0/VcjiTKjjRlEG0YjCxPIKsXIId5hskzza8q8VMdz8z9O+Sg/NOWt9jX4pvagggOHMIIDgzCCAuygAwIBAgIBADANBgkqhkiG9w0BAQUFADCBjjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtQYXlQYWwgSW5jLjETMBEGA1UECxQKbGl2ZV9jZXJ0czERMA8GA1UEAxQIbGl2ZV9hcGkxHDAaBgkqhkiG9w0BCQEWDXJlQHBheXBhbC5jb20wHhcNMDQwMjEzMTAxMzE1WhcNMzUwMjEzMTAxMzE1WjCBjjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtQYXlQYWwgSW5jLjETMBEGA1UECxQKbGl2ZV9jZXJ0czERMA8GA1UEAxQIbGl2ZV9hcGkxHDAaBgkqhkiG9w0BCQEWDXJlQHBheXBhbC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMFHTt38RMxLXJyO2SmS+Ndl72T7oKJ4u4uw+6awntALWh03PewmIJuzbALScsTS4sZoS1fKciBGoh11gIfHzylvkdNe/hJl66/RGqrj5rFb08sAABNTzDTiqqNpJeBsYs/c2aiGozptX2RlnBktH+SUNpAajW724Nv2Wvhif6sFAgMBAAGjge4wgeswHQYDVR0OBBYEFJaffLvGbxe9WT9S1wob7BDWZJRrMIG7BgNVHSMEgbMwgbCAFJaffLvGbxe9WT9S1wob7BDWZJRroYGUpIGRMIGOMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExFjAUBgNVBAcTDU1vdW50YWluIFZpZXcxFDASBgNVBAoTC1BheVBhbCBJbmMuMRMwEQYDVQQLFApsaXZlX2NlcnRzMREwDwYDVQQDFAhsaXZlX2FwaTEcMBoGCSqGSIb3DQEJARYNcmVAcGF5cGFsLmNvbYIBADAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAIFfOlaagFrl71+jq6OKidbWFSE+Q4FqROvdgIONth+8kSK//Y/4ihuE4Ymvzn5ceE3S/iBSQQMjyvb+s2TWbQYDwcp129OPIbD9epdr4tJOUNiSojw7BHwYRiPh58S1xGlFgHFXwrEBb3dgNbMUa+u4qectsMAXpVHnD9wIyfmHMYIBmjCCAZYCAQEwgZQwgY4xCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEUMBIGA1UEChMLUGF5UGFsIEluYy4xEzARBgNVBAsUCmxpdmVfY2VydHMxETAPBgNVBAMUCGxpdmVfYXBpMRwwGgYJKoZIhvcNAQkBFg1yZUBwYXlwYWwuY29tAgEAMAkGBSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0wNTA2MTQwODM5NTlaMCMGCSqGSIb3DQEJBDEWBBQrO/tPitKL5o4Gri6w6CCcDAeotjANBgkqhkiG9w0BAQEFAASBgAVC1gySE+bw1eOrNsDtrK1Hte557PYHIrFe5GuyFrvNgHJYZYL/BOw4uQz2zUMrSToMVbXlAkbEkVkJKzZkH7fh2TOBaQOYaO2Z6yHr1TsPm1aJPka1jHj87MNzAXZRntuJufO8mMFZxalZB9+qwPzz5kGfltATSw7bJE0CJRHs-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "start" )
{
	system("/bin/touch /var/ipcop/qos/settings/enable");
	&Header::openbox( '100%', 'left', 'Run QoS' );
	print "<pre>";
	system("/usr/local/bin/qosctrl start");	
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "show graphs" || $qossettings{'ACTION'} eq "refresh graphs" )
{
print "<div align='center'><pre>";
my @line=();
my $classnumber="";
my @classes1 = `/sbin/tc -s -d filter show dev $REDDEVICE 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes2 = `/sbin/tc -s -d filter show dev imq0 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes3 = `/sbin/tc -s -d filter show dev $netsettings{'GREEN_DEV'} 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes4 = `/sbin/tc -s -d filter show dev $netsettings{'BLUE_DEV'} 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
my @classes5 = `/sbin/tc -s -d filter show dev $netsettings{'ORANGE_DEV'} 2>/dev/null|awk '{ if (NF>10) print \$12; }'`;
chomp (@classes1);
chomp (@classes2);
chomp (@classes3);
chomp (@classes4);
chomp (@classes5);
my @classes = split( /\ /, "@classes1 @classes2 @classes3 @classes4 @classes5" );
foreach my $classnumber ( sort @classes )
{
			my $tempclassnumber=$classnumber;
			chomp ($tempclassnumber);
			next if $tempclassnumber == "";
      			print "<br><b><font size='+1' color='#ff0000'><div align='center'>\|$tempclassnumber\|</div></font><b><br><br>";
			@line=split( /\:/, $classnumber);
			$line=$line[1];
			$line1 = $line;
			chomp ($line1);
			$line1 .= "_1";
			$line2 = $line;
			chomp ($line2);
			$line2 .= "_2";
			$line3 = $line;
			chomp ($line3);
			$line3 .= "_3";

			$RRDTEMP = "/var/log/rrd/";
			$RRDTEMP .= $line;
			chomp ($RRDTEMP);
			$RRDTEMP .= ".rrd";

			$PNGTEMP = "/home/httpd/html/qos/";
			$PNGTEMP .= "$line";
			chomp ($PNGTEMP);
			$PNGTEMP .= ".png";
	
			unlink $PNGTEMP;
		
		        RRDs::graph ("$PNGTEMP",
              		  "--start", "-3240", "-aPNG", "-i", "-z",
		                "--alt-y-grid", "-w 450", "-h 150", "-r",
              		  "--color", "SHADEA#EAE9EE",
		                "--color", "SHADEB#EAE9EE",
              		  "--color", "BACK#EAE9EE",
#		                "-t $Lang::tr{'qos class'} $tempclassnumber",
		                "-t | packets | dropped | overlimits |",
              		  "DEF:pkts=$RRDTEMP:pkts:AVERAGE",
		                "DEF:dropped=$RRDTEMP:dropped:AVERAGE",
              		  "DEF:overlimit=$RRDTEMP:overlimit:AVERAGE",
		                "AREA:pkts#00FFFF:packets",
              		  "GPRINT:pkts:LAST:total packets\\:%8.3lf %s packets\\j",
		                "LINE3:dropped#FF0000:dropped",
              		  "GPRINT:dropped:LAST:dropped packets\\:%8.3lf %s packets\\j",
		                "LINE3:overlimit#0000FF:overlimit",
              		  "GPRINT:overlimit:LAST:overlimit\\:%8.3lf %s packets\\j",
		                );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

			$PNGTEMP1 = "/home/httpd/html/qos/";
			$PNGTEMP1 .= "$line1";
			$PNGTEMP1 .= ".png";

			unlink $PNGTEMP1;

		        RRDs::graph ("$PNGTEMP1",
		                "--start", "-3240", "-aPNG", "-i", "-z",
              		  "--alt-y-grid", "-w 450", "-h 150", "-r",
		                "--color", "SHADEA#EAE9EE",
              		  "--color", "SHADEB#EAE9EE",
		                "--color", "BACK#EAE9EE",
		                "-t | lended | borrowed | giants |",
		                "DEF:lended=$RRDTEMP:lended:AVERAGE",
              		  "DEF:borrowed=$RRDTEMP:borrowed:AVERAGE",
		                "DEF:giants=$RRDTEMP:giants:AVERAGE",
              		  "AREA:lended#99ff99:lended",
				  "GPRINT:lended:LAST:lended\\:%8.3lf %s packets\\j",
              		  "LINE3:borrowed#f70566:borrowed",
		                "GPRINT:borrowed:LAST:borrowed\\:%8.3lf %s packets\\j",
              		  "LINE3:giants#05ad05:giants",
		                "GPRINT:giants:LAST:giants\\:%8.3lf %s packets\\j",
              		  );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

			$PNGTEMP2 = "/home/httpd/html/qos/";
			$PNGTEMP2 .= "$line2";
			$PNGTEMP2 .= ".png";

			unlink $PNGTEMP2;

		        RRDs::graph ("$PNGTEMP2",
		                "--start", "-3240", "-aPNG", "-i", "-z",
              		  "--alt-y-grid", "-w 450", "-h 150", "-r",
		                "--color", "SHADEA#EAE9EE",
              		  "--color", "SHADEB#EAE9EE",
		                "--color", "BACK#EAE9EE",
		                "-t | tokens | ctokens |",
		                "DEF:tokens=$RRDTEMP:tokens:AVERAGE",
              		  "DEF:ctokens=$RRDTEMP:ctokens:AVERAGE",
		                "AREA:tokens#cc99cc:tokens",
				  "GPRINT:tokens:LAST:tokens\\:%8.3lf %s\\j",
		                "LINE3:ctokens#9900ff:ctokens",
              		  "GPRINT:ctokens:LAST:ctokens\\:%8.3lf %s\\j",
		                );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

			$PNGTEMP3 = "/home/httpd/html/qos/";
			$PNGTEMP3 .= "$line3";
			$PNGTEMP3 .= ".png";

			unlink $PNGTEMP3;

		        RRDs::graph ("$PNGTEMP3",
		                "--start", "-3240", "-aPNG", "-i", "-z",
              		  "--alt-y-grid", "-w 450", "-h 150", "-r",
		                "--color", "SHADEA#EAE9EE",
              		  "--color", "SHADEB#EAE9EE",
		                "--color", "BACK#EAE9EE",
		                "-t | rate in kbit | rate in kbyte |",
		                "DEF:rate=$RRDTEMP:rate:AVERAGE",
				  "CDEF:krate=rate,8,*",
				  "CDEF:brate=rate",
				  "CDEF:kratetext=rate,1024,/,8,*",
				  "CDEF:bratetext=rate,1024,/",
		                "AREA:krate#FFBE7D:kbit",
				"LINE3:brate#D26900:kbyte",
				  "GPRINT:kratetext:LAST:rate\\: %8.3lf kbit\\j",
				  "GPRINT:bratetext:LAST:rate\\:%8.2lf kbyte\\r",
		                );
		        $ERROR = RRDs::error;
		        print "Error in RRD::graph for class $line: $ERROR\n" if $ERROR;

		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:dropped'><img src='/qos/$line.png' border='0' /></a>";
		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:borrowed'><img src='/qos/$line1.png' border='0' /></a><br />";
		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:token'><img src='/qos/$line2.png' border='0' /></a>";
		       print "<a href='/cgi-bin/qosgraphs.cgi?graph=$line:kbit'><img src='/qos/$line3.png' border='0' /></a><hr />";
			}
	print "</div></pre>";
print <<END;
<table width="100%">
	<tr>
		<td align="left" width="33%">
			&nbsp;
		</td>
		<td align="center" width="33%">
			<form method="post" action="/cgi-bin/qos.cgi"><input type="submit" NAME="ACTION" VALUE="refresh graphs">
			&nbsp;
			&nbsp;
			<input type="submit" NAME="ACTION" VALUE="back to mainmenu"></form>
		</td>
		<td align="left" width="33%">
			&nbsp;
		</td>
	</tr>
</table>		
END
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "restart" )
{
	&Header::openbox( '100%', 'left', 'Run QoS' );
	print "<pre>";
	system("/usr/local/bin/qosctrl start >/dev/null 2>&1");
	print "<b>QoS has been restarted</b>";	
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

if ( $qossettings{'ACTION'} eq "stop" )
{
	unlink "/var/ipcop/qos/settings/enable";
	&Header::openbox( '100%', 'left', 'Stop QoS' );
	print "<pre>";
	system("/usr/local/bin/qosctrl stop");	
	print "</b></pre>";
	&Header::closebox();
	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	&Header::closebigbox();
	print <<END;
<div align='right'>
<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
</form>
</div>
END
	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'ACTION'} = "";
	exit 0;
}

&Header::openbox( '100%', 'left', "Version" );
print <<END;
<TABLE WIDTH='100%'>
<tr>
	<TD WIDTH='20%' CLASS='base' ALIGN='center'><a href="http://www.mhaddons.tk" target="_blank" alt="visit mhaddons.tk" title="visit mhaddons.tk"><img src='/images/mhaddons_logo_33_.png'></a></TD>
	<TD WIDTH='20%' CLASS='base' ALIGN='center'>Modname: <a href='http://mh-lantech.css-hamburg.de/ipcop/download.php?view.176' alt="view addon-homepage" title="view addon-homepage" target='_blank'><b>$MODNAME</b></a></TD>
	<TD WIDTH='20%' CLASS='base' ALIGN='center'>Version: <b><font color='#6565ff'>$MODVERSION</font></b></TD>
	<TD WIDTH='20%' CLASS='base' ALIGN='center'>(c) 2005 by: <a href="mailto:info\@mhaddons.tk?subject=QoS_NG" alt="get in contact" title="get in contact"><b>Markus Hoffmann</b></a></TD>
	<TD WIDTH='20%' CLASS='base' ALIGN='center'><a rel="license" href="http://creativecommons.org/licenses/by-nd/2.5/" target='_blank'><img alt="Creative Commons License" border="0" src="/images/somerights20.png"/></a></TD>
</tr>
</TABLE>
END
&Header::closebox();

&Header::openbox( '100%', 'left', "Status" );
if ( -e "/var/ipcop/qos/settings/apply" )
{		
	$qossettings{'APPLY'} = "on";
}
if ($qossettings{'APPLY'} eq 'on') { $gif='on.gif'; $toggle='off'; $gdesc=$Lang::tr{'click to disable'};}
	else { $gif='off.gif'; $toggle='on'; $gdesc=$Lang::tr{'click to enable'}; }
$rulefile = "/var/ipcop/l7filter/localversion";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
chomp ($tmp[0]);
@tmpline = split( /\-/, $tmp[0] );
print <<END;
<TABLE WIDTH='100%'>
<tr>
	<TD WIDTH='30%' CLASS='base' ALIGN='center'>
		<TABLE WIDTH='100%'><tr><td align='right'><b>$Lang::tr{'qos apply changes'}: </b></td>
		<td align='left'>
		<form method='post' name='toggle' action='$ENV{'SCRIPT_NAME'}'>
		<input type='image' name='$Lang::tr{'toggle enable disable'}' src='/images/$gif' title='$gdesc' alt='$gdesc' />
		<input type='hidden' name='APPLY' value='$toggle' />
		<input type='hidden' name='ACTION' value='$Lang::tr{'toggle enable disable'}' />
		</form>
		</td></tr></table>
	</TD>
	<TD WIDTH='20%' CLASS='base' ALIGN='center'><a href="$Lang::tr{'qos help link'}"><b>$Lang::tr{'qos help'}</b></a></TD>
END
	my $sammler_running=`ps -A|grep sammler.pl|awk '{print \$1}'`;
	if ( "x$sammler_running" ne "x" )
	{
		print "<TD WIDTH='25%' CLASS='base' ALIGN='center'>DataCollector running with pid: <b><font color='#6565ff'>$sammler_running</font></b></TD>";
	}
	else
	{
		print "<TD WIDTH='25%' CLASS='base' ALIGN='center'>DataCollector not running !</TD>";
	}
print <<END;
	<TD WIDTH='25%' CLASS='base' ALIGN='center'><a href='http://l7-filter.sourceforge.net/' target='_blank'>Layer7</a> patternfiles: <b><font color='#6565ff'>$tmpline[2].$tmpline[1].$tmpline[0]</font></b></TD>
</tr>
</TABLE>
END
&Header::closebox();

$rulefile = "/var/ipcop/qos/settings/tc/settings";
open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
@tmp = <FILE>;
close FILE;
@tmpline = split( /\;/, $tmp[0] );
if ( $tmpline[0] ne "" )
{
	$ready = "yes";
	if ( $qossettings{'TODO'} eq "" || $qossettings{'TODO'} ne "" )
	{
		my $sammler_running=`ps -A|grep sammler.pl|awk '{print \$1}'`;
		print "<a name='controll'>";
		&Header::openbox( '100%', 'left', "$Lang::tr{'qos control qos'}" );
		print "<form method='post' action='$ENV{'SCRIPT_NAME'}'>\n";
		if ( -e "/var/ipcop/qos/settings/enable" )
		{
			print <<END;
			<table CELLSPACING='0' cellpadding='0' width='100%'>
			<tr>
				<td align='center'>
				<input type='submit' name='ACTION' value='stop' class="stopButton" />
				</td>
				<td align='center'>
				<input type='submit' name='ACTION' value='test' class="editButton" />
				</td>
				<td align='center'>
				<input type='submit' name='ACTION' value='restart' class="startButton" />
				</td>
				<td align='center'>
				<input type='submit' name='ACTION' value='status' class="statusButton" />
				</td>
END
			if ( "x$sammler_running" ne "x" )
			{
				print "<td align='center'>	<input type='submit' name='ACTION' value='show graphs' class='statusButton' /></td>";
				print "<td align='center'>	<input type='submit' name='ACTION' value='stop collector' class='stopButton' /></td>";
			}
			else
			{
				print "<td align='center'>	&nbsp;</td>";
				print "<td align='center'>	<input type='submit' name='ACTION' value='start collector' class='startButton' /></td>";
			}
			print <<END;
			<td align='center'>
			<input type='submit' name='ACTION' value='update layer7' class='defaultButton' />
			</td>
			</tr>
			</table>
END
		}
		else
		{
			print <<END;
			<table CELLSPACING='0' cellpadding='0' width='100%'>
			<tr>
				<td align='center'>
				<input type='submit' name='ACTION' value='start' class="startButton" />
				</td>
				<td align='center'>
				<input type='submit' name='ACTION' value='test' class="statusButton" />
			</td>
			<td align='center'>
			<input type='submit' name='ACTION' value='status' class="statusButton" />
			</td>
			<td>&nbsp;</td>
			<td>&nbsp;</td>
			<td align='center'>
			<input type='submit' name='ACTION' value='update layer7' class="defaultButton" />
			</td>
			</tr>
			</table>
END
		}
		print "</form>\n";


		&Header::closebox();
	}
}
else
{
	$qossettings{'TODO'}="create class";
	$qossettings{'TCPARENTCLASS'}='';
}

if ( $qossettings{'TODO'} eq "create class" || $qossettings{'TODO'} eq $Lang::tr{'qos add rootclass'} )
{
if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 100 && $qossettings{'TCPARENTCLASS'} <= 199 )
{ 
	print "<a name='addclasses'>";
	if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITCLASS'} ne 'YES' )
	{
		&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos add classes'} $REDDEVICE</font>" );
	}
	else
	{
		&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos edit classes'} $qossettings{'TCPARENTCLASS'}</font>" );
	}	
	print <<END;
	<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
END
	$rulefile = "/var/ipcop/qos/settings/tc/settings";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	$RCEXIST="";
	foreach $tmpline (sort @tmp)
	{
		@tcsettings = split( /\;/, $tmpline );
		if ( $tcsettings[0] eq "$REDDEVICE" )
		{
			$RCEXIST                   		= "YES";
			$qossettings{'INTERFACE'}  		= $tcsettings[0];
			$qossettings{'ROOTHANDLERED'} 	= $tcsettings[1];
			$qossettings{'TCPROTORED'}    	= $tcsettings[2];
			$qossettings{'TCDEFAULTRED'}  	= $tcsettings[3];
			$qossettings{'TCRATERED'}     	= $tcsettings[4];
		}
	}
	if ( $RCEXIST ne "YES" || $qossettings{'EDIT'} eq "YES" )
	{
		print <<END;
		<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
			<td width='20%' align='left'> $REDDEVICE</td>
			<td width='20%' align='right'>&nbsp;</td>
			<td width='20%' align='right'>&nbsp;</td>
			<td width='20%' align='right'>&nbsp;</td>			
		</tr>
		<tr>
			<td width='20%' align='right'>&nbsp;</td>
			<td width='20%' align='right'>&nbsp;</td>	
			<td width='20%' align='right'>&nbsp;</td>
			<td width='20%' align='right'>&nbsp;</td>
			<td width='20%' align='right'>&nbsp;</td>			
		</tr>		
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos default class'}:</td>
			<td width='20%' align='left'><select name='TCDEFAULTRED'>
END
		for ( $c = 100 ; $c <= 199 ; $c++ )
		{
			if ( $qossettings{'TCDEFAULTRED'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
		}
		print <<END;
			</select></td>
			<td width='50%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos upload in kbit'}:</td>
			<td width='20%' align='left'><input type='text' name='TCRATERED' value="$qossettings{'TCRATERED'}" err="please enter a valid upload speed!" required="1" /></td>
			<td width='50%' align='left'>( $Lang::tr{'qos max ul speed'} )</td>
		</tr>
		<tr>
			<td width='30%' align='center'>&nbsp;</td>
			<td width='20%' align='center'>&nbsp;</td>
			<td width='50%' align='left'>
				<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
				<input type='hidden' name='ROOTHANDLERED' value='1' />
				<input type='hidden' name='INTERFACE' value='$REDDEVICE' />
				<input type='hidden' name='TCPROTORED' value='htb' />
				<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
			</td>
		</tr>
		</table>
END
	}
  	else
  	{
		if ( $qossettings{'TODO'} eq $Lang::tr{'qos add rootclass'} )
		{
			print "<div align='center'><b>Rootclass already exists, use edit/delete button on mainpage to edit or delete this rootclass !</b></div>";
		}
	}
	if ( $RCEXIST eq "YES" && $qossettings{'TODO'} ne $Lang::tr{'qos add rootclass'} )
	{
		print <<END;
		<table CELLSPACING='0' cellpadding='0' width='100%'>
END
		if ( $qossettings{'EDITCLASS'} ne 'YES' )
		{
		print <<END;
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
			<td width='20%' align='left'><select name='TCCLASSRED'>
END
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 100 ; $c <= 199 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS ne "yes" )
			{
				if ( $qossettings{'TCPARENTCLASS'} ne $c )
				{
  					print "<option value='$c'>$c</option>";
				}
				else
				{
  					print "<option selected value='$c'>$c</option>";			
				}
			}
		}
		print <<END;
			</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq "$REDDEVICE" )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
		</tr>
END
		}
		print <<END;
		<tr>
			<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
			<td width='20%' align='left'><select name='TCPRIORED'>
END
		for ( $c = 1 ; $c <= 7 ; $c++ )
		{
			if ( $qossettings{'TCPRIORED'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
		}
		print <<END;
			</select></td>
			<td width='60%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos minimum upload'}:</td>
END
		if ( $qossettings{'TCMINRED'} eq '' )
		{
			$qossettings{'TCMINRED'} = "1";
		}
		print <<END;
			<td width='20%' align='left'><input type='text' name='TCMINRED' value="$qossettings{'TCMINRED'}" err="please enter a valid upload speed!" required="1" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos max ul rate'}:</td>
			<td width='20%' align='left'><input type='text' name='TCMAXRATERED' value="$qossettings{'TCMAXRATERED'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
			<td width='20%' align='left'><input type='text' name='BURSTRED' value="$qossettings{'BURSTRED'}" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
			<td width='20%' align='left'><input type='text' name='CBURSTRED' value="$qossettings{'CBURSTRED'}" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='left'>&nbsp;</td>
			<td width='20%' align='left'>&nbsp;</td>
			<td width='50%' align='left'>
				<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
				<input type='hidden' name='ROOTHANDLERED' value='1' />
				<input type='hidden' name='TCPARENTRED' value='1' />
				<input type='hidden' name='INTERFACE' value='$REDDEVICE' />
				<input type='hidden' name='TCPROTORED' value='htb' />
END
			if ( $qossettings{'EDITCLASS'} ne '' )
			{
				print "<input type='hidden' name='TCCLASSRED' value=$qossettings{'TCPARENTCLASS'} />";
			}
			print <<END;
				<input type='hidden' name='TCSAVE' value='CLASS' />
			</td>
		</tr>
		</table>
END
	}
	print "</form>\n";
	&Header::closebox();
}

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 200 && $qossettings{'TCPARENTCLASS'} <= 299 )
{ 
  if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITCLASS'} ne 'YES' )
  {
	&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos add classes'} imq0</font>" );
  }
  else
  {
	&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos edit classes'} $qossettings{'TCPARENTCLASS'}</font>" );
  }
  print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  $rulefile = "/var/ipcop/qos/settings/tc/settings";
  open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  @tmp = <FILE>;
  close FILE;
  $RCEXIST = "";
  foreach $tmpline (sort @tmp)
  {
  	@tcsettings = split( /\;/, $tmpline );
  	if ( $tcsettings[0] eq "imq0" )
  	{
  		$RCEXIST                   = "YES";
  		$qossettings{'ROOTHANDLEIMQ'} = $tcsettings[1];
  		$qossettings{'INTERFACE'}  = $tcsettings[0];
  		$qossettings{'TCPROTOIMQ'}    = $tcsettings[2];
  		$qossettings{'TCDEFAULTIMQ'}  = $tcsettings[3];
  		$qossettings{'TCRATEIMQ'}     = $tcsettings[4];
  	}
  }
  if ( $RCEXIST ne "YES"  || $qossettings{'EDIT'} eq "YES" )
  {
  	print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
  	<tr>
  		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
  		<td width='20%' align='left'> imq0</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>			
  	</tr>	
  	<tr>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>	
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>			
  	</tr>	
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos default class'}:</td>
  		<td width='20%' align='left'><select name='TCDEFAULTIMQ'>
END
  	for ( $c = 200 ; $c <= 299 ; $c++ )
  	{
		if ( $qossettings{'TCDEFAULTIMQ'} ne $c )
		{
  			print "<option value='$c'>$c</option>";
		}
		else
		{
  			print "<option selected value='$c'>$c</option>";			
		}
  	}
  	print <<END;
  		</select></td>
  		<td width='50%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos download in kbit'}:</td>
  		<td width='20%' align='left'><input type='text' name='TCRATEIMQ' value="$qossettings{'TCRATEIMQ'}"  err="please enter a valid download speed!" required="1"/></td>
  		<td width='50%' align='left'>( $Lang::tr{'qos max dl speed'} )</td>
  	</tr>
  	<tr>
  		<td width='30%' align='center'>&nbsp;</td>
  		<td width='20%' align='center'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEIMQ' value='2' />
  			<input type='hidden' name='INTERFACE' value='imq0' />
  			<input type='hidden' name='TCPROTOIMQ' value='htb' />
  			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
  		</td>
  	</tr>
  	</table>
END
  }
  else
  {
		if ( $qossettings{'TODO'} eq $Lang::tr{'qos add rootclass'} )
		{
			print "<div align='center'><b>Rootclass already exists, use edit/delete button on mainpage to edit or delete this rootclass !</b></div>";
		}
  }
  if ( $RCEXIST eq "YES" && $qossettings{'TODO'} ne $Lang::tr{'qos add rootclass'}  )
  {
  	print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
END
	if ( $qossettings{'EDITCLASS'} ne 'YES' )
	{
	print <<END;
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos class'}:</td>
  		<td width='20%' align='left'><select name='TCCLASSIMQ'>
END
  	$rulefile = "/var/ipcop/qos/settings/tc/classes";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	for ( $c = 200 ; $c <= 299 ; $c++ )
  	{
  		$EXISTS = "no";
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
  		}
  		if ( $EXISTS ne "yes" )
  		{
			if ( $qossettings{'TCPARENTCLASS'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}	
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
  		}
  	}
  	print <<END;
    	</select></td>
END
  	$rulefile = "/var/ipcop/qos/settings/tc/settings";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	foreach $ruleentry (sort @tmp)
  	{
  		@tmpline = split( /\;/, $ruleentry );
  		if ( $tmpline[0] eq "imq0" )
  		{
  			print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  		}
  	}
  	print <<END;
  	</tr>
END
	}
	print <<END;
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  		<td width='20%' align='left'><select name='TCPRIOIMQ'>
END
  	for ( $c = 1 ; $c <= 7 ; $c++ )
  	{
		if ( $qossettings{'TCPRIOIMQ'} ne $c )
		{
  			print "<option value='$c'>$c</option>";
		}
		else
		{
  			print "<option selected value='$c'>$c</option>";			
		}
  	}
  	print <<END;
  		</select></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos minimum download'}:</td>
END
		if ( $qossettings{'TCMINIMQ'} eq '' )
		{
			$qossettings{'TCMINIMQ'} = "1";
		}
		print <<END;
  		<td width='20%' align='left'><input type='text' name='TCMINIMQ' value="$qossettings{'TCMINIMQ'}" err="please enter a valid download speed!" required="1" /></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max dl rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEIMQ' value="$qossettings{'TCMAXRATEIMQ'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTIMQ' value="$qossettings{'BURSTIMQ'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTIMQ' value="$qossettings{'CBURSTIMQ'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='left'>&nbsp;</td>
		<td width='20%' align='left'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEIMQ' value='2' />
  			<input type='hidden' name='TCPARENTIMQ' value='2' />
  			<input type='hidden' name='INTERFACE' value='imq0' />
  			<input type='hidden' name='TCPROTOIMQ' value='htb' />
END
			if ( $qossettings{'EDITCLASS'} ne '' )
			{
				print "<input type='hidden' name='TCCLASSIMQ' value=$qossettings{'TCPARENTCLASS'} />";
			}
			print <<END;
  			<input type='hidden' name='TCSAVE' value='CLASS' />
  		</td>
  	</tr>
  	</table>
END
  }
  print "</form>\n";
  &Header::closebox();
}

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 300 && $qossettings{'TCPARENTCLASS'} <= 399 )
{ 
  if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITCLASS'} ne 'YES' )
  {
	&Header::openbox( '100%', 'left', "<font color='#00ff00'>$Lang::tr{'qos add classes'} $netsettings{'GREEN_DEV'}</font>" );
  }
  else
  {
	&Header::openbox( '100%', 'left', "<font color='#00ff00'>$Lang::tr{'qos edit classes'} $qossettings{'TCPARENTCLASS'}</font>" );
  }
  print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  $rulefile = "/var/ipcop/qos/settings/tc/settings";
  open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  @tmp = <FILE>;
  close FILE;
  $RCEXIST = "";
  foreach $tmpline (sort @tmp)
  {
  	@tcsettings = split( /\;/, $tmpline );
  	if ( $tcsettings[0] eq $netsettings{'GREEN_DEV'} )
  	{
  		$RCEXIST                   = "YES";
  		$qossettings{'ROOTHANDLEGREEN'} = $tcsettings[1];
  		$qossettings{'INTERFACE'}  = $tcsettings[0];
  		$qossettings{'TCPROTOGREEN'}    = $tcsettings[2];
  		$qossettings{'TCDEFAULTGREEN'}  = $tcsettings[3];
  		$qossettings{'TCRATEGREEN'}     = $tcsettings[4];
  	}
  }
  if ( $RCEXIST ne "YES"  || $qossettings{'EDIT'} eq "YES" )
  {
  	print <<END;
  <table CELLSPACING='0' cellpadding='0' width='100%'>
  <tr>
  	<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
  	<td width='20%' align='left'> $netsettings{'GREEN_DEV'}</td>
  	<td width='20%' align='right'>&nbsp;</td>
  	<td width='20%' align='right'>&nbsp;</td>
  	<td width='20%' align='right'>&nbsp;</td>			
  </tr>	
  <tr>
  	<td width='20%' align='right'>&nbsp;</td>
  	<td width='20%' align='right'>&nbsp;</td>	
  	<td width='20%' align='right'>&nbsp;</td>
  	<td width='20%' align='right'>&nbsp;</td>
  	<td width='20%' align='right'>&nbsp;</td>			
  </tr>	
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'qos default class'}:</td>
  	<td width='20%' align='left'><select name='TCDEFAULTGREEN'>
END
  	for ( $c = 300 ; $c <= 399 ; $c++ )
  	{
		if ( $qossettings{'TCDEFAULTGREEN'} ne $c )
		{
  			print "<option value='$c'>$c</option>";
		}
		else
		{
  			print "<option selected value='$c'>$c</option>";			
		}
  	}
  	print <<END;
  	</select></td>
  	<td width='50%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
  </tr>
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'qos speed in kbit'}:</td>
  	<td width='20%' align='left'><input type='text' name='TCRATEGREEN' value="$qossettings{'TCRATEGREEN'}" err="please enter a valid speed!" required="1" /></td>
  	<td width='50%' align='left'>( $Lang::tr{'qos max speed'} )</td>
  </tr>
  <tr>
  	<td width='30%' align='center'>&nbsp;</td>
  	<td width='20%' align='center'>&nbsp;</td>
  	<td width='50%' align='left'>
  		<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  		<input type='hidden' name='ROOTHANDLEGREEN' value='3' />
  		<input type='hidden' name='INTERFACE' value='$netsettings{'GREEN_DEV'}' />
  		<input type='hidden' name='TCPROTOGREEN' value='htb' />
  		<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
  	</td>
  </tr>
  </table>
END
  }
  else
  {
		if ( $qossettings{'TODO'} eq $Lang::tr{'qos add rootclass'} )
		{
			print "<div align='center'><b>Rootclass already exists, use edit/delete button on mainpage to edit or delete this rootclass !</b></div>";
		}
  }
  if ( $RCEXIST eq "YES" && $qossettings{'TODO'} ne $Lang::tr{'qos add rootclass'} )
  {
  	print <<END;
  <table CELLSPACING='0' cellpadding='0' width='100%'>
END
  if ( $qossettings{'EDITCLASS'} ne 'YES' )
  {
  print <<END;
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'qos class'}:</td>
  	<td width='20%' align='left'><select name='TCCLASSGREEN'>
END
  	$rulefile = "/var/ipcop/qos/settings/tc/classes";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	for ( $c = 300 ; $c <= 399 ; $c++ )
  	{
  		$EXISTS = "no";
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
  		}
  		if ( $EXISTS ne "yes" )
  		{
				if ( $qossettings{'TCPARENTCLASS'} ne $c )
				{
  					print "<option value='$c'>$c</option>";
				}
				else
				{
  					print "<option selected value='$c'>$c</option>";			
				}
  		}
  	}
  	print <<END;
  	</select></td>
END
  	$rulefile = "/var/ipcop/qos/settings/tc/settings";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	foreach $ruleentry (sort @tmp)
  	{
  		@tmpline = split( /\;/, $ruleentry );
  		if ( $tmpline[0] eq $netsettings{'GREEN_DEV'} )
  		{
  			print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  		}
  	}
  	print <<END;
  </tr>
END
  }
  print <<END;
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  	<td width='20%' align='left'><select name='TCPRIOGREEN'>
END
  	for ( $c = 1 ; $c <= 7 ; $c++ )
  	{
		if ( $qossettings{'TCPRIOGREEN'} ne $c )
		{
  			print "<option value='$c'>$c</option>";
		}
		else
		{
  			print "<option selected value='$c'>$c</option>";			
		}
  	}
  	print <<END;
  	</select></td>
  	<td width='50%' align='left'>&nbsp;</td>
  </tr>
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
END
		if ( $qossettings{'TCMINGREEN'} eq '' )
		{
			$qossettings{'TCMINGREEN'} = "1";
		}
		print <<END;
  	<td width='20%' align='left'><input type='text' name='TCMINGREEN' value="$qossettings{'TCMINGREEN'}" err="please enter a valid speed!" required="1" /></td>
  	<td width='50%' align='left'>&nbsp;</td>
  </tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEGREEN' value="$qossettings{'TCMAXRATEGREEN'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTGREEN' value="$qossettings{'BURSTGREEN'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTGREEN' value="$qossettings{'CBURSTGREEN'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
	<td width='30%' align='left'>&nbsp;</td>
	<td width='20%' align='left'>&nbsp;</td>
  	<td width='50%' align='left'>
  		<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  		<input type='hidden' name='ROOTHANDLEGREEN' value='3' />
  		<input type='hidden' name='TCPARENTGREEN' value='3' />
  		<input type='hidden' name='INTERFACE' value='$netsettings{'GREEN_DEV'}' />
  		<input type='hidden' name='TCPROTOGREEN' value='htb' />
  		<input type='hidden' name='TCSAVE' value='CLASS' />
END
		if ( $qossettings{'EDITCLASS'} ne '' )
		{
			print "<input type='hidden' name='TCCLASSGREEN' value=$qossettings{'TCPARENTCLASS'} />";
		}
		print <<END;
  	</td>
  </tr>
  </table>
END
  }
  print "</form>\n";
  &Header::closebox();
}
  $qossettings{'TCDEFAULT'}="";
  $qossettings{'TCRATE'}="";

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 500 && $qossettings{'TCPARENTCLASS'} <= 599 )
{ 
  if ( $netsettings{'BLUE_DEV'} ne '' )
  {
	if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITCLASS'} ne 'YES' )
	{
		&Header::openbox( '100%', 'left', "<font color='#0000ff'>$Lang::tr{'qos add classes'} $netsettings{'BLUE_DEV'}</font>" );
	}
	else
	{
		&Header::openbox( '100%', 'left', "<font color='#0000ff'>$Lang::tr{'qos edit classes'} $qossettings{'TCPARENTCLASS'}</font>" );
	}
  	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  	$rulefile = "/var/ipcop/qos/settings/tc/settings";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	$RCEXIST = "";
  	foreach $tmpline (sort @tmp)
  	{
  		@tcsettings = split( /\;/, $tmpline );
  		if ( $tcsettings[0] eq $netsettings{'BLUE_DEV'} )
  		{
  			$RCEXIST                   = "YES";
  			$qossettings{'ROOTHANDLEBLUE'} = $tcsettings[1];
  			$qossettings{'INTERFACE'}  = $tcsettings[0];
  			$qossettings{'TCPROTOBLUE'}    = $tcsettings[2];
  			$qossettings{'TCDEFAULTBLUE'}  = $tcsettings[3];
  			$qossettings{'TCRATEBLUE'}     = $tcsettings[4];
  		}
  	}
  	if ( $RCEXIST ne "YES"  || $qossettings{'EDIT'} eq "YES" )
  	{
  		print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
  	<tr>
  		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
  		<td width='20%' align='left'> $netsettings{'BLUE_DEV'}</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>			
  	</tr>	
  	<tr>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>	
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>			
  	</tr>	
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos default class'}:</td>
  		<td width='20%' align='left'><select name='TCDEFAULTBLUE'>
END
  		for ( $c = 500 ; $c <= 599 ; $c++ )
  		{
			if ( $qossettings{'TCDEFAULTBLUE'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
  		}
  		print <<END;
  		</select></td>
  		<td width='50%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos speed in kbit'}:</td>
  		<td width='20%' align='left'><input type='text' name='TCRATEBLUE' value="$qossettings{'TCRATEBLUE'}"  err="please select a valid speed!" required="1"/></td>
  		<td width='50%' align='left'>( $Lang::tr{'qos max dl speed'} )</td>
  	</tr>
  	<tr>
  		<td width='30%' align='center'>&nbsp;</td>
  		<td width='20%' align='center'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEBLUE' value='5' />
  			<input type='hidden' name='INTERFACE' value='$netsettings{'BLUE_DEV'}' />
  			<input type='hidden' name='TCPROTOBLUE' value='htb' />
  			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
  		</td>
  	</tr>
  	</table>
END
  	}
  	else
  	{
		if ( $qossettings{'TODO'} eq $Lang::tr{'qos add rootclass'} )
		{
			print "<div align='center'><b>Rootclass already exists, use edit/delete button on mainpage to edit or delete this rootclass !</b></div>";
		}
	}
  	if ( $RCEXIST eq "YES" && $qossettings{'TODO'} ne $Lang::tr{'qos add rootclass'} )
  	{
  		print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
END
	if ( $qossettings{'EDITCLASS'} ne 'YES' )
	{
	print <<END;
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos class'}:</td>
  		<td width='20%' align='left'><select name='TCCLASSBLUE'>
END
  		$rulefile = "/var/ipcop/qos/settings/tc/classes";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		for ( $c = 500 ; $c <= 599 ; $c++ )
  		{
  			$EXISTS = "no";
  			foreach $ruleentry (sort @tmp)
  			{
  				@tmpline = split( /\;/, $ruleentry );
  				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
  			}
  			if ( $EXISTS ne "yes" )
  			{
				if ( $qossettings{'TCPARENTCLASS'} ne $c )
				{
  					print "<option value='$c'>$c</option>";
				}
				else
				{
  					print "<option selected value='$c'>$c</option>";			
				}
  			}
  		}
  		print <<END;
    	</select></td>
END
  		$rulefile = "/var/ipcop/qos/settings/tc/settings";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[0] eq $netsettings{'BLUE_DEV'} )
  			{
  				print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  			}
  		}
  		print <<END;
  	</tr>
END
	}
	print <<END;
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  		<td width='20%' align='left'><select name='TCPRIOBLUE'>
END
  		for ( $c = 1 ; $c <= 7 ; $c++ )
  		{
			if ( $qossettings{'TCPRIOBLUE'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
  		}
  		print <<END;
  		</select></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
END
		if ( $qossettings{'TCMINBLUE'} eq '' )
		{
			$qossettings{'TCMINBLUE'} = "1";
		}
		print <<END;
  		<td width='20%' align='left'><input type='text' name='TCMINBLUE' value="$qossettings{'TCMINBLUE'}" err="please select a valid speed!" required="1" /></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEBLUE' value="$qossettings{'TCMAXRATEBLUE'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTBLUE' value="$qossettings{'BURSTBLUE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTBLUE' value="$qossettings{'CBURSTBLUE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
	<td width='30%' align='left'>&nbsp;</td>
	<td width='20%' align='left'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEBLUE' value='5' />
  			<input type='hidden' name='TCPARENTBLUE' value='5' />
  			<input type='hidden' name='INTERFACE' value='$netsettings{'BLUE_DEV'}' />
  			<input type='hidden' name='TCPROTOBLUE' value='htb' />
  			<input type='hidden' name='TCSAVE' value='CLASS' />
END
			if ( $qossettings{'EDITCLASS'} ne '' )
			{
				print "<input type='hidden' name='TCCLASSBLUE' value=$qossettings{'TCPARENTCLASS'} />";
			}
			print <<END;
  		</td>
  	</tr>
  	</table>
END
  	}
  	print "</form>\n";
  	&Header::closebox();
  }
}
  $qossettings{'TCDEFAULT'}="";
  $qossettings{'TCRATE'}="";

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 400 && $qossettings{'TCPARENTCLASS'} <= 499 )
{  
  if ( $netsettings{'ORANGE_DEV'} ne '' )
  {
	if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITCLASS'} ne 'YES' )
	{
		&Header::openbox( '100%', 'left', "<font color='#ff8040'>$Lang::tr{'qos add classes'} $netsettings{'ORANGE_DEV'}</font>" );
	}
	else
	{
		&Header::openbox( '100%', 'left', "<font color='#ff8040'>$Lang::tr{'qos edit classes'} $qossettings{'TCPARENTCLASS'}</font>" );
	}
  	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  	$rulefile = "/var/ipcop/qos/settings/tc/settings";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	$RCEXIST = "";
  	foreach $tmpline (sort @tmp)
  	{
  		@tcsettings = split( /\;/, $tmpline );
  		if ( $tcsettings[0] eq $netsettings{'ORANGE_DEV'} )
  		{
  			$RCEXIST                   = "YES";
  			$qossettings{'ROOTHANDLEORANGE'} = $tcsettings[1];
  			$qossettings{'INTERFACE'}  = $tcsettings[0];
  			$qossettings{'TCPROTOORANGE'}    = $tcsettings[2];
  			$qossettings{'TCDEFAULTORANGE'}  = $tcsettings[3];
  			$qossettings{'TCRATEORANGE'}     = $tcsettings[4];
  		}
  	}
  	if ( $RCEXIST ne "YES"  || $qossettings{'EDIT'} eq "YES" )
  	{
  		print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
  	<tr>
  		<td width='20%' align='right'>$Lang::tr{'qos create rootclass'}</td>
  		<td width='20%' align='left'> $netsettings{'ORANGE_DEV'}</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>			
  	</tr>	
  	<tr>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>	
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>
  		<td width='20%' align='right'>&nbsp;</td>			
  	</tr>	
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos default class'}:</td>
  		<td width='20%' align='left'><select name='TCDEFAULTORANGE'>
END
 		for ( $c = 400 ; $c <= 499 ; $c++ )
  		{
			if ( $qossettings{'TCDEFAULTORANGE'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
  		}
  		print <<END;
  		</select></td>
  		<td width='50%' align='left'>( $Lang::tr{'qos class no rule matches'} )</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos speed in kbit'}:</td>
  		<td width='20%' align='left'><input type='text' name='TCRATEORANGE' value="$qossettings{'TCRATEORANGE'}" err="please select a valid speed!" required="1" /></td>
  		<td width='50%' align='left'>( $Lang::tr{'qos max dl speed'} )</td>
  	</tr>
  	<tr>
  		<td width='30%' align='center'>&nbsp;</td>
  		<td width='20%' align='center'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEORANGE' value='4' />
  			<input type='hidden' name='INTERFACE' value='$netsettings{'ORANGE_DEV'}' />
  			<input type='hidden' name='TCPROTOORANGE' value='htb' />
  			<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
  		</td>
  	</tr>
  	</table>
END
  	}
  	else
  	{
		if ( $qossettings{'TODO'} eq $Lang::tr{'qos add rootclass'} )
		{
			print "<div align='center'><b>Rootclass already exists, use edit/delete button on mainpage to edit or delete this rootclass !</b></div>";
		}
  	}
  	if ( $RCEXIST eq "YES" && $qossettings{'TODO'} ne $Lang::tr{'qos add rootclass'} )
  	{
  		print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
END
	if ( $qossettings{'EDITCLASS'} ne 'YES' )
	{
	print <<END;
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos class'}:</td>
  		<td width='20%' align='left'><select name='TCCLASSORANGE'>
END
  		$rulefile = "/var/ipcop/qos/settings/tc/classes";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		for ( $c = 400 ; $c <= 499 ; $c++ )
  		{
  			$EXISTS = "no";
  			foreach $ruleentry (sort @tmp)
  			{
  				@tmpline = split( /\;/, $ruleentry );
  				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
  			}
  			if ( $EXISTS ne "yes" )
  			{
				if ( $qossettings{'TCPARENTCLASS'} ne $c )
				{
  					print "<option value='$c'>$c</option>";
				}
				else
				{
  					print "<option selected value='$c'>$c</option>";			
				}
  			}
  		}
  		print <<END;
    	</select></td>
END
  		$rulefile = "/var/ipcop/qos/settings/tc/settings";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[0] eq $netsettings{'ORANGE_DEV'} )
  			{
  				print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  			}
  		}
  		print <<END;
  	</tr>
END
	}
	print<<END;
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  		<td width='20%' align='left'><select name='TCPRIOORANGE'>
END
  		for ( $c = 1 ; $c <= 7 ; $c++ )
  		{
			if ( $qossettings{'TCPRIOBLUE'} ne $c )
			{
  				print "<option value='$c'>$c</option>";
			}
			else
			{
  				print "<option selected value='$c'>$c</option>";			
			}
  		}
  		print <<END;
  		</select></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
END
		if ( $qossettings{'TCMINORANGE'} eq '' )
		{
			$qossettings{'TCMINORANGE'} = "1";
		}
		print <<END;
  		<td width='20%' align='left'><input type='text' name='TCMINORANGE' value="$qossettings{'TCMINORANGE'}" err="please select a valid speed!" required="1" /></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEORANGE' value="$qossettings{'TCMAXRATEORANGE'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTORANGE' value="$qossettings{'BURSTORANGE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTORANGE' value="$qossettings{'CBURSTORANGE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
	<td width='30%' align='left'>&nbsp;</td>
	<td width='20%' align='left'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEORANGE' value='4' />
  			<input type='hidden' name='TCPARENTORANGE' value='4' />
  			<input type='hidden' name='INTERFACE' value='$netsettings{'ORANGE_DEV'}' />
  			<input type='hidden' name='TCPROTOORANGE' value='htb' />
  			<input type='hidden' name='TCSAVE' value='CLASS' />
END
			if ( $qossettings{'EDITCLASS'} ne '' )
			{
				print "<input type='hidden' name='TCCLASSORANGE' value=$qossettings{'TCPARENTCLASS'} />";
			}
			print <<END;
  		</td>
  	</tr>
  	</table>
END
  	}
  	print "</form>\n";
  	&Header::closebox();
  }
}

  	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
  	&Header::closebigbox();
  	print <<END;
  <div align='right'>
  <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
  <input type="hidden" name="cmd" value="_s-xclick">
  <input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
  <input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
  </form>
  </div>
END
  print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'TODO'} = "";
	exit 0;
}


######################
#
# added for subclasses
#
# use $((${PARENTCLASS}*${SUBCLASS}*1000/28352)) for mark
#
if ( $qossettings{'TODO'} eq "create subclass" )
{
	print "<a name='addsubclasses'>";
if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 100 && $qossettings{'TCPARENTCLASS'} <= 199 )
{ 
	if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITSUBCLASS'} ne 'YES' )
 	{
		&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos add subclasses'} $REDDEVICE</font>" );
 	}
	else
	{
		&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos edit classes'} $qossettings{'TCSUBCLASSRED'}</font>" );
 	}
	print <<END;
	<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
		<table CELLSPACING='0' cellpadding='0' width='100%'>
  		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos parentclass'}:</td>
			<td width='20%' align='left'><select name='TCPARENTCLASSRED'>
END
		if ( $qossettings{'TCPARENTCLASSRED'} ne '' )
		{
		print "<option value=$qossettings{'TCPARENTCLASSRED'} $selected{'TCPARENTCLASSRED'}{$qossettings{'TCPARENTLASSRED'}}>$qossettings{'TCPARENTCLASSRED'}</option>";
		}
		print "<option value=$qossettings{'TCSUBCLASSRED'} $selected{'TCPARENTCLASSRED'}{$qossettings{'TCPARENTCLASSRED'}}>$qossettings{'TCPARENTCLASSRED'}</option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 100 ; $c <= 199 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS eq "yes" )
			{
				print "<option value='$c' $selected{'TCPARENTCLASSRED'}{'$c'}>$c</option>";
			}
		}
		print <<END;
			</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq "$REDDEVICE" )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
		</tr>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos subclass'}:</td>
			<td width='20%' align='left'><select name='TCSUBCLASSRED'>
END
		if ( $qossettings{'TCSUBCLASSRED'} ne '' )
		{
			print "<option value=$qossettings{'TCSUBCLASSRED'} $selected{'TCSUBCLASSRED'}{$qossettings{'TCSUBCLASSRED'}}>$qossettings{'TCSUBCLASSRED'}</option>";
		}
		print "<option value=$qossettings{'TCSUBCLASSRED'} $selected{'TCSUBCLASSRED'}{$qossettings{'TCSUBCLASSRED'}}>$qossettings{'TCSUBCLASSRED'}</option>";
		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 1000 ; $c <= 1999 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[2] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS ne "yes" )
			{
				print "<option value='$c' $selected{'TCSUBCLASSRED'}{'$c'}>$c</option>";
			}
		}
		print <<END;
			</select></td>
		</tr>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'priority'}:</td>
			<td width='20%' align='left'><select name='TCPRIORED'>
END
		if ( $qossettings{'TCPRIORED'} ne '' )
		{
			print "<option value=$qossettings{'TCPRIORED'} $selected{'TCPRIORED'}{$qossettings{'TCPRIORED'}}>$qossettings{'TCPRIORED'}</option>";
		}
		for ( $c = 1 ; $c <= 7 ; $c++ )
		{
			print "<option value='$c' $selected{'TCPRIORED'}{'$c'}>$c</option>";
		}
		print <<END;
			</select></td>
			<td width='60%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos minimum upload'}:</td>
END
		if ( $qossettings{'TCMINRED'} eq '' )
		{
			$qossettings{'TCMINRED'} = "1";
		}
		print <<END;
			<td width='20%' align='left'><input type='text' name='TCMINRED' value="$qossettings{'TCMINRED'}" err="please enter a valid upload speed!" required="1" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos max ul rate'}:</td>
			<td width='20%' align='left'><input type='text' name='TCMAXRATERED' value="$qossettings{'TCMAXRATERED'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
			<td width='20%' align='left'><input type='text' name='BURSTRED' value="$qossettings{'BURSTRED'}" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
			<td width='20%' align='left'><input type='text' name='CBURSTRED' value="$qossettings{'CBURSTRED'}" /></td>
			<td width='50%' align='left'>&nbsp;</td>
		</tr>
		<tr>
			<td width='30%' align='left'>&nbsp;</td>
			<td width='20%' align='left'>&nbsp;</td>
			<td width='50%' align='left'>
				<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
				<input type='hidden' name='ROOTHANDLERED' value='1' />
				<input type='hidden' name='TCPARENTRED' value='1' />
				<input type='hidden' name='INTERFACE' value='$REDDEVICE' />
				<input type='hidden' name='TCPROTORED' value='htb' />
				<input type='hidden' name='TCSAVE' value='SUBCLASS' />
			</td>
		</tr>
		</table>
END
	print "</form>\n";
	&Header::closebox();
}

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 200 && $qossettings{'TCPARENTCLASS'} <= 299 )
{ 
  if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITSUBCLASS'} ne 'YES' )
  {
	&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos add subclasses'} imq0</font>" );
  }
  else
  {
	&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos edit classes'} $qossettings{'TCSUBCLASSIMQ'}</font>" );
  }
  print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  	print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos parentclass'}:</td>
			<td width='20%' align='left'><select name='TCPARENTCLASSIMQ'>
END
		if ( $qossettings{'TCPARENTCLASSIMQ'} ne '' )
		{
			print "<option value=$qossettings{'TCPARENTCLASSIMQ'} $selected{'TCPARENTCLASSIMQ'}{$qossettings{'TCPARENTLASSIMQ'}}>$qossettings{'TCPARENTCLASSIMQ'}</option>";
		}
		print "<option value=$qossettings{'TCSUBCLASSIMQ'} $selected{'TCPARENTCLASSIMQ'}{$qossettings{'TCPARENTCLASSIMQ'}}>$qossettings{'TCPARENTCLASSIMQ'}</option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 200 ; $c <= 299 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS eq "yes" )
			{
				print "<option value='$c' $selected{'TCPARENTCLASSIMQ'}{'$c'}>$c</option>";
			}
		}
		print <<END;
			</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq "imq0" )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
		</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos subclass'}:</td>
  		<td width='20%' align='left'><select name='TCSUBCLASSIMQ'>
END
	if ( $qossettings{'TCSUBCLASSIMQ'} ne '' )
	{
  		print "<option value=$qossettings{'TCSUBCLASSIMQ'} $selected{'TCSUBCLASSIMQ'}{$qossettings{'TCSUBCLASSIMQ'}}>$qossettings{'TCSUBCLASSIMQ'}</option>";
	}
  	$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	for ( $c = 2000 ; $c <= 2999 ; $c++ )
  	{
  		$EXISTS = "no";
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[2] eq $c ) { $EXISTS = "yes"; }
  		}
  		if ( $EXISTS ne "yes" )
  		{
  			print "<option value='$c' $selected{'TCSUBCLASSIMQ'}{'$c'}>$c</option>";
  		}
  	}
  	print <<END;
    	</select></td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  		<td width='20%' align='left'><select name='TCPRIOIMQ'>
END
	if ( $qossettings{'TCPRIOIMQ'} ne '' )
	{
  		print "<option value=$qossettings{'TCPRIOIMQ'} $selected{'TCPRIOIMQ'}{$qossettings{'TCPRIOIMQ'}}>$qossettings{'TCPRIOIMQ'}</option>";
	}
  	for ( $c = 1 ; $c <= 7 ; $c++ )
  	{
  		print "<option value='$c' $selected{'TCPRIOIMQ'}{'$c'}>$c</option>";
  	}
  	print <<END;
  		</select></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos minimum download'}:</td>
END
		if ( $qossettings{'TCMINIMQ'} eq '' )
		{
			$qossettings{'TCMINIMQ'} = "1";
		}
		print <<END;
  		<td width='20%' align='left'><input type='text' name='TCMINIMQ' value="$qossettings{'TCMINIMQ'}" err="please enter a valid download speed!" required="1" /></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max dl rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEIMQ' value="$qossettings{'TCMAXRATEIMQ'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTIMQ' value="$qossettings{'BURSTIMQ'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTIMQ' value="$qossettings{'CBURSTIMQ'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='left'>&nbsp;</td>
		<td width='20%' align='left'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEIMQ' value='2' />
  			<input type='hidden' name='TCPARENTIMQ' value='2' />
  			<input type='hidden' name='INTERFACE' value='imq0' />
  			<input type='hidden' name='TCPROTOIMQ' value='htb' />
  			<input type='hidden' name='TCSAVE' value='SUBCLASS' />
  		</td>
  	</tr>
  	</table>
END
  print "</form>\n";
  &Header::closebox();
}

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 300 && $qossettings{'TCPARENTCLASS'} <= 399 )
{ 
  if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITSUBCLASS'} ne 'YES' )
  {
	&Header::openbox( '100%', 'left', "<font color='#00ff00'>$Lang::tr{'qos add subclasses'} $netsettings{'GREEN_DEV'}</font>" );
  }
  else
  {
 	&Header::openbox( '100%', 'left', "<font color='#00ff00'>$Lang::tr{'qos edit classes'} $qossettings{'TCSUBCLASSGREEN'}</font>" );
  }
  print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  	print <<END;
  <table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos parentclass'}:</td>
			<td width='20%' align='left'><select name='TCPARENTCLASSGREEN'>
END
		if ( $qossettings{'TCPARENTCLASSGREEN'} ne '' )
		{
			print "<option value=$qossettings{'TCPARENTCLASSGREEN'} $selected{'TCPARENTCLASSGREEN'}{$qossettings{'TCPARENTLASSGREEN'}}>$qossettings{'TCPARENTCLASSGREEN'}</option>";
		}
		print "<option value=$qossettings{'TCSUBCLASSGREEN'} $selected{'TCPARENTCLASSGREEN'}{$qossettings{'TCPARENTCLASSGREEN'}}>$qossettings{'TCPARENTCLASSGREEN'}</option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 300 ; $c <= 399 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS eq "yes" )
			{
				print "<option value='$c' $selected{'TCPARENTCLASSGREEN'}{'$c'}>$c</option>";
			}
		}
		print <<END;
			</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq "GREEN0" )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
		</tr>
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'qos subclass'}:</td>
  	<td width='20%' align='left'><select name='TCSUBCLASSGREEN'>
END
	if ( $qossettings{'TCSUBCLASSGREEN'} ne '' )
	{
  		print "<option value=$qossettings{'TCSUBCLASSGREEN'} $selected{'TCSUBCLASSGREEN'}{$qossettings{'TCSUBCLASSGREEN'}}>$qossettings{'TCSUBCLASSGREEN'}</option>";
	}
  	$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	for ( $c = 3000 ; $c <= 3999 ; $c++ )
  	{
  		$EXISTS = "no";
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[2] eq $c ) { $EXISTS = "yes"; }
  		}
  		if ( $EXISTS ne "yes" )
  		{
  			print  "<option value='$c' $selected{'TCSUBCLASSGREEN'}{'$c'}>$c</option>";
  		}
  	}
  	print <<END;
  	</select></td>
END
  	$rulefile = "/var/ipcop/qos/settings/tc/settings";
  	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  	@tmp = <FILE>;
  	close FILE;
  	foreach $ruleentry (sort @tmp)
  	{
  		@tmpline = split( /\;/, $ruleentry );
  		if ( $tmpline[0] eq $netsettings{'GREEN_DEV'} )
  		{
  			print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  		}
  	}
  	print <<END;
  </tr>
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  	<td width='20%' align='left'><select name='TCPRIOGREEN'>
END
	if ( $qossettings{'TCPRIOGREEN'} ne '' )
	{
  		print "<option value=$qossettings{'TCPRIOGREEN'} $selected{'TCPRIOGREEN'}{$qossettings{'TCPRIOGREEN'}}>$qossettings{'TCPRIOGREEN'}</option>";
	}
  	for ( $c = 1 ; $c <= 7 ; $c++ )
  	{
  		print "<option value='$c' $selected{'TCPRIOGREEN'}{'$c'}>$c</option>";
  	}
  	print <<END;
  	</select></td>
  	<td width='50%' align='left'>&nbsp;</td>
  </tr>
  <tr>
  	<td width='30%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
END
		if ( $qossettings{'TCMINGREEN'} eq '' )
		{
			$qossettings{'TCMINGREEN'} = "1";
		}
		print <<END;
  	<td width='20%' align='left'><input type='text' name='TCMINGREEN' value="$qossettings{'TCMINGREEN'}" err="please enter a valid speed!" required="1" /></td>
  	<td width='50%' align='left'>&nbsp;</td>
  </tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEGREEN' value="$qossettings{'TCMAXRATEGREEN'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTGREEN' value="$qossettings{'BURSTGREEN'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTGREEN' value="$qossettings{'CBURSTGREEN'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
	<td width='30%' align='left'>&nbsp;</td>
	<td width='20%' align='left'>&nbsp;</td>
  	<td width='50%' align='left'>
  		<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  		<input type='hidden' name='ROOTHANDLEGREEN' value='3' />
  		<input type='hidden' name='TCPARENTGREEN' value='3' />
  		<input type='hidden' name='INTERFACE' value='$netsettings{'GREEN_DEV'}' />
  		<input type='hidden' name='TCPROTOGREEN' value='htb' />
  		<input type='hidden' name='TCSAVE' value='SUBCLASS' />
  	</td>
  </tr>
  </table>
END
  print "</form>\n";
  &Header::closebox();
}

  $qossettings{'TCDEFAULT'}="";
  $qossettings{'TCRATE'}="";

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 500 && $qossettings{'TCPARENTCLASS'} <= 599 )
{
  if ( $netsettings{'BLUE_DEV'} ne '' )
  {
  if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITSUBCLASS'} ne 'YES' )
  {
	&Header::openbox( '100%', 'left', "<font color='#0000ff'>$Lang::tr{'qos add subclasses'} $netsettings{'BLUE_DEV'}</font>" );
  }
  else
  {
 	&Header::openbox( '100%', 'left', "<font color='#0000ff'>$Lang::tr{'qos edit classes'} $qossettings{'TCSUBCLASSBLUE'}</font>" );
  }
  	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  		print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos parentclass'}:</td>
			<td width='20%' align='left'><select name='TCPARENTCLASSBLUE'>
END
		if ( $qossettings{'TCPARENTCLASSBLUE'} ne '' )
		{
			print "<option value=$qossettings{'TCPARENTCLASSBLUE'} $selected{'TCPARENTCLASSBLUE'}{$qossettings{'TCPARENTLASSBLUE'}}>$qossettings{'TCPARENTCLASSBLUE'}</option>";
		}
		print "<option value=$qossettings{'TCSUBCLASSBLUE'} $selected{'TCPARENTCLASSBLUE'}{$qossettings{'TCPARENTCLASSBLUE'}}>$qossettings{'TCPARENTCLASSBLUE'}</option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 500 ; $c <= 599 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS eq "yes" )
			{
				print "<option value='$c' $selected{'TCPARENTCLASSBLUE'}{'$c'}>$c</option>";
			}
		}
		print <<END;
			</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq "BLUE0" )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
		</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos subclass'}:</td>
  		<td width='20%' align='left'><select name='TCSUBCLASSBLUE'>
END
		if ( $qossettings{'TCSUBCLASSBLUE'} ne '' )
		{
  			print "<option value=$qossettings{'TCSUBCLASSBLUE'} $selected{'TCSUBCLASSBLUE'}{$qossettings{'TCSUBCLASSBLUE'}}>$qossettings{'TCSUBCLASSBLUE'}</option>";
		}
  		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		for ( $c = 5000 ; $c <= 5999 ; $c++ )
  		{
  			$EXISTS = "no";
  			foreach $ruleentry (sort @tmp)
  			{
  				@tmpline = split( /\;/, $ruleentry );
  				if ( $tmpline[2] eq $c ) { $EXISTS = "yes"; }
  			}
  			if ( $EXISTS ne "yes" )
  			{
  				print
  				  "<option value='$c' $selected{'TCSUBCLASSBLUE'}{'$c'}>$c</option>";
  			}
  		}
  		print <<END;
    	</select></td>
END
  		$rulefile = "/var/ipcop/qos/settings/tc/settings";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[0] eq $netsettings{'BLUE_DEV'} )
  			{
  				print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  			}
  		}
  		print <<END;
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  		<td width='20%' align='left'><select name='TCPRIOBLUE'>
END
		if ( $qossettings{'TCPRIOBLUE'} ne '' )
		{
  			print "<option value=$qossettings{'TCPRIOBLUE'} $selected{'TCPRIOBLUE'}{$qossettings{'TCPRIOBLUE'}}>$qossettings{'TCPRIOBLUE'}</option>";
		}
  		for ( $c = 1 ; $c <= 7 ; $c++ )
  		{
  			print "<option value='$c' $selected{'TCPRIOBLUE'}{'$c'}>$c</option>";
  		}
  		print <<END;
  		</select></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
END
		if ( $qossettings{'TCMINBLUE'} eq '' )
		{
			$qossettings{'TCMINBLUE'} = "1";
		}
		print <<END;
  		<td width='20%' align='left'><input type='text' name='TCMINBLUE' value="$qossettings{'TCMINBLUE'}" err="please select a valid speed!" required="1" /></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEBLUE' value="$qossettings{'TCMAXRATEBLUE'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTBLUE' value="$qossettings{'BURSTBLUE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTBLUE' value="$qossettings{'CBURSTBLUE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
	<td width='30%' align='left'>&nbsp;</td>
	<td width='20%' align='left'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEBLUE' value='5' />
  			<input type='hidden' name='TCPARENTBLUE' value='5' />
  			<input type='hidden' name='INTERFACE' value='$netsettings{'BLUE_DEV'}' />
  			<input type='hidden' name='TCPROTOBLUE' value='htb' />
  			<input type='hidden' name='TCSAVE' value='SUBCLASS' />
  		</td>
  	</tr>
  	</table>
END
  	print "</form>\n";
  	&Header::closebox();
  }
}  
  $qossettings{'TCDEFAULT'}="";
  $qossettings{'TCRATE'}="";

if ( $qossettings{'TCPARENTCLASS'} eq '' || $qossettings{'TCPARENTCLASS'} >= 400 && $qossettings{'TCPARENTCLASS'} <= 499 )
{  
  if ( $netsettings{'ORANGE_DEV'} ne '' )
  {
  if ( $qossettings{'EDIT'} ne 'YES' && $qossettings{'EDITSUBCLASS'} ne 'YES' )
  {
	&Header::openbox( '100%', 'left', "<font color='#ff8040'>$Lang::tr{'qos add subclasses'} $netsettings{'ORANGE_DEV'}</font>" );
  }
  else
  {
 	&Header::openbox( '100%', 'left', "<font color='#ff8040'>$Lang::tr{'qos edit classes'} $qossettings{'TCSUBCLASSORANGE'}</font>" );
  }
  	print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
  		print <<END;
  	<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos parentclass'}:</td>
			<td width='20%' align='left'><select name='TCPARENTCLASSORANGE'>
END
		if ( $qossettings{'TCPARENTCLASSORANGE'} ne '' )
		{
			print "<option value=$qossettings{'TCPARENTCLASSORANGE'} $selected{'TCPARENTCLASSORANGE'}{$qossettings{'TCPARENTLASSORANGE'}}>$qossettings{'TCPARENTCLASSORANGE'}</option>";
		}
		print "<option value=$qossettings{'TCSUBCLASSORANGE'} $selected{'TCPARENTCLASSORANGE'}{$qossettings{'TCPARENTCLASSORANGE'}}>$qossettings{'TCPARENTCLASSORANGE'}</option>";
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		for ( $c = 400 ; $c <= 499 ; $c++ )
		{
			$EXISTS = "no";
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				if ( $tmpline[1] eq $c ) { $EXISTS = "yes"; }
			}
			if ( $EXISTS eq "yes" )
			{
				print "<option value='$c' $selected{'TCPARENTCLASSORANGE'}{'$c'}>$c</option>";
			}
		}
		print <<END;
			</select></td>
END
		$rulefile = "/var/ipcop/qos/settings/tc/settings";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[0] eq "ORANGE0" )
			{
				print "<td width='60%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
			}
		}
		print <<END;
		</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos subclass'}:</td>
  		<td width='20%' align='left'><select name='TCSUBCLASSORANGE'>
END
		if ( $qossettings{'TCSUBCLASSORANGE'} ne '' )
		{
  			print "<option value=$qossettings{'TCSUBCLASSORANGE'} $selected{'TCSUBCLASSORANGE'}{$qossettings{'TCSUBCLASSORANGE'}}>$qossettings{'TCSUBCLASSORANGE'}</option>";
		}
  		$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		for ( $c = 4000 ; $c <= 4999 ; $c++ )
  		{
  			$EXISTS = "no";
  			foreach $ruleentry (sort @tmp)
  			{
  				@tmpline = split( /\;/, $ruleentry );
  				if ( $tmpline[2] eq $c ) { $EXISTS = "yes"; }
  			}
  			if ( $EXISTS ne "yes" )
  			{
  				print
  				  "<option value='$c' $selected{'TCSUBCLASSORANGE'}{'$c'}>$c</option>";
  			}
  		}
  		print <<END;
    	</select></td>
END
  		$rulefile = "/var/ipcop/qos/settings/tc/settings";
  		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
  		@tmp = <FILE>;
  		close FILE;
  		foreach $ruleentry (sort @tmp)
  		{
  			@tmpline = split( /\;/, $ruleentry );
  			if ( $tmpline[0] eq $netsettings{'ORANGE_DEV'} )
  			{
  				print "<td width='50%' align='left'>( $Lang::tr{'qos default class'}: $tmpline[3] )</td>";
  			}
  		}
  		print <<END;
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'priority'}:</td>
  		<td width='20%' align='left'><select name='TCPRIOORANGE'>
END
		if ( $qossettings{'TCPRIOORANGE'} ne '' )
		{
  		print "<option value=$qossettings{'TCPRIOORANGE'} $selected{'TCPRIOORANGE'}{$qossettings{'TCPRIOORANGE'}}>$qossettings{'TCPRIOORANGE'}</option>";
		}
  		for ( $c = 1 ; $c <= 7 ; $c++ )
  		{
  			print "<option value='$c' $selected{'TCPRIOORANGE'}{'$c'}>$c</option>";
  		}
  		print <<END;
  		</select></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
  	<tr>
  		<td width='30%' align='right'>$Lang::tr{'qos min speed in kbit'}:</td>
END
		if ( $qossettings{'TCMINORANGE'} eq '' )
		{
			$qossettings{'TCMINORANGE'} = "1";
		}
		print <<END;
  		<td width='20%' align='left'><input type='text' name='TCMINORANGE' value="$qossettings{'TCMINORANGE'}" err="please select a valid speed!" required="1" /></td>
  		<td width='50%' align='left'>&nbsp;</td>
  	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos max rate'}:</td>
		<td width='20%' align='left'><input type='text' name='TCMAXRATEORANGE' value="$qossettings{'TCMAXRATEORANGE'}" err="please enter a valid maximum bandwidth !" required="1" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos burst'}:</td>
		<td width='20%' align='left'><input type='text' name='BURSTORANGE' value="$qossettings{'BURSTORANGE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
		<td width='30%' align='right'>$Lang::tr{'qos cburst'}:</td>
		<td width='20%' align='left'><input type='text' name='CBURSTORANGE' value="$qossettings{'CBURSTORANGE'}" /></td>
		<td width='50%' align='left'>&nbsp;</td>
	</tr>
	<tr>
	<td width='30%' align='left'>&nbsp;</td>
	<td width='20%' align='left'>&nbsp;</td>
  		<td width='50%' align='left'>
  			<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
  			<input type='hidden' name='ROOTHANDLEORANGE' value='4' />
  			<input type='hidden' name='TCPARENTORANGE' value='4' />
  			<input type='hidden' name='INTERFACE' value='$netsettings{'ORANGE_DEV'}' />
  			<input type='hidden' name='TCPROTOORANGE' value='htb' />
  			<input type='hidden' name='TCSAVE' value='SUBCLASS' />
  		</td>
  	</tr>
  	</table>
END
  	print "</form>\n";
  	&Header::closebox();
  }
}
  	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
  	&Header::closebigbox();
  	print <<END;
  <div align='right'>
  <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
  <input type="hidden" name="cmd" value="_s-xclick">
  <input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
  <input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
  </form>
  </div>
END
  print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'TODO'} = "";
	exit 0;
}
#
# end subclasses
#
######################


if ( $ready ne "" )
{
	if ( $qossettings{'TODO'} eq "set ack priority" )
	{
		print "<a name='select ack'>";
		$rulefile = "/var/ipcop/qos/settings/tc/ack";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		my $ACTACK=$tmp[0];
		&Header::openbox( '100%', 'left', "<font color='#ff0000'>$Lang::tr{'qos selectack'}$REDDEVICE</font>" );
		print <<END;
		<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
		<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='20%' align='right'>$Lang::tr{'qos class'}:</td>
			<td width='20%' align='left'><select name='TCPRIOACK'>
END
		if ( $qossettings{'TCPRIOACK'} ne '' )
		{ 
			print "<option value=$ACTACK $selected{'TCPRIOACK'}{$qossettings{'TCPRIOACK'}}>$ACTACK</option>";
		}
		$rulefile = "/var/ipcop/qos/settings/tc/classes";
		open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
		@tmp = <FILE>;
		close FILE;
		foreach $ruleentry (sort @tmp)
		{
			@tmpline = split( /\;/, $ruleentry );
			if ( $tmpline[1] ge 100 && $tmpline[1] le 199 )
			{
				print "<option value='$tmpline[1]' $selected{'TCPRIOACK'}{'$tmpline[1]'}>$tmpline[1]</option>";
			}
		}
		print <<END;
			</select></td>
			<td width='25%' align='center'>($Lang::tr{'qos ackpriority'}: $ACTACK)</td>
			<td width='35%' align='center'><input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
			<input type='hidden' name='ACK' value='YES' />
			</td>
		</tr>
	</table>
	</form>
END
	&Header::closebox();
  	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
  	&Header::closebigbox();
  	print <<END;
  	<div align='right'>
  	<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
  	<input type="hidden" name="cmd" value="_s-xclick">
  	<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
  	<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
  	</form>
  	</div>
END
  	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'TODO'} = "";
	exit 0;
	}
	
	if ( $qossettings{'TODO'} eq "add rule" )
	{
		print "<a name='addrules'>";
		if ( $qossettings{'PROT'} eq '' )
		{
			&Header::openbox( '100%', 'left', "$Lang::tr{'add a new rule'}" );
		}
		else
		{
			&Header::openbox( '100%', 'left', "$Lang::tr{'edit a rule'}" );
		}	
		print <<END;
		<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit="return validateStandard(this, 'error');" >
		<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'qos rulename'}:</td>
			<td width='33%' align='left'><input type='text' name='RULENAME' value="$qossettings{'RULENAME'}" err="please select a valid Rulename!" required="1"/></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'protocol'}:</td>
			<td width='33%' align='left'><select name='PROT'>
END
			if ( $qossettings{'PROT'} ne '' )
			{
				print "<option value=$qossettings{'PROT'} $selected{'PROT'}{$qossettings{'PROT'}}>$qossettings{'PROT'}</option>";
			}
			$rulefile = "/etc/protocols";
			open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
			@tmp = <FILE>;
			close FILE;
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\ /, $ruleentry );
				next if $tmpline[0] =~ "#";
				print "<option value='$tmpline[0]' $selected{'PROT'}{'$tmpline[0]'}>$tmpline[0]</option>";
			}
			print <<END;
			</select></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'qos mark'}:</td>
			<td width='33%' align='left'><select name='MARK'>
END
			if ( $qossettings{'MARK'} ne '' )
			{
				print "<option value=$qossettings{'MARK'} $selected{'MARK'}{$qossettings{'MARK'}}>$qossettings{'MARK'}</option>";
			}
			else
			{
				$rulefile = "/var/ipcop/qos/settings/tc/classes";
				open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
				@tmp = <FILE>;
				close FILE;
				foreach $ruleentry (sort @tmp)
				{
					@tmpline = split( /\;/, $ruleentry );
					print "<option value='$tmpline[1]' $selected{'MARK'}{'$tmpline[1]'}>$tmpline[1]</option>";
				}
				$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
				open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
				@tmp = <FILE>;
				close FILE;
				foreach $ruleentry (sort @tmp)
				{
					@tmpline = split( /\;/, $ruleentry );
					print "<option value='$tmpline[2]' $selected{'MARK'}{'$tmpline[2]'}>$tmpline[2]</option>";
				}
			}
			print <<END;
			</select></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'source port'}:</td>
			<td width='33%' align='left'><input type='text' name='SPORT' value="$qossettings{'SPORT'}" /></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'dst port'}:</td>
			<td width='33%' align='left'><input type='text' name='DPORT' value="$qossettings{'DPORT'}" /></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'source ip'}:</td>
			<td width='33%' align='left'><input type='text' name='SOURCE' value="$qossettings{'SOURCE'}" /></td>
			<td width='33%' align='left'>
				<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
				<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
				<input type='hidden' name='L7' value='no' />
			</td>
		</tr>
END
		if ( $qossettings{'DEV'} ne "imq0" )
		{
		print <<END;
		<tr>
			<td width='33%' align='right'>$Lang::tr{'destination ip'}:</td>
			<td width='33%' align='left'><input type='text' name='DEST' value="$qossettings{'DEST'}" /></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
END
		}
		if ( $qossettings{'TOS'} ne '' )
		{
			$selected{'TOS'}{'0x00'}                  = '';
			$selected{'TOS'}{'0x02'}                  = '';
			$selected{'TOS'}{'0x04'}                  = '';
			$selected{'TOS'}{'0x08'}                  = '';
			$selected{'TOS'}{'0x10'}                  = '';
			$selected{'TOS'}{'24'}                  = '';
			$selected{'TOS'}{'46'}                  = '';
			$selected{'TOS'}{ $qossettings{'TOS'} } = "selected";
		}
		print <<END;
		<tr>
			<td width='33%' align='right'>TOS:</td>
			<td width='33%' align='left'><select name='TOS'>
				<option value='0x00' $selected{'TOS'}{'0x00'}>Normal-Service</option>
				<option value='0x02' $selected{'TOS'}{'0x02'}>Minimize-Cost</option>
				<option value='0x04' $selected{'TOS'}{'0x04'}>Maximize-Reliability</option>
				<option value='0x08' $selected{'TOS'}{'0x08'}>Maximize-Throughput</option>
				<option value='0x10' $selected{'TOS'}{'0x10'}>Minimize-Delay</option>
				<option value='24' $selected{'TOS'}{'24'}>voice signalling / voice control protocols</option>
				<option value='46' $selected{'TOS'}{'46'}>voice (RTP)</option>
			</select>&nbsp;
			<a href="#" style="cursor: help;" onclick="help=window.open('/toshelp.html','','toolbar=0,location=0,directories=0,status=0,menubar=0,scrollbars=1,resizable=0,width=800,height=640'); return false;">
			<img src="/images/qoshelp.png">
			</a>
			</td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		</table>
END
		print "</form>\n";
		&Header::closebox();

  	print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
  	&Header::closebigbox();
  	print <<END;
  	<div align='right'>
  	<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
  	<input type="hidden" name="cmd" value="_s-xclick">
  	<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
  	<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
  	</form>
  	</div>
END
  	print "<a name='bottom'>";
	&Header::closepage();
	$qossettings{'TODO'} = "";
	exit 0;
	}

	if ( $qossettings{'TODO'} eq "add layer7 rule" )
	{
		print "<a name='addl7rules'>";
#		&Header::openbox( '100%', 'left', "Add l7 rule" );
		if ( $qossettings{'L7PROT'} eq '' )
		{
			&Header::openbox( '100%', 'left', "$Lang::tr{'add a new rule'}" );
		}
		else
		{
			&Header::openbox( '100%', 'left', "$Lang::tr{'edit a rule'}" );
		}
		print "<form method='post' action='$ENV{'SCRIPT_NAME'}' onSubmit=\"return validateStandard(this, 'error');\" >\n";
		print <<END;
		<table CELLSPACING='0' cellpadding='0' width='100%'>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'qos rulename'}:</td>
			<td width='33%' align='left'><input type='text' name='L7RULENAME' value="$qossettings{'L7RULENAME'}" err="please enter a valid Rulename!" required="1" /></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'protocol'}:</td>
			<td width='33%' align='left'><select name='L7PROT'>
END
			if ( $qossettings{'L7PROT'} ne '' )
			{
				print "<option value=$qossettings{'L7PROT'} $selected{'L7PROT'}{$qossettings{'L7PROT'}}>$qossettings{'L7PROT'}</option>";
			}
			$dir = "/etc/l7-protocols/protocols";
			opendir( DIR, "$dir" );
			foreach $direntry ( sort readdir(DIR) )
			{
				next if $direntry eq ".";
				next if $direntry eq "..";
				next if -d "$dir/$direntry";
				@proto = split( /\./, $direntry );
				print "<option value='$proto[0]' $selected{'L7PROT'}{'$proto[0]'}>$proto[0]</option>";
			}
			closedir DIR;
			print <<END;
				</select></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'qos mark'}:</td>
			<td width='33%' align='left'><select name='L7MARK'>
END
			if ( $qossettings{'L7MARK'} ne '' )
			{
				print "<option value=$qossettings{'L7MARK'} $selected{'L7MARK'}{$qossettings{'L7MARK'}}>$qossettings{'L7MARK'}</option>";
			}
			$rulefile = "/var/ipcop/qos/settings/tc/classes";
			open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
			@tmp = <FILE>;
			close FILE;
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				print "<option value='$tmpline[1]' $selected{'L7MARK'}{'$tmpline[1]'}>$tmpline[1]</option>";
			}
			$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
			open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
			@tmp = <FILE>;
			close FILE;
			foreach $ruleentry (sort @tmp)
			{
				@tmpline = split( /\;/, $ruleentry );
				print "<option value='$tmpline[2]' $selected{'L7MARK'}{'$tmpline[2]'}>$tmpline[2]</option>";
			}
			print <<END;
			</select></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		<tr>
			<td width='33%' align='right'>$Lang::tr{'source ip'}:</td>
			<td width='33%' align='left'><input type='text' name='L7SOURCE' value="$qossettings{'L7SOURCE'}" /></td>
			<td width='33%' align='left'>
				<input type='hidden' name='L7DEV' value='$qossettings{'L7DEV'}' />
				<input type='submit' name='ACTION' value='$Lang::tr{'save'}' class="saveButton" />
				<input type='hidden' name='L7' value='yes' />
			</td>
		</tr>
END
		if ( $qossettings{'L7DEV'} ne "imq0" )
		{
		print <<END;
		<tr>
			<td width='33%' align='right'>$Lang::tr{'destination ip'}:</td>
			<td width='33%' align='left'><input type='text' name='L7DEST' value="$qossettings{'L7DEST'}" /></td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
END
		}
		if ( $qossettings{'L7TOS'} ne '' )
		{
			$selected{'L7TOS'}{0x00}                  = '';
			$selected{'L7TOS'}{0x02}                  = '';
			$selected{'L7TOS'}{0x04}                  = '';
			$selected{'L7TOS'}{0x08}                  = '';
			$selected{'L7TOS'}{0x10}                  = '';
			$selected{'L7TOS'}{24}                  = '';
			$selected{'L7TOS'}{46}                  = '';
			$selected{'L7TOS'}{$qossettings{'L7TOS'}} = "selected=\"selected\"";
		}
		print <<END;
		<tr>
			<td width='33%' align='right'>TOS:</td>
			<td width='33%' align='left'><select name='L7TOS'>
				<option value='0x00' $selected{'L7TOS'}{'0x00'}>Normal-Service</option>
				<option value='0x02' $selected{'L7TOS'}{'0x02'}>Minimize-Cost</option>
				<option value='0x04' $selected{'L7TOS'}{'0x04'}>Maximize-Reliability</option>
				<option value='0x08' $selected{'L7TOS'}{'0x08'}>Maximize-Throughput</option>
				<option value='0x10' $selected{'L7TOS'}{'0x10'}>Minimize-Delay</option>
				<option value='24' $selected{'L7TOS'}{'24'}>voice signalling / voice control protocols</option>
				<option value='46' $selected{'L7TOS'}{'46'}>voice (RTP)</option>
			</select>&nbsp;
			<a href="#" style="cursor: help;" onclick="help=window.open('/toshelp.html','','toolbar=0,location=0,directories=0,status=0,menubar=0,scrollbars=1,resizable=0,width=800,height=640'); return false;">
			<img src="/images/qoshelp.png">
			</a>
			</td>
			<td width='33%' align='center'>&nbsp;</td>
		</tr>
		</table>
END
		print "</form>\n";
		&Header::closebox();

  		print "<div align='left'><a href='/cgi-bin/qos.cgi'><font color='#FF5B5B'><b>back to mainmenu</b></font></a></div>";
	 	&Header::closebigbox();
  		print <<END;
	  <div align='right'>
	  <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
	  <input type="hidden" name="cmd" value="_s-xclick">
	  <input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
	  <input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
	  </form>
	  </div>
END
	  print "<a name='bottom'>";
		&Header::closepage();
		$qossettings{'TODO'} = "";
		exit 0;
	}

}


	print "<a name='deleterclasses'>";
	&Header::openbox( '100%', 'left', "$Lang::tr{'qos eddel rootclass'}" );
	print "<a name='rootclasses'>";
	print <<END;
	<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'>
	<tr bgcolor="#FF5B5B">
		<td width="16.66%" align="left">&nbsp;<b>Interface</b></td>
		<td width="16.66%" align="left">&nbsp;<b>Handle</b></td>
		<td width="16.66%" align="left">&nbsp;<b>$Lang::tr{'protocol'}</b></td>
		<td width="16.66%" align="left">&nbsp;<b>$Lang::tr{'qos default class'}</b></td>
		<td width="16.66%" align="left">&nbsp;<b>Maximum Rate</b></td>
		<td width="16.66%" align="center">&nbsp;<b>$Lang::tr{'action'}</b></td>
	</tr>
END
	@otherrules = ();
	if ( open( OTHER, "/var/ipcop/qos/settings/tc/settings" ) )
	{
		@otherrules = <OTHER>;
		close(OTHER);
	}
	$i="";
	foreach $line (@otherrules)
	{
		@temp = split( /\;/, $line );
		$i++;
		if ($i % 2) {
			$bgcolor="#B0B0FF"; }
		else {
			$bgcolor="#E3E3FF"; }
		print <<END;
		<tr>
			<td width="16.66%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[0]</b></td>
			<td width="16.66%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[1]</b></td>
			<td width="16.66%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[2]</b></td>
			<td width="16.66%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[3]</b></td>
			<td width="16.66%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[4]</b></td>
			<td width='16.66%' bgcolor='$bgcolor'>
				<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'><tr>
				<td width="100%" align="right">&nbsp;</td>
				<td width="24" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >	
				<form method='post' action='$ENV{'SCRIPT_NAME'}' />
				<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
				<input type='hidden' name='TCPARENTCLASS' value='$temp[3]' />
				<input type='hidden' name='ACTION' value='create class' />
				<input type='hidden' name='TODO' value='create class' />
				<input type='image' name='$Lang::tr{'add'}' src='/images/add.gif' alt='$Lang::tr{'add'} $Lang::tr{'qos class'}' title='$Lang::tr{'add'} $Lang::tr{'qos class'}' border='0' />
				</form>
				</td>
				<td width="24" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >
				<form method='post' action='$ENV{'SCRIPT_NAME'}' />
				<input type='hidden' name='DEL' value='$temp[0]' />
				<input type='hidden' name='TODO' value='$Lang::tr{'qos add rootclass'}'
				<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
				<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
				<input type='hidden' name='EDIT' value='YES' />
				<input type='hidden' name='ACTION' value='$Lang::tr{'edit'}' />
				<input type='hidden' name='TCPARENTCLASS' value='$temp[3]' />
				<input type='image' name='$Lang::tr{'edit'}' src='/images/edit.gif' alt='$Lang::tr{'edit'}' title='$Lang::tr{'edit'}' border='0' />
				</form>
				</td>
				<td width="24" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >	
				<form method='post' action='$ENV{'SCRIPT_NAME'}' />
				<input type='hidden' name='DEL' value='$temp[0]' />
				<input type='hidden' name='TODO' value='edit classes/rules' />
				<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
				<input type='hidden' name='TCSAVE' value='ROOTCLASS' />
				<input type='hidden' name='ACTION' value='$Lang::tr{'delete'}' />
				<input type='image' name='$Lang::tr{'delete'}' src='/images/delete.gif' alt='$Lang::tr{'delete'}' title='$Lang::tr{'delete'}' border='0' />
				</form>
				</td></tr></table>
			</td>
		</tr>
END
	}
	print "</table>\n";
	print "<table width='100%'>\n";
	print "<tr><td>&nbsp;</td></tr>";
	print "<tr><td width='15%'><form method='post' action='$ENV{'SCRIPT_NAME'}' /><input type='submit' name='TODO' value='$Lang::tr{'qos add rootclass'}' class='defaultButton' /></form></td><td width='10%'><form method='post' action='$ENV{'SCRIPT_NAME'}' /><input type='submit' name='TODO' value='set ack priority' class='defaultButton' /></form></td><td width='33%' align='right'><b>$Lang::tr{'legend'}:&nbsp;&nbsp;</b></td><td width='2%' align='right'><img src='/images/add.gif'></td><td width='10.33%' align='left'>$Lang::tr{'add'} $Lang::tr{'qos class'}</td>";
	print "<td width='2%' align='right'><img src='/images/edit.gif'></td><td width='10.33%' align='left'>$Lang::tr{'edit'} Root$Lang::tr{'qos class'}</td>";
	print "<td width='2%' align='right'><img src='/images/delete.gif'></td><td width='12.33%' align='left'>$Lang::tr{'delete'} Root$Lang::tr{'qos class'}</td></tr>";
	print "</table>\n";
	&Header::closebox();

	$rulefile = "/var/ipcop/qos/settings/tc/classes";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	@tmpline = split( /\;/, $tmp[0] );
	if ( $tmpline[1] ne "" )
	{
		print "<a name='deleteclasses'>";
		&Header::openbox( '100%', 'left', "$Lang::tr{'qos eddel class'}" );
	print "<a name='classes'>";
	print <<END;
	<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'>
	<tr bgcolor="#FF5B5B">
		<td width="11.11%" align="left">&nbsp;<b>Handle</b></td>
		<td width="11.11%" align="left">&nbsp;<b>$Lang::tr{'qos class'}</b></td>
		<td width="11.11%" align="left">&nbsp;<b>Parent</b></td>
		<td width="11.11%" align="left">&nbsp;<b>$Lang::tr{'priority'}</b></td>
		<td width="11.11%" align="left">&nbsp;<b>Bandwidth</b></td>
		<td width="11.11%" align="left">&nbsp;<b>Maximum Bandwidth</b></td>
		<td width="11.11%" align="left">&nbsp;<b>$Lang::tr{'qos burst'}</b></td>
		<td width="11.11%" align="left">&nbsp;<b>$Lang::tr{'qos cburst'}</b></td>
		<td width="11.11%" align="center">&nbsp;<b>$Lang::tr{'action'}</b></td>
	</tr>
END
	@otherrules = ();
	if ( open( OTHER, "/var/ipcop/qos/settings/tc/classes" ) )
	{
		@otherrules = <OTHER>;
		close(OTHER);
	}
	for ( $c = 1 ; $c <= 5 ; $c++ )
	{
		$i="";
		print "<tr bgcolor='#FF5B5B'><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></tr>";
		foreach $line (sort @otherrules)
		{
			@temp = split( /\;/, $line );
			if ( $temp[2] eq $c )
			{
				$i++;
				if ($i % 2) {
					$bgcolor="#B0B0FF"; }
				else {
					$bgcolor="#E3E3FF"; }
				print <<END;
				<tr>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[0]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[1]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[2]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[3]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[4]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[5]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[6]</b></td>
					<td width="11.11%" align="left" bgcolor="$bgcolor" nowrap>&nbsp;<b>$temp[7]</b></td>
					<td width='11.11%' align='center'>
						<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'><tr>
							<td width='100%' bgcolor="$bgcolor">&nbsp;</td>
END
				if ( "x$sammler_running" ne "x" ) {
					print "<td width='20' bgcolor='$bgcolor' class='btnOff' onmouseover=\"showInfo('$temp[1]'); BorderOn(this)\" onmouseout=\"BorderOff(this); return nd();\"><form method='post' action='/cgi-bin/qosgraphs.cgi?graph=$temp[1]:all'><input type='image' src='/images/graph.gif' border='0'  alt='$Lang::tr{'qos showgraphs'}' title='$Lang::tr{'qos showgraphs'}'  /></form></td>";
				} else {
					print "<td width='20' bgcolor='$bgcolor'>&nbsp;</td>";
				}		
				print <<END;	
							<td width="20" align="right" bgcolor="$bgcolor" class="btnOff" onmouseover="BorderOn(this)"  onmouseout="BorderOff(this)" >	
							<form method='post' action='$ENV{'SCRIPT_NAME'}' />
							<input type='hidden' name='L7MARK' value='$temp[1]' />
END
				if ( $temp[1] >= 100 && $temp[1] <= 199 )
				{
					print "<input type='hidden' name='L7DEV' value='$REDDEVICE' />";
				}
				if ( $temp[1] >= 200 && $temp[1] <= 299 )
				{
					print "<input type='hidden' name='L7DEV' value='imq0' />";
				}
				if ( $temp[1] >= 300 && $temp[1] <= 399 )
				{
					print "<input type='hidden' name='L7DEV' value='$netsettings{'GREEN_DEV'}' />";
				}
				if ( $temp[1] >= 400 && $temp[1] <= 499 )
				{
					print "<input type='hidden' name='L7DEV' value='$netsettings{'ORANGE_DEV'}' />";
				}
				if ( $temp[1] >= 500 && $temp[1] <= 599 )
				{
					print "<input type='hidden' name='L7DEV' value='$netsettings{'BLUE_DEV'}' />";
				}
				print <<END;
							<input type='hidden' name='TODO' value='add layer7 rule' />
							<input type='hidden' name='ACTION' value='add layer7 rule' />
							<input type='image' name='$Lang::tr{'qoslink add l7 rules'}' src='/images/addgreen.gif' alt='$Lang::tr{'qoslink add l7 rules'}' title='$Lang::tr{'qoslink add l7 rules'}' />
							</form>
							</td>

							<td width="20" align="right" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >	
							<form method='post' action='$ENV{'SCRIPT_NAME'}' />
							<input type='hidden' name='MARK' value='$temp[1]' />
END
				if ( $temp[1] >= 100 && $temp[1] <= 199 )
				{
					print "<input type='hidden' name='DEV' value='$REDDEVICE' />";
				}
				if ( $temp[1] >= 200 && $temp[1] <= 299 )
				{
					print "<input type='hidden' name='DEV' value='imq0' />";
				}
				if ( $temp[1] >= 300 && $temp[1] <= 399 )
				{
					print "<input type='hidden' name='DEV' value='$netsettings{'GREEN_DEV'}' />";
				}
				if ( $temp[1] >= 400 && $temp[1] <= 499 )
				{
					print "<input type='hidden' name='DEV' value='$netsettings{'ORANGE_DEV'}' />";
				}
				if ( $temp[1] >= 500 && $temp[1] <= 599 )
				{
					print "<input type='hidden' name='DEV' value='$netsettings{'BLUE_DEV'}' />";
				}
				print <<END;
							<input type='hidden' name='TODO' value='add rule' />
							<input type='hidden' name='ACTION' value='add rule' />
							<input type='image' name='$Lang::tr{'qoslink add rules'}' src='/images/addblue.gif' alt='$Lang::tr{'qoslink add rules'}' title='$Lang::tr{'qoslink add rules'}' />
							</form>
							</td>
							<td width="20" align="right" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >	
							<form method='post' action='$ENV{'SCRIPT_NAME'}' />
							<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
							<input type='hidden' name='TCPARENTCLASS' value='$temp[1]' />
END
				if ( $temp[1] >= 100 && $temp[1] <= 199 )
				{
					print "<input type='hidden' name='TCPARENTCLASSRED' value='$temp[1]' />";
				}
				if ( $temp[1] >= 200 && $temp[1] <= 299 )
				{
					print "<input type='hidden' name='TCPARENTCLASSIMQ' value='$temp[1]' />";
				}
				if ( $temp[1] >= 300 && $temp[1] <= 399 )
				{
					print "<input type='hidden' name='TCPARENTCLASSGREEN' value='$temp[1]' />";
				}
				if ( $temp[1] >= 400 && $temp[1] <= 499 )
				{
					print "<input type='hidden' name='TCPARENTCLASSORANGE' value='$temp[1]' />";
				}
				if ( $temp[1] >= 500 && $temp[1] <= 599 )
				{
					print "<input type='hidden' name='TCPARENTCLASSBLUE' value='$temp[1]' />";
				}
				print <<END;
							<input type='hidden' name='TODO' value='create subclass' />
							<input type='hidden' name='ACTION' value='create subclass' />
							<input type='image' name='$Lang::tr{'add'}' src='/images/add.gif' alt='$Lang::tr{'add'} $Lang::tr{'qos subclass'}' title='$Lang::tr{'add'} $Lang::tr{'qos subclass'}' />
							</form>
							</td>
							<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >
							<form method='post' action='$ENV{'SCRIPT_NAME'}' />
							<input type='hidden' name='DEL' value='$temp[1]' />
							<input type='hidden' name='TODO' value='create class' />
							<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
							<input type='hidden' name='TCSAVE' value='CLASS' />
							<input type='hidden' name='TCPARENTCLASS' value='$temp[1]' />
							<input type='hidden' name='EDITCLASS' value='YES' />
							<input type='hidden' name='ACTION' value='$Lang::tr{'edit'}' />
							<input type='image' name='$Lang::tr{'edit'}' src='/images/edit.gif' alt='$Lang::tr{'edit'}' title='$Lang::tr{'edit'}' />
							</form>
							</td>
							<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)' >	
							<form method='post' action='$ENV{'SCRIPT_NAME'}' />
							<input type='hidden' name='DEL' value='$temp[1]' />
							<input type='hidden' name='TODO' value='edit classes/rules' />
							<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
							<input type='hidden' name='TCSAVE' value='CLASS' />
							<input type='hidden' name='ACTION' value='$Lang::tr{'delete'}' />
							<input type='image' name='$Lang::tr{'delete'}' src='/images/delete.gif' alt='$Lang::tr{'delete'}' title='$Lang::tr{'delete'}' />
							</form>
							</td>
							</tr></table>
						</td>
				</tr>
END
			}
		}
	}
	print "</table>\n";
	print "<table width='100%'>\n";
	print "<tr><td>&nbsp;</td></tr>";
	print "<tr><td width=24% align='right'>&nbsp;<b>$Lang::tr{'legend'}:&nbsp;&nbsp;</b></td><td width='2%' align='right'><img src='/images/graph.gif'></td><td width='12.33%' align='center'>$Lang::tr{'qos showgraphs'}</td>";
	print "<td width='2%' align='right'><img src='/images/addgreen.gif'></td><td width='10.33%' align='center'>$Lang::tr{'qoslink add l7 rules'}</td>";
	print "<td width='2%' align='right'><img src='/images/addblue.gif'></td><td width='10.33%' align='center'>$Lang::tr{'qoslink add rules'}</td>";
	print "<td width='2%' align='right'><img src='/images/add.gif'></td><td width='10.33%' align='center'>$Lang::tr{'add'} $Lang::tr{'qos subclass'}</td>";
	print "<td width='2%' align='right'><img src='/images/edit.gif'></td><td width='10.33%' align='center'>$Lang::tr{'edit'} $Lang::tr{'qos class'}</td>";
	print "<td width='2%' align='right'><img src='/images/delete.gif'></td><td width='10.33%' align='center'>$Lang::tr{'delete'} $Lang::tr{'qos class'}</td></tr>";
	print "</table>\n";
	&Header::closebox();

###############
#
# added for subclasse
#
	$rulefile = "/var/ipcop/qos/settings/tc/subclasses";
	open( FILE, "< $rulefile" ) or die "Unable to read $rulefile";
	@tmp = <FILE>;
	close FILE;
	@tmpline = split( /\;/, $tmp[0] );
	if ( $tmpline[1] ne "" )
	{
		print "<a name='deleteclasses'>";
		&Header::openbox( '100%', 'center', "$Lang::tr{'qos eddel subclass'}" );
	print "<a name='subclasses'>";
	print <<END;
	<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'>
	<tr bgcolor="#FF5B5B">
		<td width="12.5%" align="left">&nbsp;<b>$Lang::tr{'qos parentclass'}</b></td>
		<td width="12.5%" align="left">&nbsp;<b>$Lang::tr{'qos subclass'}</b></td>
		<td width="12.5%" align="left">&nbsp;<b>$Lang::tr{'priority'}</b></td>
		<td width="12.5%" align="left">&nbsp;<b>Bandwidth</b></td>
		<td width="12.5%" align="left">&nbsp;<b>Maximum Bandwidth</b></td>
		<td width="12.5%" align="left">&nbsp;<b>$Lang::tr{'qos burst'}</b></td>
		<td width="12.5%" align="left">&nbsp;<b>$Lang::tr{'qos cburst'}</b></td>
		<td width="12.5%" align="center">&nbsp;<b>$Lang::tr{'action'}</b></td>	
	</tr>
END
	@otherrules = ();
	if ( open( OTHER, "/var/ipcop/qos/settings/tc/subclasses" ) )
	{
		@otherrules = <OTHER>;
		close(OTHER);
	}
	for ( $c = 1 ; $c <= 5 ; $c++ )
	{
		$i="";
		print "<tr bgcolor='#FF5B5B'><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td><td style='border-bottom:1px solid #FF5B5B'></td></tr>";
		foreach $line (sort @otherrules)
		{
			@temp = split( /\;/, $line );
			if ( $temp[0] eq $c )
			{
				$i++;
				if ($i % 2) {
					$bgcolor="#B0B0FF"; }
				else {
					$bgcolor="#E3E3FF"; }
				print <<END;
				<tr>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[1]</b></td>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[2]</b></td>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[3]</b></td>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[4]</b></td>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[5]</b></td>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[6]</b></td>
					<td width="12.5%" align="left" bgcolor="$bgcolor">&nbsp;<b>$temp[7]</b></td>
        				<td width="12.5%" align="left" bgcolor="$bgcolor">
          					<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'><tr>
           					<td width='100%' align="left" bgcolor="$bgcolor">&nbsp;</td>
END
				if ( "x$sammler_running" ne "x" ) {
					print "<td width='20' bgcolor='$bgcolor' class='btnOff' onmouseover=\"showInfo('$temp[2]'); BorderOn(this)\" onmouseout=\"BorderOff(this); return nd();\"><form method='post' action='/cgi-bin/qosgraphs.cgi?graph=$temp[2]:all'><input type='image' src='/images/graph.gif' border='0'  alt='$Lang::tr{'qos showgraphs'}' title='$Lang::tr{'qos showgraphs'}'  /></form></td>";
				} else {
					print "<td width='20' bgcolor='$bgcolor'>&nbsp;</td>";
				}		
				print <<END;
						<td width="20" align="right" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>	
						<form method='post' action='$ENV{'SCRIPT_NAME'}' />
						<input type='hidden' name='L7MARK' value='$temp[2]' />
END
				if ( $temp[1] >= 100 && $temp[1] <= 199 )
				{
					print "<input type='hidden' name='L7DEV' value='$REDDEVICE' />";
				}
				if ( $temp[1] >= 200 && $temp[1] <= 299 )
				{
					print "<input type='hidden' name='L7DEV' value='imq0' />";
				}
				if ( $temp[1] >= 300 && $temp[1] <= 399 )
				{
					print "<input type='hidden' name='L7DEV' value='$netsettings{'GREEN_DEV'}' />";
				}
				if ( $temp[1] >= 400 && $temp[1] <= 499 )
				{
					print "<input type='hidden' name='L7DEV' value='$netsettings{'ORANGE_DEV'}' />";
				}
				if ( $temp[1] >= 500 && $temp[1] <= 599 )
				{
					print "<input type='hidden' name='L7DEV' value='$netsettings{'BLUE_DEV'}' />";
				}
				print <<END;
						<input type='hidden' name='TODO' value='add layer7 rule' />
						<input type='hidden' name='ACTION' value='add layer7 rule' />
						<input type='image' name='$Lang::tr{'qoslink add l7 rules'}' src='/images/addgreen.gif' alt='$Lang::tr{'qoslink add l7 rules'} $Lang::tr{'qoslink add l7 rules'}' title='$Lang::tr{'qoslink add l7 rules'}' />
						</form>
						</td>
						<td width="20" align="right" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>	
						<form method='post' action='$ENV{'SCRIPT_NAME'}' />
						<input type='hidden' name='MARK' value='$temp[2]' />
END
				if ( $temp[1] >= 100 && $temp[1] <= 199 )
				{
					print "<input type='hidden' name='DEV' value='$REDDEVICE' />";
				}
				if ( $temp[1] >= 200 && $temp[1] <= 299 )
				{
					print "<input type='hidden' name='DEV' value='imq0' />";
				}
				if ( $temp[1] >= 300 && $temp[1] <= 399 )
				{
					print "<input type='hidden' name='DEV' value='$netsettings{'GREEN_DEV'}' />";
				}
				if ( $temp[1] >= 400 && $temp[1] <= 499 )
				{
					print "<input type='hidden' name='DEV' value='$netsettings{'ORANGE_DEV'}' />";
				}
				if ( $temp[1] >= 500 && $temp[1] <= 599 )
				{
					print "<input type='hidden' name='DEV' value='$netsettings{'BLUE_DEV'}' />";
				}
				print <<END;
						<input type='hidden' name='TODO' value='add rule' />
						<input type='hidden' name='ACTION' value='add rule' />
						<input type='image' name='$Lang::tr{'qoslink add rules'}' src='/images/addblue.gif' alt='$Lang::tr{'qoslink add rules'} $Lang::tr{'qoslink add rules'}' title='$Lang::tr{'qoslink add rules'}' />
						</form>
						</td>

						<td width="20" align="right" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>
						<form method='post' action='$ENV{'SCRIPT_NAME'}' />
						<input type='hidden' name='DEL' value='$temp[2]' />
						<input type='hidden' name='TODO' value='create subclass' />
						<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
						<input type='hidden' name='TCSAVE' value='SUBCLASS' />
						<input type='hidden' name='ACTION' value='$Lang::tr{'edit'}' />
						<input type='hidden' name='TCPARENTCLASS' value='$temp[1]' />
						<input type='hidden' name='EDITSUBCLASS' value='YES' />
						<input type='image' name='$Lang::tr{'edit'}' src='/images/edit.gif' alt='$Lang::tr{'edit'}' title='$Lang::tr{'edit'}' />
						</form>
						</td>
						<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>	
						<form method='post' action='$ENV{'SCRIPT_NAME'}' />
						<input type='hidden' name='DEL' value='$temp[2]' />
						<input type='hidden' name='TODO' value='edit classes/rules' />
						<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
						<input type='hidden' name='TCSAVE' value='SUBCLASS' />
						<input type='hidden' name='ACTION' value='$Lang::tr{'delete'}' />
						<input type='image' name='$Lang::tr{'delete'}' src='/images/delete.gif' alt='$Lang::tr{'delete'}' title='$Lang::tr{'delete'}' />
						</form>
						</td>
						</tr></table>
					</td>
				</tr>
END
			}
		}
	}
	print "</table>\n";
	print "<table width='100%'>\n";
	print "<tr><td>&nbsp;</td></tr>";
	print "<tr><td width=36.33% align='right'>&nbsp;<b>$Lang::tr{'legend'}:&nbsp;&nbsp;</b></td><td width='2%' align='right'><img src='/images/graph.gif'></td><td width='12.33%' align='center'>$Lang::tr{'qos showgraphs'}</td>";
	print "<td width='2%' align='right'><img src='/images/addgreen.gif'></td><td width='10.33%' align='center'>$Lang::tr{'qoslink add l7 rules'}</td>";
	print "<td width='2%' align='right'><img src='/images/addblue.gif'></td><td width='10.33%' align='center'>$Lang::tr{'qoslink add rules'}</td>";
	print "<td width='2%' align='right'><img src='/images/edit.gif'></td><td width='10.33%' align='center'>$Lang::tr{'edit'} $Lang::tr{'qos class'}</td>";
	print "<td width='2%' align='right'><img src='/images/delete.gif'></td><td width='10.33%' align='center'>$Lang::tr{'delete'} $Lang::tr{'qos class'}</td></tr>";
	print "</table>\n";
	&Header::closebox();
}

#
# end for subclasses
#
###############

	print "<a name='deleterules'>";
	&Header::openbox( '100%', 'center', "$Lang::tr{'qos eddel rule'}" );
	print "<a name='otherrules'>";
	print <<END;
	<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'>
	<tr bgcolor="#FF5B5B" >
		<td  align="left" width="10%" nowrap>&nbsp;<b>$Lang::tr{'qos rulename'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'protocol'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'qos mark'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'src port'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'dst port'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'source ip'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'destination ip'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>$Lang::tr{'interface'}</b></td>
		<td  align="left" width="10%">&nbsp;<b>TOS</b></td>
		<td  align="center" width="10%">&nbsp;<b>$Lang::tr{'action'}</b></td>
	</tr>
END
	@otherrules = ();
	if ( open( OTHER, "/var/ipcop/qos/settings/other/rules" ) )
	{
		@otherrules = <OTHER>;
		close(OTHER);
	}
	$i="";
	foreach $line (sort @otherrules)
	{
		$i++;
		@temp = split( /\;/, $line );
		chomp($temp[8]);
		if ($i % 2) {
			$bgcolor="#B0B0FF"; }
		else {
			$bgcolor="#E3E3FF"; }
		print <<END;
	<tr>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[0]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[1]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[2]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[3]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[4]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[5]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[6]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%">&nbsp;<b>$temp[7]</b></td>
		<td  align="left" bgcolor="$bgcolor" width="10%" nowrap>&nbsp;<b>$TOS{$temp[8]}</b></td>
        	<td width="10%" align="left" bgcolor="$bgcolor">
          		<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'><tr>
			<td width="100%" bgcolor="$bgcolor">&nbsp;</td>
			<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>
			<form method='post' action='$ENV{'SCRIPT_NAME'}' />
			<input type='hidden' name='DEL' value='$temp[0]' />
			<input type='hidden' name='TODO' value='add rule' />
			<input type='hidden' name='EDITRULE' value='YES' />
			<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
			<input type='hidden' name='L7' value='no' />
			<input type='hidden' name='ACTION' value='$Lang::tr{'edit'}' />
			<input type='image' name='$Lang::tr{'edit'}' src='/images/edit.gif' alt='$Lang::tr{'edit'}' title='$Lang::tr{'edit'}' />
			</form>
			</td>
			<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>	
			<form method='post' action='$ENV{'SCRIPT_NAME'}' />
			<input type='hidden' name='DEL' value='$temp[0]' />
			<input type='hidden' name='TODO' value='edit classes/rules' />
			<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
			<input type='hidden' name='L7' value='no' />
			<input type='hidden' name='ACTION' value='$Lang::tr{'delete'}' />
			<input type='image' name='$Lang::tr{'delete'}' src='/images/delete.gif' alt='$Lang::tr{'delete'}' title='$Lang::tr{'delete'}' />
			</form>
			</td>
			</tr></table>
	</tr>
END
	}
	print "</table>\n";
	&Header::closebox();

	print "<a name='deletel7rules'>";
	&Header::openbox( '100%', 'center', "$Lang::tr{'qos eddel l7rule'}" );
	print "<a name='l7rules'>";
	print <<END;
	<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'>
		<tr>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>$Lang::tr{'name'}</b></td>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>$Lang::tr{'protocol'}</b></td>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>Mark</b></td>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>Interface</b></td>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>$Lang::tr{'source ip'}</b></td>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>$Lang::tr{'destination ip'}</b></td>
			<td align="left" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>TOS</b></td>
			<td align="center" bgcolor="#FF5B5B" width="12.5%">&nbsp;<b>$Lang::tr{'action'}</b></td>
		</tr>
END
	@l7rules = ();
	if ( open( L7, "/var/ipcop/qos/settings/layer7/rules" ) )
	{
		@l7rules = <L7>;
		close(L7);
	}
	$i=0;
	foreach $line (sort @l7rules)
	{
		$i++;
		if ($i % 2) {
			$bgcolor="#B0B0FF"; }
		else {
			$bgcolor="#E3E3FF"; }
		@temp = split( /\;/, $line );
		chomp($temp[6]);
if ( "x$temp[4]" eq "x" ) { $temp[4]="any"; }
if ( "x$temp[5]" eq "x" ) { $temp[5]="any"; }
		print <<END;
	<tr>
		<td align="left" bgcolor="$bgcolor" width="12.5%">&nbsp;<b>$temp[0]</b></td>
		<td align="left" bgcolor="$bgcolor" width="12.5%">&nbsp;<b>$temp[1]</b></td>
		<td align="left" bgcolor="$bgcolor" width="12.5%">&nbsp;<b>$temp[2]</b></td>
		<td align="left" bgcolor="$bgcolor" width="12.5%">&nbsp;<b>$temp[3]</b></td>
		<td align="left" bgcolor="$bgcolor" width="12.5%">&nbsp;<b>$temp[4]</b></td>
		<td align="left" bgcolor="$bgcolor" width="12.5%">&nbsp;<b>$temp[5]</b></td>
		<td align="left" bgcolor="$bgcolor" width="12.5%" nowrap>&nbsp;<b>$TOS{$temp[6]}</b></td>
        	<td width="12.5%" align="left" bgcolor="$bgcolor">
          		<table width='100%' height='20' cellspacing='0' cellpadding='0' style='margin:0; padding:0; border:0;' align='center'><tr>
			<td width="100%" bgcolor="$bgcolor">&nbsp;</td>
			<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>
			<form method='post' action='$ENV{'SCRIPT_NAME'}' />
			<input type='hidden' name='DEL' value='$temp[0]' />
			<input type='hidden' name='TODO' value='add layer7 rule' />
			<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
			<input type='hidden' name='L7' value='yes' />
			<input type='hidden' name='EDITL7' value='YES' />
			<input type='hidden' name='ACTION' value='$Lang::tr{'edit'}' />
			<input type='image' name='$Lang::tr{'edit'}' src='/images/edit.gif' alt='$Lang::tr{'edit'}' title='$Lang::tr{'edit'}' />
			</form>
			</td>
			<td width="20" align="center" bgcolor="$bgcolor" class='btnOff' onmouseover='BorderOn(this)'  onmouseout='BorderOff(this)'>	
			<form method='post' action='$ENV{'SCRIPT_NAME'}' />
			<input type='hidden' name='DEL' value='$temp[0]' />
			<input type='hidden' name='TODO' value='edit classes/rules' />
			<input type='hidden' name='DEV' value='$qossettings{'DEV'}' />
			<input type='hidden' name='L7' value='yes' />
			<input type='hidden' name='ACTION' value='$Lang::tr{'delete'}' />
			<input type='image' name='$Lang::tr{'delete'}' src='/images/delete.gif' alt='$Lang::tr{'delete'}' title='$Lang::tr{'delete'}' />
			</form>
			</td>
			</tr></table>
		</td>
	</tr>
END
	}
	print "</table>\n";
	&Header::closebox();

	}

	&Header::closebigbox();
	print <<END;
	<div align='right'>
	<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
	<input type="hidden" name="cmd" value="_s-xclick">
	<input type="image" src="https://sslsites.de/ipcop.mh-lantech.de/mhaddonspaypal.gif" border="0" name="submit" alt="Donate to mhaddons.tk !">
	<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">
	</form>
	</div>
END
	&Header::closepage();

sub checkversionenabled
{
	my $localname     = $_[0];
	my $localversion  = $_[1];
	my $i             = 0;
	my @tmpversion    = ();
	my @serverversion = ();
	my $return        = &downloadversions();
	if ( $return =~ m/^HTTP\/\d+\.\d+ 200/ )
	{
		my @online = split( /---Versions---\n/, $return );
		chomp( $online[1] );
		@tmpversion = split( /\;/, $online[1] );
		while ( $tmpversion[$i] )
		{
			@serverversion = split( /\,/, $tmpversion[$i] );
			if ( $serverversion[0] eq $localname )
			{
				if ( $serverversion[1] gt $localversion )
				{
					return "There is a newer version available",
					  $serverversion[1];
				}
				else
				{
					return "0", "0";
				}
			}
			$i++;
		}
	}
	else
	{
		return "unable to connect to mhaddons.tk, please try again later.";
	}
}

sub downloadversions
{
	use IO::Socket;
	use File::Copy;
	unless ( -e "${General::swroot}/red/active" )
	{
		return "could not download latest versions list, not connected";
	}

	my %proxysettings = ();
	&General::readhash( "${General::swroot}/proxy/settings", \%proxysettings );

	my $peer     = 'mh-lantech.css-hamburg.de';
	my $peerport = 80;

	if ( $_ = $proxysettings{'UPSTREAM_PROXY'} )
	{
		( $peer, $peerport ) = (
/^(?:[a-zA-Z ]+\:\/\/)?(?:[A-Za-z0-9\_\.\-]*?(?:\:[A-Za-z0-9\_\.\-]*?)?\@)?([a-zA-Z0-9\.\_\-]*?)(?:\:([0-9]{1,5}))?(?:\/.*?)?$/
		);
	}

	my $sock = '';
	unless (
		$sock = new IO::Socket::INET(
			PeerAddr => $peer,
			PeerPort => $peerport,
			Proto    => 'tcp',
			Timeout  => 5
		)
	  )
	{
		return 'could not connect to mhaddons.tk';
		return 0;
	}
	my $GET_CMD = '';
	$GET_CMD =
	  "GET http://mh-lantech.css-hamburg.de/ipcop/versions.txt HTTP/1.1\r\n";
	$GET_CMD .= "Host: mh-lantech.css-hamburg.de\r\n";
	$GET_CMD .= "Cache-Control: no-cache\r\n";
	$GET_CMD .= "Connection: close\r\n\r\n";
	print $sock "$GET_CMD";

	my $ret = '';
	while (<$sock>)
	{
		$ret .= $_;
	}
	close($sock);
	return $ret;
}
